/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "Matrix.h"

/*void Matrix::init( int r )
{
	vector<int> tmp1, tmp2;
	for( int i = 0; i < size; ++i )
	{
		tmp1.push_back(0);
		tmp2.push_back(135);
	}
	theMatrix.push_back(tmp1);
    theMatrix.push_back(tmp2);
    }*/

vector<int> Matrix::calcConsDist()
{
    int rows = theMatrix.size();
    int cols = theMatrix[0].size();
    if( isEmpty() )
    {
	    cerr << "Can not calculate the hamming distances: No matrix read in!";
	    exit(1);
    }
    vector<int> distances;
    int dist = 0; 
    for( int i = 1; i < rows; ++i )
    {
	    for( int j = 0; j < cols; ++j )
	    {
		    if( theMatrix[i-1][j] != theMatrix[i][j] )
			    ++dist;
	    }
	    distances.push_back(dist);	
	    dist = 0;
    }
    return distances;
}

void Matrix::transpose( void )
{
	if( isEmpty() )
	{
		cerr << "Matrix contains no data: Can not transpose matrix!" << endl;
		exit(1);
	}
	Matrix transp;
	for( unsigned int i = 0; i < theMatrix[0].size(); ++i )
	{
			transp.addRow( getCol(i) );
	}
        theMatrix.clear();
	for( int i = 0; i < transp.size(); ++i )
	{
		theMatrix.push_back( transp.getRow(i) );
	}
}

map< string, vector<int> > Matrix::groupMat( void )
{
    string bucket = "";
    vector<int> rowIndx;
    map< string, vector<int> > buckets;

    for( unsigned int i = 0; i < theMatrix.size(); ++i )
    {
        bucket = "";
        for( unsigned int j = 0; j < theMatrix[i].size(); ++j )
        {
            char desci [10];
            sprintf( desci,"%d", theMatrix[i][j] );
            bucket += desci;    
        }
        //cout << "Bucket: " << bucket << endl;
        map<string, vector<int> >::iterator iter;
        iter = buckets.find(bucket);
        if ( iter == buckets.end() ) //bucket not found
        {
            rowIndx.push_back(i);
            buckets[bucket] = rowIndx;
            rowIndx.clear();
        }
        else
        {
            iter->second.push_back(i);
        }
        
    }
    return buckets;
}

void Matrix::printConsDist( ostream & out )
{
    vector<int> vec;
    vec = calcConsDist();
    for( unsigned int i = 0; i < vec.size(); ++i )
    {
        out << vec[i] << " ";
    }
    out << endl;
}
/*void Matrix::consDist( string path, ostream & out )
{
    string file;
    char stri[140]; 
    for( int k = 1; k <= files; ++k )
    {
        //stri.clear();
		sprintf(stri,"%d",k); //Convert int to string
        file = path + stri + ".mtb";
        cerr << "Calculating consecutive distances for: " << file << endl; 
        vector< vector<string> > matrix;
        matrix = readMat(file); //Matrix from generated logic
        int rows = matrix.size();
        int cols = matrix[0].size();
        int dist = 0; 
        for( int i = 1; i < rows; ++i )
        {
            for( int j = 0; j < cols; ++j )
            {
                if( matrix[i-1][j] != matrix[i][j] )
                    ++dist;
            }
            if( k == 1 )
            {
                vector<int> tmp;
                tmp.push_back(dist);	
                theMatrix.push_back(tmp);
            }
            else
            {
                theMatrix[i-1].push_back(dist);
            }
                //out << dist << endl;
            dist = 0;
        }
    }    
}*/

/*void Matrix::calcDist( string path, ostream & out )
{
	int col, row;
	int n;
	string file, origFile, val, line;
	char str[20];
	vector<int> dist;
	vector< vector<string> > origMatrix;
	vector< vector<string> > otherMatrix;
	n = getSize();
	origFile = path + "0.mtb";
	origMatrix = readMat(origFile); //Matrix from the first, randomly generated logic
	init(origMatrix.size()); //initiliaze the distance matrix

//	cout << "Original Matrix: " << endl;
//	printMat(origMatrix, cout);
//	cout << "rows " << origMatrix.size() << endl; 
//	cout << "cols " << origMatrix[0].size() << endl; 

	for( int i = 1; i <= n; ++i )
	{ 
		sprintf(str,"%d",i); 
		file = path + str + ".mtb";

		otherMatrix = readMat(file);

//		cout << file << "Matrix: " << endl;
//		printMat(otherMatrix, cout);

		dist = calcDistVec(origMatrix, otherMatrix);

		cout << "Distance b/w orig and: " << file << endl;
//		cout << "Num of dists: " << dist.size() << endl;


		if( i == 1 )
		{
			vector<int> tmp;
			for( int j = 0; j < dist.size(); ++j )
			{
				tmp.push_back(dist[j]);	
				theMatrix.push_back(tmp);
				tmp.clear();     
			}
		}
		else
		{
			for( int j = 0; j < dist.size(); ++j )
			{
				theMatrix[j+2].push_back(dist[j]);
			}
			
		}
		dist.clear();
	}
}


vector<int> Matrix::calcDistVec( vector< vector<string> > v1, vector< vector<string> > v2 )
{
	int dist = 0;
	vector< int > vec;
	//cout << "dist1" << endl;
	if( v1.size() != v2.size() )
	{
		cerr << "Cannot compare matrices of different sizes. Terminating..." << endl;
		exit(1);
	} 
	int rows = v1.size();
	int cols = v1[2].size();
	//cout << "here: " << v1[1][0] << endl;
	//cout << "rows " << v1.size() << endl; 
	//cout << "cols " << cols << endl; 
	for( int i = 0; i < rows ; ++i )
	{
		for( int j = 0; j < cols; ++j )
		{
			if( v1[i][j] != v2[i][j] )
				++dist;
		}
		vec.push_back(dist);
		//cout << "Dist: " << dist << "col: " << j << endl;
		dist = 0;
	} 
	return vec;
}
*/

/*Matrix& Matrix::operator=( Matrix &right ) 
{
	theMatrix.clear();
	for( int i=0; i < right.size(); ++i )
		theMatrix.addRow( right.getRow(i) );
	return *this;
}*/
 
bool Matrix::operator==( Matrix  &right ) 
{
	bool rval = true;
	vector<int> row;
	//cerr << "right: " << " rows: " << right.rowSize() << " cols: " << right.colSize() << endl;
	if( (right.rowSize() == int(theMatrix.size())) && ( right.colSize() == int(theMatrix[0].size())) )
	{
		for( unsigned int i = 0; i < theMatrix.size(); ++i )
		{
			row = right.getRow(i);
			for( unsigned j = 0; j < row.size(); ++j )
			{
				if( row[j] != theMatrix[i][j] )
				{
					rval = false;
					return rval;
				}	
			}
		}	
	}	
	else
	{
	  rval = false;
	}
	return rval;

}

int Matrix::rowSize()
{
	return theMatrix.size();
}
int Matrix::colSize()
{
	if( theMatrix.size() > 0 )
		return theMatrix[0].size();
	else
		return 0;
}

//Read column labels from a text file
//labels are assumed to be one per line
void Matrix::readLabels( ifstream & in )
{
    string label;
	while( getline(in, label )) 
	{
        labels.push_back(label);
    }
}

void Matrix::readMat( ifstream & in )
{
	vector<int> tmp;
	string line;
	
    string val;
	while( (!in.eof())) //&& (i < nrows) )
	{
		getline(in, line );
        for( unsigned int j=0; j < line.size(); ++j )
        {
            val = line[j];
            tmp.push_back(atoi(val.c_str()));
        }
		if( line != "" ) 
			theMatrix.push_back(tmp);
		tmp.clear();
	}
}

vector<int> Matrix::getAvgVec( void )
{
    return calcAvgVec();
}

vector<double> Matrix::getStdVec( void )
{
    return calcStdVec();
}

//Print average and std for each col
void Matrix::printStats( ostream & out )
{
    vector<int> avgVec;
    avgVec = calcAvgVec();
    vector<double> stdVec;
    stdVec = calcStdVec();
    out.precision(3);
    out << showpoint;
    for( unsigned int i = 0; i < labels.size(); ++i )
    {
       if( (i % 3) == 0 )
        out << endl;
       out.width(10);
       out << labels[i] << ": ";
       out.width(3);
       out << avgVec[i] << " ";
       out.width(5);
       out << "+/- ";
       out.width(5);
       out << stdVec[i] << " ";  
    }
    out << endl; 
}

void Matrix::printStats_GnuPlot( ostream & out )
{
    vector<int> avgVec;
    avgVec = calcAvgVec();
    vector<double> stdVec;
    stdVec = calcStdVec();
    out.precision(3);
    out << showpoint;
    for( unsigned int i = 0; i < labels.size(); ++i )
    {
       out << i+1 << " " << avgVec[i] << " " << stdVec[i] << endl;  
    }
}

void Matrix::printAvgVec( ostream & out )
{
    vector<int> avgVec;
    avgVec = calcAvgVec();
    for( unsigned int i = 0; i < avgVec.size(); ++i )
    {
        out << avgVec[i] << " ";
    }
    out << endl;
}

void Matrix::printStdVec( ostream & out )
{
    vector<double> stdVec;
    stdVec = calcStdVec();
    for( unsigned int i = 0; i < stdVec.size(); ++i )
    {
        out << stdVec[i] << " ";
    }
    out << endl;
}


vector<double> Matrix::calcStdVec( void )
{
    vector<double> stdVec;
    int sum = 0;
    double mean = 0;
    double std = 0;
    double dSqrSum = 0;
    if( !isEmpty() )
    {
        for( unsigned i = 0; i < theMatrix[0].size(); ++i )
        {
            sum = 0; 
            mean = std = dSqrSum = 0;
            for( unsigned j = 0; j < theMatrix.size(); ++j )
            {
                sum += theMatrix[j][i];
            }
            mean = sum/theMatrix.size();
            for( unsigned j = 0; j < theMatrix.size(); ++j )
            {
                double dSum = fabs(mean - theMatrix[j][i]);
                dSqrSum += dSum*dSum;
            }
            std = sqrt(dSqrSum/theMatrix.size());
            stdVec.push_back(std);
        }
    }
    else
    {
        cerr << "Can not get std vector: Matrix is empty!" << endl; 
        exit(1);
    }
    return stdVec;
}

vector<int> Matrix::calcAvgVec( void )
{
    vector<int> avg;
    int sum = 0;
    int iAvg = 0;
    if( !isEmpty() )
    {
        for( unsigned i = 0; i < theMatrix[0].size(); ++i )
        {
            sum = iAvg = 0;
            for( unsigned j = 0; j < theMatrix.size(); ++j )
            {
                sum += theMatrix[j][i];
            }
            iAvg = sum/theMatrix.size();
            avg.push_back(iAvg);
        }
    }
    else
    {
        cerr << "Can not get avg vector: Matrix is empty!" << endl; 
        exit(1);
    }
    return avg;
}

void Matrix::readMat2( ifstream & in )
{
	vector<int> tmp;
	string line;
 	char * c;
	while( !in.eof() )
	{
		tmp.clear();
		getline(in, line );
		c = strtok( (char*)line.c_str(), " \t");
		while( c != NULL )
		{
			tmp.push_back(atoi(c));
			//cout << "val: " << c << endl;
			c = strtok( NULL, " \t");
		}      
		if( line != "" ) 
			theMatrix.push_back(tmp);
		//cout << "new line" << endl;
	}
}

vector<int> Matrix::getCol( const int & colIndex )
{
	vector<int> col;
	if( colIndex >= 0 )
	{
		for( unsigned int i = 0; i < theMatrix.size(); ++i )
		{
			col.push_back(theMatrix[i][colIndex]);
		}
		return col;
	}
	else
	{
		cerr << "Can not retrieve negative Matrix index!" << endl;
		exit(1);
	}

}

vector<int> Matrix::getCol( const string & colName )
{
	vector<int> col;
    int colIndex;
	if( labels.size() >= 0 )
	{
        bool found = false;
        for( unsigned int k = 0; k < labels.size(); ++k )
        {
            if( labels[k] == colName )
            {
                found = true;
                colIndex = k;
                break;
            }
        }
        if( found )
        {
            for( unsigned int i = 0; i < theMatrix.size(); ++i )
            {
                col.push_back(theMatrix[i][colIndex]);
            }
            return col;
        }
	}
	else
	{
		cerr << "Can not retrieve index! - no labels assigned!" << endl;
		exit(1);
		
	}
	return col;
	
}

vector<int> Matrix::getRow( const int & rowIndex )
{
	if( rowIndex >= 0 )
		return theMatrix[rowIndex];
	else
	{
		cerr << "Can not retrieve negative Matrix index!" << endl;
		exit(1);
	}
}

void Matrix::addRow( const vector<int> & row) 
{
	if (row.size() == 0)
	{
		cerr << "Can not add empty row" << endl;
		return;
	}
	else
	{
		theMatrix.push_back(row);
	}
}

//Add row as a string which is then parsed into columns
void Matrix::addRow_String( const string & row, char * delim) 
{
//    StringUtils su;
    vector<string> strInputVec;
    vector<int> iRow;
	if (row.size() == 0)
	{
		cerr << "Can not add empty row" << endl;
		return;
	}
	else
	{
        //int cnt = su.SplitString( row, delim, strInputVec );
	for( unsigned int i = 0; i < strInputVec.size(); ++i )
        {
            string input = strInputVec[i];
            int val = atoi(input.c_str());
            iRow.push_back(val);
        }
        theMatrix.push_back(iRow);
	}
}

Matrix Matrix::getSubMat( const int & startRow, const int & endRow )
{
	Matrix sub;
	for( int i = startRow; i < endRow; ++i )
	{  
		sub.addRow(theMatrix[i]);
	}
	return sub;
}

bool Matrix::findCycles( int & start, int & end )
{
    int rows = theMatrix.size();
    int cols = theMatrix[0].size();
    int cycleSize = 0;
    int cycleSt = 0;
    int cycleEnd = 0;
    bool cycle;
    if( isEmpty() )
    {
        cerr << "Can not find cycles: Matrix is empty!";
        exit(1);
    }//end if
    else
    {
        vector<int> distances;
        for( int k = 1; k < rows; ++k )
        {
            for( int i = k+1; i < rows; ++i )
            {
            cycle = true;
                for( int j = 0; j < cols; ++j )
                {
                    if( theMatrix[i][j] != theMatrix[k][j] )
                    {
                        cycle = false;
                        //cout << "comparing: i= " << i << ", j= " << j << ": " << theMatrix[i][j] << " and k= " << 
                        //        k << ": " << theMatrix[k][j] << endl;
                        break;
                    }
                }
                if( cycle ) //if we have cycle then note the rows and quit
                {
                    cycleSize = i-k;
                    cycleEnd = i;
                    cycleSt = k;
                    break;
                }
            }
            if( cycle )
            {
                break;
            }
        }
    }//end else
    start = cycleSt;
    end = cycleEnd;
    if( !cycle )
        cerr << "No cycle found" << endl;
    return cycle;
}

void Matrix::printCycles( ostream & out, const int & cycleStart, const int & cycleEnd )
{
    out << "Cycle Length: " << cycleEnd-cycleStart << endl;
    out << endl << "Cycle: " << endl;
    for( int i = cycleStart; i < cycleEnd; ++i )
    {  
        out << i-cycleStart+1 << ": "; 
		for( unsigned int j = 0; j < theMatrix[0].size(); ++j )
		{
			out << theMatrix[i][j];
	//		out << "    ";
		}
		out << endl;
	} 
}

void Matrix::printTheMat( ostream & out )
{
	int rows = theMatrix.size();
	int cols;
	if( rows > 0 )
		cols = theMatrix[0].size();  
	else
	   cols = 0;

	//cout << "rows: " << rows << endl; 
	//cout << "cols " << cols << endl; 
	for( int i = 0; i < rows; ++i )
	{   
		for( int j = 0; j < cols; ++j )
		{
			out << theMatrix[i][j];
			out << "    ";
		}

		out << endl;
	}  
}
void Matrix::printTheMat_MapleTransposedPCAFrmt( ostream & out, const string & runName )
{
	int rows = theMatrix.size();
	int cols;
	if( rows > 0 )
		cols = theMatrix[0].size();  
	else
	   cols = 0;
        out << "fileName := [\"" << runName << "\"];" << endl;
	out << "rows := " << cols << ";" << endl; //TRANSPOSED!!!!
	out << "cols :=" << rows << ";" << endl;
        out << "m := Matrix(" << cols << ", " << rows << ", ["; 
	for( int i = 0; i < cols; ++i )
	{   
		out << "[";
		for( int j = 0; j < rows; ++j )
		{
			out << theMatrix[j][i];
			if( j+1 != rows )
			  out << ",";
	//		out << "    ";
		}

		out << "]";
		if( i+1 != cols )
			out << ",";
	}  
	out << "], datatype = anything, storage = rectangular, order = Fortran_order, shape = []);";
}

void Matrix::printTheMat_MaplePCAFrmt( ostream & out, const string & runName )
{
	int rows = theMatrix.size();
	int cols;
	if( rows > 0 )
		cols = theMatrix[0].size();  
	else
	   cols = 0;
        out << "fileName := [\"" << runName << "\"];" << endl;
	out << "rows := " << rows << ";" << endl;
	out << "cols :=" << cols << ";" << endl;
        out << "m := Matrix(" << rows << ", " << cols << ", ["; 
	for( int i = 0; i < rows; ++i )
	{   
		out << "[";
		for( int j = 0; j < cols; ++j )
		{
			out << theMatrix[i][j];
			if( j+1 != cols )
			  out << ",";
	//		out << "    ";
		}

		out << "]";
		if( i+1 != rows )
			out << ",";
	}  
	out << "], datatype = anything, storage = rectangular, order = Fortran_order, shape = []);";
}
void Matrix::printMat( vector< vector<string> > v, ostream & out )
{
	int rows = v.size();
	//int cols = v[0].size();  
	for( int i = 0; i < rows; ++i )
	{
		for( int j = 0; j < 1; ++j )
		{
			out << v[i][j];
			out << "    ";
		}

		out << endl;
	}  
}
void Matrix::printTheMat( int row, ostream & out )
{
    if( !isEmpty() )
    {
        for( unsigned int j = 0; j < theMatrix[row].size(); ++j )
        {
            out << theMatrix[row][j];
            out << "    ";
        }
    }
    else
    {
        cerr << "Can not print matrix row: Matrix is empty!" << endl;
        exit(1);
    }
	out << endl;
}






