/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <iomanip>
#include <string>
#include <list>

#include "generator.h"

using namespace std;

#define HELP_ERROR 99

void usage_msg ( const string & pname )
{
    cerr << "Usage: " << pname << " : valid flags are :" << endl
        << " -i input_file (file with all the nodes) : required" << endl
        << " -o output_file : required" << endl
        << " -c  : create an input file for ChemChain" << endl
        << " -e  : create an input file for the equation generator" << endl
        << " -t  : create csv tables from ChemChain logic input file" << endl
        << " -s  : create a file with calculated statistics on the logic " << endl
        << " -r  : initial conditions will be generated randomly" << endl
        << " -rt : the functional column of each table will be generated randomly" << endl
        << " -h  : this help screen" << endl;
}

int main( int argc, char * argv[] )
{
    string in_name;
    string out_name;
    string tablesPath = "";
    bool cchain = false;
    bool equations = false;
    bool tables = false;
    bool stats = false;
    bool rand_init = false;
    bool rand_fc = false;

    for ( int i = 1 ; i < argc ; ++i )
    {
        if ( !strcmp( "-h", argv[i] ) || !strcmp( "--help", argv[i] ) )
        {
            usage_msg( argv[0] );
            exit( HELP_ERROR );
        }
        else if ( !strcmp( "-i", argv[i] ) )
        {
            cerr << "input file is '" << argv[++i] << "'" << endl;
            in_name = argv[i];
        }
        else if ( !strcmp( "-o", argv[i] ) )
        {
            cerr << "output file is '" << argv[++i] << "'" << endl;
            out_name = argv[i];
        }
        else if ( !strcmp( "-e", argv[i] ) )
        {
            equations = true;
        }
        else if ( !strcmp( "-c", argv[i] ) )
        {
            cchain = true;
	i++;
	tablesPath = argv[i];
        }
        else if ( !strcmp( "-t", argv[i] ) )
        {
            tables = true;
        }
        else if ( !strcmp( "-s", argv[i] ) )
        {
            stats = true;
        }
        else if ( !strcmp( "-r", argv[i] ) )
        {
            rand_init = true;
        }
        else if ( !strcmp( "-rt", argv[i] ) )
        {
            rand_fc = true;
        }
        
    }
    if ( !in_name.size() || !out_name.size() )
    {
        cerr << "input and output file are required, nothing to do!" << endl;
        usage_msg( argv[0] );
        exit( HELP_ERROR );
    }
    Generator g;
    if ( cchain )
    {
        cerr << "Creating an input file for ChemChain...";
	g.set_tablesPath( tablesPath );
        g.cchain( in_name, out_name, rand_init, rand_fc );
    }
    else if( equations )
    {
        cerr << "Creating a file with logic for genes...";
        g.egen( in_name, out_name, rand_fc );
    }
    else if( tables )
    {
        cerr << "Creating csv logic tables...";
        g.cchainToTables( in_name, out_name );
    }
    else if( stats )
    {
        cerr << "Creating a file with statistics...";
        g.stats( in_name, out_name, rand_fc ); 
    }
    cerr << "done .... " << endl;

    return 0;
}

