/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <fstream>
#include <errno.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <string.h>
#include "Example.h"

using namespace std;

void Example::setup(string path)
{
	/**
	 * This function takes the inputfile and reads all
	 * lines that do not begin with '#' and puts them
	 * into the string vector args.
	 */

	name="Example";
	string s;
	ifstream config;
	config.open((path+"/"+name+"/config.txt").c_str());
	if(config.fail())
	{
		cerr<<"Error openening config file for "<<name<<endl;
		exit(1);
	}

	args.clear();
	config>>s;
	while(!config.eof())
	{
		if(s[0]!='#')
			args.push_back(s);
		config>>s;
	}
	config.close();
}


int Example::getVersion() const 
{ 
	return 1;
}

string Example::getSpecs() 
{
	/**
	 * This function returns the location of the 
	 * specs file you would like the simulation
	 * to use.
	 */
	return specs;
}

string Example::getLogic() 
{
	/**
	 * This function returns the location of the 
	 * logic file you would like the simulation
	 * to use.
	 */
	return logic;
}

bool Example::nSpecs() 
{
	/**
	 * This function will return true if you
	 * have a new specs file to supply to the
	 * Simulation, if you return true the 
	 * function getSpecs() will be called
	 * directly after this one.
	 */
	return false;
}

bool Example::nLogic() 
{
	/**
	 * This function will return true if you
	 * have a new logic file to supply to the
	 * Simulation, if you return true the 
	 * function getLogic() will be called
	 * directly after this one.
	 */
	return false;
}

string Example::retrieveNodeLevel() 
{
	/**
	 * Every iteration, after t is set appriopriately
	 * this function will be called repeatedly untill
	 * you return a blank string. When you return something
	 * other than a blank string simulation will determine
	 * the current level of that boolean node, if one exists
	 * and call sendNodeLevel(string, int) with the node's 
	 * name and level
	 */
	return "";
}

void Example::sendNodeLevel(string, int) 
{
	/**
	 * This function is called to provide the Plugin
	 * with boolean node levels that it has requested.
	 */
	;
}

pair<string, int> Example::setInputNodeLevel() 
{
	/**
	 * After the function midSim() is called, this function
	 * will be called repeatedly untill untill the returned
	 * pair has a blank string in it. When this function
	 * returns a pair without a blank string in it the
	 * Simulation will set teh corresponding Input Node,
	 * if any exists, to the level of the integer in the pair.
	 */
	return make_pair("",0);
}

void Example::initialize()
{
	/**
	 * This function is called at the beggining of the program
	 */
	cout<<"Initialize"<<endl;
}

void Example::preSim()
{
	/**
	 * This function is called before every Simulation, perform
	 * any pre-simulation analysis here.
	 */
	cout<<"PreSim"<<endl;
}

void Example::midSim() 
{
	/**
	 * This function is called every step during a simulation,
	 * perform any ongoing analysis here
	 */
}

void Example::postSim() 
{
	/**
	 * This function will be called after every simulation,
	 * after the output file have been written. perform any
	 * post-simulation analysis here.
	 */

	cout<<"PostSim"<<endl;
	for(size_t i =0; i<args.size(); ++i)
	{
		cout<<args[i];
	}
	cout<<endl;
}

void Example::close()
{
	/**
	 * This function will be called after every simulation
	 * has been completed. Please close any filestreams
	 * that need to be close and free any errant memory.
	 */
}

// the class factories

extern "C" Plugin* create() 
{
	return new Example;
}

extern "C" void destroy(Plugin* p) 
{
	delete p;
}

