/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <fstream>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <string.h>
#include "Generator.h"
#include "FileConverter.h"

using namespace std;

void FileConverter::setup(string path)
{
	name="FileConverter";
	string s;
	ifstream config;
	config.open((path+"/"+name+"/config.txt").c_str());
	if(config.fail())
	{
		cerr<<"Error openening config file for "<<name<<endl;
		exit(1);
	}
	char arr[512];
	config.getline(arr,512);
	while(arr[0]=='#')
		config.getline(arr,512);
	for(int i =0; arr[i]!='\0'; ++i)
		iTables+=arr[i];
	config.getline(arr,512);
	while(arr[0]=='#')
		config.getline(arr,512);
	for(int i =0; arr[i]!='\0'; ++i)
		iNodeList+=arr[i];
	config.getline(arr,512);
	while(arr[0]=='#')
		config.getline(arr,512);
	for(int i =0; arr[i]!='\0'; ++i)
		s+=arr[i];
	if(s=="true")
		rand_init=true;
	else
		rand_init=false;

}

void FileConverter::initialize()
{
	sim = 0;
	Generator g;
	iTables=SIMDIR+"/"+runName+"/Tables";
	system(("mkdir "+iTables+DUMP).c_str());
	string path=iTables+"/nodesList.csv";
	g.printNodesList(specs, logic, path);
	g.cchainToTables(logic, iTables);

}

void FileConverter::preSim()
{
	sim++;
	stringstream s;
	string tempSim;
	s<<sim;
	s>>tempSim;

	Generator g;

	g.set_tablesPath( iTables );
	g.cchain( iTables+"/nodesList.csv", SIMDIR+"/"+runName+"/logic/logic"+tempSim+".txt", rand_init, false );
	logic = SIMDIR+"/"+runName+"/logic/logic"+tempSim+".txt";
}

void FileConverter::midSim() 
{
	if(sim<1)
	{
		if(iTables=="")
		{
			cout<<"No iTables specified in FileConverter.txt!"<<endl;
		}
		else if(iNodeList=="")
		{
			cout<<"No iNodeList specified in FileConverter.txt!"<<endl;
		}
		else
		{
			Generator g;
			g.set_tablesPath(iTables);
			g.cchain(iNodeList, ROOTDIR+"/"+outFile, rand_init, false);
		}
	}
}

void FileConverter::postSim() 
{
	if(sim<1)
	{
		Generator g;
		g.cchainToTables(logic, ROOTDIR+"/"+outFile);
	}
}

// the class factories

extern "C" Plugin* create() 
{
	return new FileConverter;
}

extern "C" void destroy(Plugin* p) 
{
	delete p;
}

