/**
 * @section LICENSE
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <iomanip>
#include <string>
#include <math.h>
#include <list>

using namespace std;
#ifndef GNODE_H
#define GNODE_H

	/**
	 * A Struct representing a node input
	 */
struct Input
{
    string iname;
    int iid;
};

	/**
	 * GNode is a class representing a node for the generator class
	 */
class GNode
{
    friend class Generator;

	///prints information about node n into ostream os
    friend ostream &operator<<( ostream & os, const GNode & n )
    {
        return os << n.name << " - " << n.id << " init: " << n.init << " table: " << n.COLS << " by " << n.ROWS << endl;
    }

    public:
	///GNode Constructor
    GNode( )
    {
        COLS = 0;
        ROWS = 0;
    }
	///GNode destructor
    ~GNode( )
    {
		///returns init
        /*   for( int i = 0; i < ROWS; ++i)   //When uncommented gives the following error:
             free(table[i]);                // *** glibc detected *** double free or corruption (fasttop): 0x09b24c48 ***
        //   Aborted

        free(table);*/
    };
	///returns the number of rows
    int nrows( void )
    {  return ROWS; }
	///returns the number of columns
    int ncols( void )
    {  return COLS; }
	///returns the name of this node
    string get_name(void)
    {  return name; }
	///sets the name, id and initial values
    void set( const string & n, const int & i, const int & _init )
    {
        name = n;
        id = i;
        init = _init;
    }
    bool table_init( const int & );
    void print_table( void );
	///adds an input named n to this node
    void new_input( const Input & n )
    {
        inputs.push_back(n);
    }
    void print_inputs( void );        
	///returns the id
    int get_id( void )
    {   return id;  }
	///returns init
    int get_init( void )
    {   return init; }
    
    private:
    int COLS;
    int ROWS;
    int init;
    string name;
    int id;
    bool **table;
    list<Input> inputs;
};
#endif
