/**
 * @section LICENSE
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef GENERATOR_H
#define GENERATOR_H
#include <iomanip>
#include <iostream>
#include <fstream>
#include <sstream>
#include <list>
#include <string>
#include <vector>
#include <time.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
//#include <boost/regex.hpp>
#include "../../lib/StringUtils.h"
#include "GNode.h"

#define INPUT_START 990 //Our input nodes start at 990 (see the node list: nodes.csv) 

using namespace std;

/**
 * returns int x as a string
 */
static inline string IntToString(int x)
{
	ostringstream o;
	if (!(o << x))
		printf("Error in conversion from int to string \n");
	return o.str();
}

/**
 * returns float x as a string
 */
static inline string FltToString(float x)
{
	ostringstream o;
	if (!(o << x))
		printf("Error in conversion from float to string \n");
	return o.str();
}

/**
 * Generator is a utility that converts
 * input files for ChemChains
 */
class Generator
{
	friend class GNode;
	public:
	///Generator Constructor
	Generator( void ) {} 
	///Generator Destructor
	~Generator( void ) {} 
	void cchain( const string &, const string &, const bool &, const bool & );//Mode to create input file for ChemChain
	void egen( const string &, const string &, const bool & );//Mode to generate a file with logic for the eq. generator
	void cchainToTables( const string &, const string & );
	void set_tablesPath( const string & );
	void printNodesList(string &, string &, string &);
	string get_tablesPath( );

	private:
	list<GNode> gnodes;
	string tablesPath;
	list<Input> control_inputs;
	int find_id( const string & ); //Finds the id of a node by its name
	string find_name( const int & ); //Finds name of a node by its ID
	void print_gnodes( void ); // Display the list of nodes ... for testing only
	void show_tables( void ); //Display the nodes with their truth tables
	bool read_gnodes( const string & ); //Read in the list of nodes from the input file
	bool read_tables( const bool & ); // Read the truth tables for each node
	void err_exit( void ); //Exits program with a message
	vector<string> get_states( GNode &, const bool & ); //Gets states of a node when the function = 1 or 0 
	string get_function( GNode & ); //Retrieves the logic (the last column in the table) of a node  
	bool is_gnode( const string & ); //Checks if the name (string) is a valid node
	int num_1( GNode & ); //Counts the number of 1's in a node
	int num_lines( void ); //Counts the number of lines of the overall logic
	int num_0( GNode & ); //Counts the number of 0's in a node
	void decToBin( int, string & ); //Convert decimal to binary
};
#endif
