//-----------------------------------------------------------------------
//
//  File:    StringUtils.cpp
//
//  Purpose:  STL split string utility
//  Author:    Paul J. Weiss
//
//------------------------------------------------------------------------

//nclude "stdafx.h" // comment if not using precompiled headers in MVC++
#include "StringUtils.h"

/**
 * splits the string based on the provided delimeter
 * and puts the resulting strings into results
 * and returns the number of results
 */
int StringUtils::SplitString(const string& input, 
  const string& delimiter, vector<string>& results)
{
  int iPos = 0;
  int newPos = -1;
  int sizeS2 = delimiter.size();
  int isize = input.size();

  vector<int> positions;

  newPos = input.find (delimiter, 0);

  if( newPos < 0 ) { return 0; }

  int numFound = 0;

  while( newPos > iPos )
  {
    numFound++;
    positions.push_back(newPos);
    iPos = newPos;
    newPos = input.find (delimiter, iPos+sizeS2+1);
  }

  for( unsigned int i=0; i <= positions.size(); i++ )
  {
    string s;
    if( i == 0 ) { s = input.substr( i, positions[i] ); }
    int offset = positions[i-1] + sizeS2;
    if( offset < isize )
    {
      if( i == positions.size() )
      {
        s = input.substr(offset);
      }
      else if( i > 0 )
      {
        s = input.substr( positions[i-1] + sizeS2, 
          positions[i] - positions[i-1] - sizeS2 );
      }
    }
    if( s.size() > 0 )
    {
      results.push_back(s);
    }
  }
  return numFound;
}
