/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <iostream>
#include <fstream>
#include <vector>
#include <errno.h>
#include <string.h>
#include "NodeList.h"
#include "PluginWrapper.h"

	/**
	 * @section DESCRIPTION
	 * The plugin manager class is a class used by Simulation as
	 * a container for PluginWrappers. PluginManager takes care
	 * of loading all of the plugins, initializing them, running 
	 * data between them and the main simulation and closing 
	 * them after the simulation.
	 */
class PluginManager {
	public:
		PluginManager();
		~PluginManager();

		void loadPlugins(string);
		void initialize(void);
		void preSim(void);
		void midSim(NodeList &);
		void postSim(void);
		void close(void);

		void setROOTDIR(string s){ROOTDIR=s;};
		void setOutFile(string s){outFile=s;};
		void setSIMDIR(string s){SIMDIR=s;};
		void setRunName(string s){RunName=s;};
		void setT(int i){t=i;};
		void setDUMP(string s){DUMP=s;};
		void setAnalysisPoint(int i){analysisPt=i;};
		void setLogic(string s){logic=s;};
		void setSpecs(string s){specs=s;};
		string getLogic(void){return logic;};
		string getSpecs(void){return specs;};
		bool fileChange(){return inFileChange;};

	private:
		int lastCalc;
		bool inFileChange;
		vector<PluginWrapper> plugins;
		int t;
		string ROOTDIR;
		string outFile;
		string SIMDIR;
		string RunName;
		string DUMP;
		string logic;
		string specs;
		int analysisPt;
};

#endif
