/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <fstream>
#include <errno.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <string.h>
#include "Plugin.hpp"
#include "PluginWrapper.h"

using namespace std;

PluginWrapper::PluginWrapper(void)
{
	/**
	 * PluginWrapper constructor initializes variables
	 */
	p = NULL;
	opened = false;
	name = "";
}

PluginWrapper::~PluginWrapper(void)
{
	/**
	 * The destructor ensures that the pointer has been closed, but only once
	 */
	if(opened)
		close();
}

void PluginWrapper::open(string s)
{
	/**
	 * opens the library located at s and loads
	 * an instance of that plugin into p
	 */
	cout<<"Loading Plugin "<<s<<endl;
	string file = "./"+s;
	Extension = dlopen(file.c_str(), RTLD_NOW);
    if (!Extension) 
	{
        cerr << "Cannot load Plugin: " << dlerror() << endl;
        exit(1);
    }
	dlerror();

	create_Extension = (create_t*) dlsym(Extension, "create");
    const char* dlsym_error = dlerror();
    if (dlsym_error) 
	{
        cerr << "Cannot load symbol create: " << dlsym_error << endl;
        exit(1);
    }
    
    destroy_Extension = (destroy_t*) dlsym(Extension, "destroy");
    dlsym_error = dlerror();
    if (dlsym_error) 
	{
        cerr << "Cannot load symbol destroy: " << dlsym_error << endl;
        exit(1);
    }

	p = create_Extension();
	
	opened=true;

}

void PluginWrapper::close(void)
{
	/**
	 * ensures that p is properly closed
	 */
	if(opened)
	{
		destroy_Extension(p);
		dlclose(Extension);
	}
	opened=false;
}
