/**
 * @section LICENSE
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef PLUGINWRAPPER_H
#define PLUGINWRAPPER_H

#include <iostream>
#include <fstream>
#include <errno.h>
#include <string.h>
#include "Plugin.hpp"

	/**
	 * @section DESCRIPTION
	 * The PluginWrapper class functions as a holder for
	 * a pointer to a plugin. This class intitializes the
	 * pointer and properly desposes of it afterwards.
	 * Having a wrapper for plugin pointers ensures that
	 * they aren't accidently accessed before or after 
	 * they've been opened.
	 */
class PluginWrapper {
	public:
		PluginWrapper();
		~PluginWrapper();

		void open( string s );
		Plugin* getPlugin(void){return p;};
		void close(void);

	private:
		void* Extension;
		Plugin* p;
		create_t* create_Extension;
		destroy_t* destroy_Extension;
		int version;
		bool opened;
		string name;
};

#endif
