/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <fstream>
#include <errno.h>
#include <cmath>
#include <vector>
#include "../../Plugin.hpp"

using namespace std;

class Example : public Plugin {
	public:
		Example(){name="Example";};
		virtual ~Example(){;};
		virtual void setup(string);
		virtual int getVersion() const; 
		virtual string getSpecs();
		virtual string getLogic();
		virtual bool nSpecs();
		virtual bool nLogic();

		virtual string retrieveNodeLevel();
		virtual void sendNodeLevel(string, int); 

		virtual pair<string, int> setInputNodeLevel();


		virtual void initialize();
		virtual void preSim();
		virtual void midSim();
		virtual void postSim();
		virtual void close();

	private:
		vector<string> args;
		int x;
		int y;
};


