/*
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <cstdlib>
#include <stdlib.h>
#include "GNode.h" 
/**
 * Constructs a table based on the number of inputs
 */
bool GNode::table_init( const int & i )
{
	double r;
	bool rval = true;
	COLS = (i + 1); //Number of columns = # of inputs + 1

	r = pow(2, static_cast<double>(i)); //Num of rows = 2^i. Note that pow will return double
	ROWS = static_cast<int>(r); //Convert back to int from double
	table = (bool**)malloc(ROWS * sizeof(bool *)); //or table = new bool[ROWS];
	if (table == NULL)
	{ 
		printf("Error: malloc could not allocate %d bytes for a\n", ROWS * sizeof(bool *));
		rval = false;
	}
	else
	{
		for( int i = 0; i<ROWS; ++i )
		{
			table[i] = (bool*)malloc(COLS * sizeof(bool));  // or table[i] = new bool[COLS]; 
			if (table[i] == NULL)
			{ 
				printf("Error: malloc could not allocate %d bytes for a\n", COLS * sizeof(bool *));
				rval = false;
			}

		}
	}
	for( int j = 0; j < ROWS; ++j )
		for( int k = 0; k < COLS; ++k )
			table[j][k] = 0;
	//print_table();

	return rval;
}

/**
 * Prints out the inputs to this node
 */
void GNode::print_inputs( void )
{
	list<Input>::const_iterator iter;
	for( iter = inputs.begin(); iter != inputs.end(); ++iter )
	{
		cout << (*iter).iname << "-" << (*iter).iid << endl;
	}
}

/**
 * Prints out the table for this node
 */
void GNode::print_table( void )
{
	for( int j = 0; j < ROWS; ++j )
	{
		for( int k = 0; k < COLS; ++k )
		{
			cout << table[j][k] << " ";
		}
		cout << endl;
	}
}
