/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <errno.h>
#include <stdlib.h>
#include <stdio.h>
#include <dlfcn.h>
#include <string.h>
#include <vector>
#include <fstream>
#include <iostream>
#include <sstream>
#include "PatternsExt.h"
#include "../../NodeList.h"

using namespace std;

void PatternsExt::setup(string path)
{
	stringstream ss;
	name="PatternsExt";
	string s;
	ifstream config;
	config.open((path+"/"+name+"/config.txt").c_str());
	if(config.fail())
	{
		cerr<<"Error openening config file for "<<name<<endl;
		exit(1);
	}

	vector<string> args;
	char arr[1024];
	config.getline(arr, 1024);
	while(!config.eof())
	{
		s="";
		for(int i =0; arr[i]!='\0'; ++i)
			s+=arr[i];
		if(arr[0]!='#')
			args.push_back(s);
		config.getline(arr, 1024);
	}
	config.close();
	if(args.size()>1)
	{
		in_patternSpecsFile = args[0];
		in_patternNodesFile = args[1];
	}
	else
	{
		cerr<<"Error reading inputs for patterns analysis!"<<endl;
		exit(1);
	}


}

void PatternsExt::initialize()
{
	NodeList nl;
	ifstream nodes, logicS, specsS;
	nodes.open(in_patternNodesFile.c_str());
	if(nodes.fail())
	{
		cerr<<"An Error opening Nodes csv file for patterns:"<<in_patternNodesFile<<endl;
	}
	logicS.open(logic.c_str());
	if(nodes.fail())
	{
		cerr<<"Error opening logic file:"<<logic<<endl;
		exit(1);
	}
	specsS.open(specs.c_str());
	if(nodes.fail())
	{
		cerr<<"Error opening specs file:"<<specs<<endl;
		exit(1);
	}

	logicS>>nl;
	specsS>>nl;
	string s="";
	nodes>>s;
	bool error=false;
	while(!nodes.eof())
	{
		if(!nl.isBool(s))
		{
			cerr<<"Patterns node "<<s<<" is not a node in the netowrk"<<endl;
			error = true;
		}

		nodes>>s;
	}
	nodes.close();
	logicS.close();
	specsS.close();
	if(error)
	{
		exit(1);
	}

}

void PatternsExt::midSim() 
{
	if((t+1)==analysisPt)
	{
		stringstream ss;
		string folder;
		ss << analysisPt;
		ss >>folder;
		string avgFileName = SIMDIR+"/"+runName+"/SnapshotAnalysis/"+folder+"/allNodes_avg.csv";
		string labelsFileName = SIMDIR + "/" + runName + "/node_labels.csv";
		string specAvgFile = SIMDIR + "/" + runName + "/SnapshotAnalysis/" + folder + "/patternNodes_avg.csv";
		p.midPatterns(avgFileName, labelsFileName, specAvgFile, in_patternNodesFile);

	}
}

void PatternsExt::postSim() 
{
	string avgFileName = SIMDIR + "/" + runName + "/allNodes_avg.csv";
	string labelsFileName = SIMDIR + "/" + runName + "/node_labels.csv";
	string specAvgFile = SIMDIR + "/" + runName + "/patternNodes_avg.csv";
	p.midPatterns(avgFileName, labelsFileName, specAvgFile, in_patternNodesFile);

	string iSpecsFileName = in_patternSpecsFile;
	string iNodesFileName = in_patternNodesFile;

	string iInNodesFileName = SIMDIR + "/" + runName + "/input_labels.csv";
	string iAvgFileName = SIMDIR + "/" + runName + "/patternNodes_avg.csv";
	string iInAvgFileName = SIMDIR + "/" + runName + "/input_dosages.csv";
	string outPath = SIMDIR + "/" + runName + "/patterns";	

	p.postPatterns(iSpecsFileName, iNodesFileName, iInNodesFileName, iAvgFileName, iInAvgFileName, outPath);
}

// the class factories

extern "C" Plugin* create() 
{
	return new PatternsExt;
}

extern "C" void destroy(Plugin* p) 
{
	delete p;
}

