/**
 * @section LICENSE
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef SIMULATION_H
#define SIMULATION_H

#include <iostream>
#include <fstream>
#include <errno.h>
#include "NodeList.h"
#include "Node.h"
#include "PluginManager.h"
#include "lib/Matrix.h"

	/**
	 * @section DESCRIPTION
	 * The Simulation class is the class which 
	 * main interacts and runs the program, it 
	 * checks the flags and makes desicions about
	 * which mode to run.
	 */
class Simulation {
public:
	Simulation(void);
	~Simulation(void);
	void setup(int, char**);
	void run(void);
	void analysis(void);//runs post simulation analysis

private:
	void calcModeSetup(void);
	void visModeSetup(void);
	void inputFileCheck(void);	
	void simulate(void);//runs the simulation
	void load(void);//loads a previous simulation for analysis
	void inputGenerator(void);//runs the input conversion utility
	void ipause();//pauses (verbose mode)
	void print_help();//prints flags
	string ROOTDIR;
	string SIMDIR;
	string NODESAVGDIR;
	string BITSDIR;
	string LOGICDIR;
	string EXTSDIR;
	string DUMP;
	bool noOutFiles;

	int n; //number of times to run simulation
	ofstream visout, outBits, outInputBits, outAvg, outDosage;
	string visualFile;
	string ext;
	string bitsFileName;
	string inputBitsFileName;
	string runName;
	string in_specsFile;                       
	string in_logicFile;
	string in_patternSpecsFile;
	string in_patternNodesFile;
	string outputFile;
	bool ND2TT;
	bool TT2ND;
	bool patternAnal;
	bool rand_init;
	bool rand_logicMut;
	bool rand_nodeInputs;
	string iTables;
	bool analysisMode;
	int mutRate_nodes;
	int mutRate_logic;
	int cycleSize;
	string cmd;
	string runDir;
	string avgFileName;
	string iNodeList;
	vector< Matrix > cycles;
	bool ptime;
	int runStart;
	int progStart;
	bool visMode;
	bool noBits;
	bool usePlugins;
	PluginManager pManager;
};

#endif
