/**
 * @section LICENSE
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#ifndef MATRIX_H
#define MATRIX_H
#include <vector>
#include <iostream>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <math.h>
#include <map>
#include "StringUtils.h"

using namespace std;

/**
 * The Matrix is used by various parts of the simulation
 * for more complex mathematical analysis
 */
class Matrix
{
    public:
		///Matrix Constructor
        Matrix( ){};
		///Matrix Destructor
        ~Matrix( void ){};
        //void calcDist( string, ostream & );  //Calculates the distances
        //Matrix& operator=( Matrix & );
        bool operator==( Matrix & ); 
        void printTheMat( ostream & );
        void printTheMat_MaplePCAFrmt( ostream &, const string & );
        void printTheMat_MapleTransposedPCAFrmt( ostream &, const string & );
        //void calcDistOrig( string, ostream & );
		///returns the result of private functions calcConsDist(is this nessicary?)
        vector<int> getConsDist( void )
        { return calcConsDist(); }
        void printConsDist( ostream & );
        void transpose( void );        
		///returns the size of the matrix
        int size( void )
        { return theMatrix.size(); } 
        void printTheMat( int, ostream & );
        void printMat( vector< vector<string> >, ostream & );
        bool findCycles( int &, int & );
        Matrix getSubMat( const int &, const int & );
        vector<int> getAvgVec ( void );
        vector<double> getStdVec ( void );
        void printAvgVec ( ostream & );
        void printStdVec ( ostream & );
        void printStats ( ostream & );
        void printStats_GnuPlot ( ostream & );
        map<string, vector<int> > groupMat( void );
        int rowSize( void );
        int colSize( void );
        void addRow( const vector<int> & row);
        void addRow_String( const string &, char * );
        vector<int> getRow( const int & );
        vector<int> getCol( const int & );
        vector<int> getCol( const string & );
		///returns true if the matrix is empty
        bool isEmpty( void )
        {   return (theMatrix.size() == 0); }
		///empties the Matrix
        void clear( void )
        { theMatrix.clear(); }
        void printCycles( ostream &, const int &, const int & );
        /*int getSize( void )
          { return size; };*/
        void readMat( ifstream & ); 
        void readMat2( ifstream & );
        void readLabels( ifstream & );
		///returns labels
        vector<string> getLabels( void )
        { return labels; } 
    private:
        vector< vector<int> > theMatrix;
        vector< string > labels;
        //void init( int );
        vector<int> calcDistVec( vector< vector< string> >, vector< vector<string> > );	
        vector<int> calcConsDist( void );
        vector<int> calcAvgVec ( void );
        vector<double> calcStdVec ( void );
};

#endif
