/*
 * @section LICENSE
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <time.h>
#include "Generator.h"

	/**
	 * Exits the program
	 */
void Generator::err_exit(void)
{
    cout << "Terminating program..." << endl;
    exit(1);
}

	/**
	 * set tablesPath equal to path
	 */
void Generator::set_tablesPath( const string & path )
{
	tablesPath = path;
} 

	/**
	 * returns tablesPath
	 */
string Generator::get_tablesPath( )
{
	return tablesPath;
} 

	/**
	 * Read in the list of nodes from the input file
	 */
bool Generator::read_gnodes( const string & in_file ) 
{
  ifstream file;
  string name, idStr;
  int id, init;
  string str;
  bool complete = true;

  init = 0; //The initial value is 0 unless different in the list of nodes
  
  cout << "\tReading the network nodes..." << endl; 
  file.open( in_file.c_str() );
  if( !file )
  {
    cout << "Error while openning the input file" << endl;
    complete = false;
  }
  else
  {    
    while( !file.eof( ) )
    {    
      while( file >> name >> idStr )
      {
        GNode n;
        Input i;
    	//cerr << "name: " << name << endl;
    	//cerr << "idStr: " << idStr << endl;
        if( idStr[0] == 'I' && idStr[1] == 'N' ) //Read in the controlling nodes
        {
            i.iname = name;
	    int intID = atoi(idStr.substr(2,50).c_str());
	    i.iid = intID;
	    //cerr << "id: " << intID << endl;
            control_inputs.push_back(i);
        }
	else
	{
		id = atoi(idStr.c_str()); 
		getline( file, str ); //get the rest of the line to get the initial value  
		if( str == "1" )
		{
			init = 1;
		}
		init = atoi(str.c_str());
		n.set( name, id, init );
		gnodes.push_back(n); 
	}  
        //else //Read in the network nodes
       

                  //}
      }

    }

    file.close( );
  }
  cout << "\tReading the network nodes.." << (complete ? "done" : "failed") << endl;
  return complete;
}

	/**
	 * Prints out the nodes
	 */
void Generator::print_gnodes( void )
{
    if( gnodes.size() > 0 )
    {
        list<GNode>::const_iterator iter;
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
	{
            cout << (*iter);
	}
    }
    else
        cout << "No nodes found. Make sure the input file contains the nodes!"<<endl;
        
}

	/**
	 * Prints out the tables
	 */
void Generator::show_tables( void )
{
  cout << "table print" << endl;
  if( gnodes.size() > 0 )
    {
        list<GNode>::iterator iter;
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
	{
            cout << (*iter);
	    (*iter).print_table();
	}
    }
    else
        cout << "No nodes found. Make sure the input file contains the nodes!"<<endl;
}

	/**
	 * Returns true if there is a Gnode name
	 */
bool Generator::is_gnode( const string & name )
{
  
    bool rval = false;
        list<GNode>::iterator iter;
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
        {
            if( (*iter).get_name() == name )
            {
                rval = true;
                break;
            }
        }
        if( !rval )
        {
            list<Input>::iterator iter;
            for( iter = control_inputs.begin(); iter != control_inputs.end(); ++iter )
            {
                if( (*iter).iname == name )
                {
                    rval = true;
                    break;
                }
            }
        }
   return rval;

}

	/**
	 * Read in the truth tables for each node
	 */
bool Generator::read_tables( const bool & rand_fc )
{
    bool rval = true; //If all the tables are read in without a problem the function returns true
    string name;
    Input in;
    string filename;
    const string EXT = ".csv";

    if( gnodes.size() > 0 )
    {
        list<GNode>::iterator iter;
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
        {
            ifstream file;
            name = (*iter).get_name();
    //        cout << "Starting node: " << name << endl;
            filename = (get_tablesPath() + "/" + name + EXT);
            file.open( filename.c_str() );
            if( !file )
            {
                cerr << "Error while openning file with table for: " << name << " path: " << filename << endl;
                err_exit();
            }
            else 
            {
                int id;
                int num_inputs;
                string tmp, iname, sval;
                bool bval;
               
                file >> sval;//Get the first word and start parsing    
		while( ( sval != "0" ) && ( sval != "1" ) )
		{	
                    iname = sval;
                    id = find_id( iname );    
                    in.iname = iname;
                    in.iid =  id;
                    if( is_gnode( iname ) )
                      ((*iter).inputs).push_back( in );
                    else
                    {
                      cout << "Invalid input in  " << filename << " logic: " << iname << endl;
                      err_exit(); 
                    }
                    file >> sval;    
                } 
                //Count the num of inputs and initialize the table 
                ((*iter).inputs).pop_back(); //remove the last node which is the node itself
                num_inputs = ((*iter).inputs).size();
                rval =  ( (*iter).table_init( num_inputs ) ? true : false );
                if ( !rval ) //If the table init fails, exit the procedure
                     err_exit();
                
                //Start reading the values and save them into the table
                bval = ( sval == "1" ? 1 : 0 ); //First, sval was already read in above, and is a part of the logic
                while( !file.eof() )              
                {
                    for( int i = 0; i < (*iter).nrows(); ++i )
                    {
                        for( int j = 0; j < (*iter).ncols(); ++j )
                        {
				if( rand_fc == true )
				{			
					if(j ==  ((*iter).ncols() - 1))		
						bval = rand()%2; //Generate 0 or 1 randomly
					//	bval = 0; //Generate 0 or 1 randomly
				}
				(*iter).table[i][j] = bval; //Save the logic in the table
                            file >> tmp; //Read the next char
                            bval = ( tmp == "1" ? 1 : 0 ); //Convert str to bool "1"->1 and "0"->0
                        }
                    } 

                } 
                file.close();
            }
        }
    }        

    else
    {    
        cout << "No nodes found. Make sure the input file contains the nodes!"<<endl; 
        rval = false;
		cout<<(get_tablesPath() + "/" + name + EXT)<<endl;
    }
//show_tables();
//err_exit();
    return rval;

}

	/**
	 * returns the id of node name
	 */
int Generator::find_id( const string & name )
{
    int id;
    bool found = false;
    if( gnodes.size() > 0 )
    {
        list<GNode>::iterator iter;
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
        {
            if( (*iter).get_name() == name )
            {
                found = true;
                id = (*iter).get_id();
                break;
            }
        }

        if( !found )
        {
            list<Input>::iterator iter;
            for( iter = control_inputs.begin(); iter != control_inputs.end(); ++iter )
            {
                if( (*iter).iname == name )
                {
                    found = true;
                    id = (*iter).iid;
                    break;
                }
            }
        }
    }
    else
        cout << "No nodes found. Make sure the input file contains the nodes!";
    if( found )    
        return id;
    else
        return -1;

}

	/**
	 * Gets states of a node when the function = 1 or 0
	 */
vector<string> Generator::get_states( GNode & n, const bool & val )
{
    vector<string> vec;
    int rows, cols;
    string state, bval;
    bool switch_val;

    cols = n.ncols();
    //cout << "cols: " << cols  << endl;
    rows = n.nrows();
    //cout << "rows: " << rows  << endl;
    
    switch_val = ( val == true ? false : true );
    for( int i = 0; i < rows; ++i )
    {
        state = "";
        if( n.table[i][cols-1] == switch_val )
        {
            //    cout << "val: " << n.table[i][cols-1] << endl;
            for( int j = 0; j < cols-1; ++j )
            {
                bval = "";
                bval = ( n.table[i][j] == 1 ? "T" : "F" );
                state += bval;
            }
            vec.push_back(state);
            //          cout << n.get_name() << ": " << state << endl;

        }
    }
    return vec;
}

	/**
	 * Retrieves the logic of a node
	 */
string Generator::get_function( GNode & n )
{
    string function;
    int cols, rows;

    cols = n.ncols();
    rows = n.nrows();
    function = "";
    for( int i = 0; i < rows; ++i )
    {
        function += ( n.table[i][cols-1] == 1 ? "1" : "0" );
    }    

    return function;
}


	/**
	 * Counts the number of 1's in a node
	 */
int Generator::num_1( GNode & n )
{
    int cols;
    int rows;
    int cnt;
   
    cnt = 0;
    cols = n.ncols();
    rows = n.nrows();
    for( int i = 0; i < rows; ++i )
    {
        if( n.table[i][cols-1] == 1 )
            ++cnt;
    }

    return cnt;
}

	/**
	 * counts the number of 0's in a node
	 */
int Generator::num_0( GNode & n )
{
    int cols;
    int rows;
    int cnt;
   
    cnt = 0;
    cols = n.ncols();
    rows = n.nrows();
    for( int i = 0; i < rows; ++i )
    {
        if( n.table[i][cols-1] == 0 )
            ++cnt;
    }


    return cnt;
}

	/**
	 * Counts the number of lines of overall logic
	 */
int Generator::num_lines( void )
{
    int lines;
  
    lines = 0; 
    list<GNode>::iterator iter;
    for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
        lines += (*iter).nrows();

    return lines;
}

	/**
	 * Converts decimal to binary
	 */
void Generator::decToBin( int dec, string & bin )
{
    char d [13];
    int remainder;
    if(dec <= 1) 
    {
        sprintf( d, "%d", dec);
        bin += d;
        return;
        
    }
    remainder = dec%2;
    decToBin(dec >> 1, bin);    
    sprintf( d, "%d", remainder);
    bin += d;
    return;
}

	/**
	 * Creates csv logic tables based on the network information in the infile
	 */
void Generator::cchainToTables(const string & in, const string & out)
{
  ifstream inFile;
  ofstream outFile;
  inFile.open(in.c_str());
  if( !inFile )
  {
      cerr << "Cannot open input file to generate tables" << endl;
      exit(1);
  }
  
  string cmd;
  cmd = "mkdir " + out + "/" + " > /dev/null 2>&1";;
  system(cmd.c_str());

  string line = "";
  vector<string> inputGNodes;
  vector<string> parts;
  vector<string> logic;
  //int n = 16;
  //int inn = 4;
  /*for( unsigned int i = 0; i < n; ++i )
      {
          cout << "Int: " << i << " - ";
          string binary="";
          decToBin(i,binary,"\t");
          int len = binary.size();
          for( unsigned j = 0; j < (inn-len/2); ++j )
              binary.insert(0,"0\t");
          cout << binary << endl;
      }*/
  while ( getline( inFile, line) )
  {
      //////////////// read in a line and parse it ////////////////
      string gnode = "";
      string gnodeVal = "";
      if( line[0] != '*' && line != "") //Not commented lines
      {
          StringUtils su;
          int cnt;
          cnt = su.SplitString( line, ":", parts );
          if( parts.size() > 0 )
          {  
              if( parts[0] == "Bool" ) //logic line
              {
                  gnode = parts[1];
                  gnodeVal = parts[2];
                  cnt = su.SplitString( parts[3], ",", inputGNodes );
                  if( inputGNodes.size() == 0 )  //only one input
                      inputGNodes.push_back(parts[3]);
                  cnt = su.SplitString( parts[4], ",", logic );
                  if( logic.size() == 0 )  //only one input
                      logic.push_back(parts[4]);
        //          cout << "GNode: " << node << "; Default: " << nodeVal << endl;
              }
          }    
      }
      /////////////////////////////////////////////////////////////
      
      ///////////////// create the table //////////////////////////
      ofstream gnodeTable;
      string gnodeTableFile = out + "/" + gnode + ".csv";
      
      gnodeTable.open( gnodeTableFile.c_str( ) );
      if( !gnodeTable )
      {
          cerr << "Cannot open input file to create csv table for: " << gnode << endl;
          exit(1);
      }   

      //print the header containing the input nodes
      for( unsigned int i = 0; i < inputGNodes.size( ); ++i )
      {
          gnodeTable << inputGNodes[i] << "\t";
      }
      gnodeTable << gnode << endl;

      if( inputGNodes.size( ) > 0 )
      {
          int n = (int)pow( 2, inputGNodes.size( ) );
          int ignodeVal = (gnodeVal == "False")?0:1;
         // cout << "GNode: " << gnode << " Default: " << ignodeVal << endl;
          for( /*unsigned*/ int i = 0; i < n; ++i )
          {
              string binary = "";
              decToBin( i,binary );
              int len = binary.size( );

              //pre-fill the string with zeros
              for( unsigned int j = 0; j < (inputGNodes.size( )-len); ++j )
                  binary.insert(0,"0");

              //compare the logic and get the functional value for each state
              bool same;
              for( unsigned int j = 0; j < logic.size( ); ++j )
              {
                  same = true;
                  if( binary.size() != logic[j].size() )
                  {
                      cerr << "The length of the state string is not the same as in the logic file!!" << endl;
                      cerr << "NODE: " << gnode << "Logic State: " << logic[j] << endl;
                      exit(1);
                  }
              //    cout << "State: " << binary << " Logic: " << logic[j] << endl;
                  for( unsigned int k = 0; k < binary.size(); ++ k )
                  {
                      if( ( (binary[k] == '1') && (logic[j][k] != 'T') ) 
                              || ( (binary[k] == '0') && (logic[j][k] != 'F') ) )
                      {
                  //    cout << "not Same" << endl;
                          same = false;
                          break;
                      }
                  } //end for( unsigned int k = 0; k < binary.size() )
                  if( same )
                  {
                    //  cout << "same" << endl;
                      break;
                  }
              }//end for( unsigned int j = 0; j < logic.size( ); ++j )
              
              //print the table
              for( unsigned int x = 0; x < binary.size(); ++x )
              {
                  gnodeTable << binary[x] << "\t";
              }
              
              switch( ignodeVal )
              {
                  case 0:
                  {
                      if( same )
                          gnodeTable << "1" << endl;
                      else
                          gnodeTable << "0" << endl;
                      break;
                  }
                  case 1:
                  {
                      if( same )
                          gnodeTable << "0" << endl;
                      else
                          gnodeTable << "1" << endl;
                      break;
                  }
              }//end switch
          }//end for( unsigned int i = 0; i < n; ++i )
      }
      /////////////////////////////////////////////////////////////
      
      //////////////// clear out all the vectors //////////////////
      parts.clear();
      logic.clear();
      inputGNodes.clear();  
      /////////////////////////////////////////////////////////////
  }// end while
  inFile.close();

}

	/**
	 * Mode to create input file for ChemChain
	 */
void Generator::cchain( const string & in, const string & out, const bool & rand_init, const bool & rand_fc)
{
    list<GNode>::iterator iter;
    vector<string> states;
    string str_states, str, inpts, sinit_cond;
    int iinit_cond;
    ofstream file;
    bool binit_cond;
 
    if ( !read_gnodes( in ) )
        cout << "GNodes not read in properly!!! See the errors above" << endl;
    else
    {
        cout << "\tReading in the truth tables..." << ( read_tables( rand_fc )  ? "OK" : "Failed" ) << endl;      
        //Find all the states to randomly generated functional values
        file.open( out.c_str(), ios::out ); //Open file for writting mode
        file << "* Boolean nodes" << endl;
        file << "***************" << endl;
        file << "*Bool:name:initial value:names of input nodes:input values for which" << endl;
        file << "*it should be different from initial value" << endl;
        file << "*--------------------------------------------------------------------------------------------------"
             << endl;
        
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
        {
            if( rand_init )
			{
                iinit_cond = rand()%2; //Generate 0 or 1 randomly
			}
            else
                iinit_cond = (*iter).get_init(); //Use the specified initial condition
            
            sinit_cond = ( iinit_cond == 1 ? "True" : "False" );
            binit_cond = ( iinit_cond == 1 ? true : false );

            states = get_states( (*iter), binit_cond );
            str_states = "";
            for( unsigned int i = 0; i < states.size(); ++i )
            {
                str_states += states[i];
                str_states += ",";
            }    
            
           if( str_states.size() > 0 ) 
	     str_states = str_states.erase( (str_states.size() - 1), 1 ); //Remove the last comma
            inpts = "";
            list<Input>::iterator iter2;
            for( iter2 = (*iter).inputs.begin(); iter2 != (*iter).inputs.end(); ++iter2 )
            {
                inpts += (*iter2).iname;
                inpts += ",";
            }
            inpts = inpts.erase( (inpts.size() - 1), 1 ); //Remove the last comma

            str = "Bool:" + (*iter).get_name() + ":" + sinit_cond + ":" + inpts + ":" + str_states;
            //cout << str << endl;
	    file << str << endl;
        }
        file.close();
    }
}

	/**
	 * Mode to generate a file with logic for the eq. generator
	 */
void Generator::egen( const string &in, const string &out, const bool & rand_fc)
{
    ofstream file;
    string logic, str, inpts;
    list<GNode>::iterator iter;

    if ( !read_gnodes( in ) )
        cout << "GNodes not read in properly!!! See the errors above" << endl;
    else
    {
        cout << "Reading in the truth tables..." << ( read_tables( rand_fc ) ? "OK" : "Failed" ) << endl;      

        //Find all the states to randomly generated functional values
        file.open( out.c_str(), ios::out ); //Open file for writting mode
        for( iter = gnodes.begin(); iter != gnodes.end(); ++iter )
        {

            logic = get_function( (*iter) );
            
            list<Input>::iterator iter2;
            inpts = "";
            for( iter2 = (*iter).inputs.begin(); iter2 != (*iter).inputs.end(); ++iter2 )
            {
                inpts += IntToString((*iter2).iid);
                inpts += ",";
            }
            inpts = inpts.erase( (inpts.size() - 1), 1 ); //Remove the last comma
            
            str = (*iter).get_name() + ":" + inpts + ":" + logic;
            file << str << endl;
        }
        file.close();
    }
}

	/**
	 * This function takes in network specs and logic and creates a list of nodes
	 */
void Generator::printNodesList(string & specs, string & logic, string & out)
{
      ofstream out_nodesList;
      
      out_nodesList.open( out.c_str( ) );
      if( !out_nodesList )
      {
          cerr << "Cannot open "<<out << "for list creation" << endl;
          exit(1);
      }   

      	ifstream in_specs, in_logic;

	in_specs.open(specs.c_str());
	if (in_specs.fail()) 
	{
		cerr << "Unable to open " << in_specs << " for specs file" << endl;
		exit(1);
	}
	in_logic.open(logic.c_str());
	if (in_logic.fail()) 
	{
		cerr << "Unable to open " << in_logic << " for logic file" << endl;
		exit(1);
	}

	int nodeCount=1;
	string line="";
	StringUtils su;
	while ( getline( in_logic, line) )
	{
		vector<string> parts;
		su.SplitString( line, ":", parts );
		if ((parts.size()>0)&&(parts[0] == "Bool")) 
		{
			out_nodesList<<parts[1]<<"\t"<<nodeCount<<endl;
			++nodeCount;
		}
	}
	while ( getline( in_specs, line) )
	{
		vector<string> parts;
		su.SplitString( line, ":", parts );
		if ((parts.size()>0)&&((parts[0] == "Input")||(parts[0]=="Sustain")||parts[0]=="Delay")) 
		{
			out_nodesList<<parts[1]<<"\t"<<"IN"<<nodeCount<<endl;
			++nodeCount;
		}
	}
	out_nodesList.close();
	in_specs.close();
	in_logic.close();

}


