/**
 *   Copyright (C) 2004-2008 Tomas Helikar & Mathbio Research Group, Department of Mathematics, University of Nebraska at Omaha 
 * 
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   as published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <iostream>
#include <fstream>
#include <errno.h>
#include <cmath>
#include "../../Plugin.hpp"
#include "Patterns.h"

using namespace std;

class PatternsExt : public Plugin {
	public:
		virtual ~PatternsExt(){name="PatternsExt";};
		virtual void setup(string);
		virtual int getVersion() const { return 1;};
		virtual string getSpecs() {return specs;};
		virtual string getLogic() {return logic;};
		virtual bool nSpecs() {return false;};
		virtual bool nLogic() {return false;};

		virtual string retrieveNodeLevel() {return "";};
		virtual void sendNodeLevel(string, int) {;};

		virtual pair<string, int> setInputNodeLevel() {return make_pair("",0);};


		virtual void preSim(){;};
		virtual void initialize();
		virtual void midSim();
		virtual void postSim();
		virtual void close(){;};

	private:
		Patterns p;
		string in_patternSpecsFile;
		string in_patternNodesFile;


};


