//Copyright (C) 2000 Paul Stothard
function checkAlign (arrayOfTitles,arrayOfSequences)	{
	var lengthOfAlign = arrayOfSequences[0].length;
	if (arrayOfSequences.length < 2)	{
		alert ("Please enter an alignment consisting of at least two sequences.");
		return false;
	}
	for (var i = 0; i < arrayOfTitles.length; i++)	{
		if ((arrayOfTitles[i].search(/\S/) == -1) || (arrayOfSequences[i].search(/\S/) == -1) || (arrayOfSequences[i].length != lengthOfAlign))	{
			alert ("There is a problem with the alignment format.");
			return false;
		}
	}
	return true;
}
function checkFormElement (formElement)	{
	if (formElement.value.search(/\S/) == -1)	{
		alert ("The form has not been filled out completely.");
		return false;
	}
	return true;
}
function checkGroupInput (arrayOfPatterns)	{
	var z = 0;
	while (z < arrayOfPatterns.length)	{
		if (arrayOfPatterns[z].search(/[^acdefghiklmnpqrstvwyz]/i) != -1)	{	
			alert ("One or more groups have been entered incorrectly.");
			return false;
		}
		z = z + 1;
	}
	for (var i = 0; i < arrayOfPatterns.length; i++)	{
		var re = new RegExp ("[" + arrayOfPatterns[i] + "]","gi");
		for (var j = i + 1; j < arrayOfPatterns.length; j++)	{
			if (arrayOfPatterns[j].search(re) != -1)	{
				alert('The same amino acid is in more than one similarity group.');
				return false;
			}
		}
	}
	return true;
}
function checkIdent (columnSeq,aminoAcid)	{
	var re = new RegExp (aminoAcid,"gi");
	return (columnSeq.match(re)).length;
}
function checkSim (columnSeq,aminoAcid,arrayOfGroups)	{
	var result = 1;
	var re = new RegExp (aminoAcid,"gi");
	for (var m = 0; m < arrayOfGroups.length; m++)	{
		if (arrayOfGroups[m].search(re) != -1)	{
			var re = new RegExp ("[" + arrayOfGroups[m] + "]","gi");
			result = (columnSeq.match(re)).length;
			break;
		}
	}
	return result;
}
function closeWindow ()	{
	outputWindow.document.write ("</body></html>");
	outputWindow.document.close();
	return true;
}
function colorAlignCombosa (arrayOfTitles,arrayOfSequences,basePerLine,frontOrBack,identColor,simColor,consensus,noMatchColor,gapColor,arrayOfGroups,positions)	{
	top.window.status = 'Please Wait...';
	if (frontOrBack == 'front')	{
		var belowConsensusGapColor = "#000000, #FFFFFF";
	}
	else	{
		var belowConsensusGapColor = "#FFFFFF, #000000";
	}
	var amAcids = ["-",".","A","C","D","E","F","G","H","I","K","L","M","N","P","Q","R","S","T","V","W","Y","X"];
	var identColors = [gapColor,gapColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,identColor,noMatchColor];
	var simColors = [gapColor,gapColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,simColor,noMatchColor];
	var noMatchColors = [belowConsensusGapColor,belowConsensusGapColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor,noMatchColor];
	var delColors = [gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor,gapColor];
	var lineOfText = "";
	var spacerLine = "";
	var spacerLineLength = 0;
	var totalBasesShown = 0; 
	var columnSeq = "";
	var mouseTagStart = "";
	var mouseTagEnd = '</A>';
	consensus = (parseInt(consensus)) / 100;
	basePerLine = parseInt(basePerLine);
	var i = 0;
	var baseSolvedCounter = positions[positions.length - 1];
	openWindow();
	outputWindow.document.write('<table border=0 cellspacing=0 cellpadding=1>');
	while (totalBasesShown < arrayOfSequences[0].length)	{
		for (var jj = 0; jj < arrayOfSequences.length; jj++)	{
			while ((i < (totalBasesShown + basePerLine)) && (i < arrayOfSequences[0].length))	{
				for (var k = 0; k < arrayOfSequences.length - 1; k++)	{
					columnSeq = columnSeq + arrayOfSequences[k].charAt(i);
				}
				if (jj == arrayOfSequences.length - 1)	{
					if ((arrayOfSequences[jj].charAt(i) == "-") || (arrayOfSequences[jj].charAt(i) == "."))	{
						lineOfText = lineOfText + '<td nowrap="true" ALIGN="center" VALIGN="center"><font size=' + theFontSize + '><font face="' + theFontFace + '">' + '-' + '</font></font></td>';
					}
					else	{
						mouseTagStart = '<A href="javascript: window.focus()" onMouseover="status=' + "'" + oneToThree(arrayOfSequences[jj].charAt(i)) + ' ' + (baseSolvedCounter + 1) + "'" + '; return true;" onMouseout="status=' + "' '" + '; return true;">';
						if ((delCheck(columnSeq) / columnSeq.length) >= consensus)	{
							baseSolvedCounter = baseSolvedCounter + 1;
							lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,delColors,frontOrBack,mouseTagStart,mouseTagEnd);
						}
						else	{
							if ((identCheck(columnSeq) / columnSeq.length) >= consensus)	{
								baseSolvedCounter = baseSolvedCounter + 1;
								lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,identColors,frontOrBack,mouseTagStart,mouseTagEnd);
							}
							else	{
								if ((simCheck(columnSeq,arrayOfGroups) / columnSeq.length) >= consensus)	{
									baseSolvedCounter = baseSolvedCounter + 1;
									lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,simColors,frontOrBack,mouseTagStart,mouseTagEnd);
								}
								else	{
									baseSolvedCounter = baseSolvedCounter + 1;
									lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,noMatchColors,frontOrBack,mouseTagStart,mouseTagEnd);
								}
							}
						}
					}
				}
				else	{
					if (checkIdent(columnSeq,arrayOfSequences[jj].charAt(i)) / columnSeq.length >= consensus)	{
						lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,identColors,frontOrBack,'','');
					}
					else	{
						if (checkSim(columnSeq,arrayOfSequences[jj].charAt(i),arrayOfGroups) / columnSeq.length >= consensus)	{
							lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,simColors,frontOrBack,'','');
						}
						else	{
							lineOfText = lineOfText + makeTag (arrayOfSequences[jj].charAt(i),amAcids,noMatchColors,frontOrBack,'','');
						}
					}
				}
				i = i + 1;
				columnSeq = "";
			}
			positions[jj] = positions[jj] + ((arrayOfSequences[jj].substring(totalBasesShown,i)).replace(/\.|\-/g,"")).length;
			if (arrayOfSequences[0].length > basePerLine)	{
				for (var kk = i; kk < (totalBasesShown + basePerLine); kk++)	{
					lineOfText = lineOfText + '<td></td>';
				}
			}
			outputWindow.document.write('<tr><td nowrap="true" align="right"><font size=' + theFontSize + '><font face="' + theFontFace + '">' + arrayOfTitles[jj].substring(0,arrayOfTitles[jj].length - 1) + '</font></font></td><td><FONT size=' + theFontSize + '><FONT face="Courier New,Courier"><FONT color="#FFFFFF">-</FONT></FONT></FONT></td>' + lineOfText + '<td><FONT size=' + theFontSize + '><FONT face="Courier New,Courier"><FONT color="#FFFFFF">-</FONT></FONT></FONT></td><td nowrap="true" align="left"><font size=' + theFontSize + '><font face="' + theFontFace + '">' + positions[jj] + '</font></font></td></tr>\n');
			lineOfText = "";
			if (jj == arrayOfSequences.length - 2)	{
				spacerLine = '<tr><td nowrap="true" align="right"></td><td><FONT size=' + theFontSize + '><FONT face="Courier New,Courier"><FONT color="#FFFFFF">-</FONT></FONT></FONT></td>';
				if ((i - totalBasesShown) > basePerLine)	{
					spacerLineLength = basePerline;
				}
				else	{
					spacerLineLength = i - totalBasesShown;
				}
				for (var kk = 0; kk < spacerLineLength; kk++)	{
					spacerLine = spacerLine + '<td ALIGN="center" VALIGN="center"><font size=' + theFontSize + '><font face="' + theFontFace + '">' + '=' + '</font></font></td>';
				}
				outputWindow.document.write(spacerLine + '</tr>\n');
			}
			spacerLine = '';
			i = totalBasesShown;
		}
		totalBasesShown = totalBasesShown + basePerLine;
		i = totalBasesShown;
		outputWindow.document.write('<tr><td><FONT size=' + theFontSize + '><FONT face="Courier New,Courier"><FONT color="#FFFFFF">I</FONT></FONT></FONT></td></tr>\n');
	}
	outputWindow.document.write('</table>');
	outputWindow.document.close();
	outputWindow.status = 'Done.';
	top.window.status = 'Done.';
	return true;
}
function delCheck (columnSeq)	{
	if (columnSeq.search(/\.|\-/g) != -1)	{
		return (columnSeq.match(/\.|\-/g)).length;
	}
	else	{
		return 0;
	}
}
function earlyCheckAlign (alignArray)	{
	if (alignArray.length < 3)	{
		alert ("There is a problem with the alignment format.");
		return false;
	}
	for (var i = 1; i < alignArray.length; i++)	{
		if (alignArray[i].search(/[^\s]+\s/) == -1)	{
			alert ("There is a problem with the alignment format.");
			return false;
		}
	}
	return true;
}
function filterAlignSeq (alignSeq)	{
	alignSeq = alignSeq.replace(/[^acdefghiklmnpqrstvwyx\.\-]/gi,"");
	return alignSeq;
}
function filterFastaTitle (sequenceTitle)	{
	sequenceTitle = sequenceTitle.replace(/\s{2,}/g," ");
	return sequenceTitle.replace (/[\<\>;]/gi,"");
}
function getSequence (theForm,showAlignment) {	
	var theAlignment = "";
	var alignArray = new Array;
	var groupString = "";
	var arrayOfGroups = new Array;
	if ((checkFormElement (theForm.elements[0]) == false) || (checkFormElement (theForm.elements[2]) == false) || (checkFormElement (theForm.elements[15]) == false))	{
		return false;
	}
	theAlignment = "X" + theForm.elements[0].value + theForm.elements[2].value;
	alignArray = theAlignment.split(/[>%]/);
	groupString = (theForm.elements[15].value.replace(/\s/g,"")).toUpperCase();
	arrayOfGroups = groupString.split(/,/);
	if (checkGroupInput (arrayOfGroups) == false)	{
		return false;
	}
	if (earlyCheckAlign (alignArray) == false)	{
		return false;
	}
	prepareAlign (alignArray);
	if (checkAlign (titleArray,sequenceArray) == false)	{
		return false;
	}
	var startsForAlignment = splitDigitList(theForm.elements[1].value.replace(/\s/g,""));
	var startsForChime = splitDigitList(theForm.elements[3].value.replace(/\s/g,""));
	startsForAlignment[startsForAlignment.length - 1] = startsForChime[0];
	if (showAlignment)	{
		theFontFace = theForm.elements[17].options[theForm.elements[17].selectedIndex].value;
		theFontSize = theForm.elements[18].options[theForm.elements[18].selectedIndex].value;
		colorAlignCombosa (titleArray,sequenceArray,theForm.elements[16].options[theForm.elements[16].selectedIndex].value,theForm.elements[19].options[theForm.elements[19].selectedIndex].value,theForm.elements[6].options[theForm.elements[6].selectedIndex].value,theForm.elements[7].options[theForm.elements[7].selectedIndex].value,theForm.elements[8].options[theForm.elements[8].selectedIndex].value,theForm.elements[9].options[theForm.elements[9].selectedIndex].value,theForm.elements[5].options[theForm.elements[5].selectedIndex].value,arrayOfGroups,startsForAlignment);
	}
	else	{
		makeColorsForScript (sequenceArray,titleArray,theForm.elements[5].options[theForm.elements[5].selectedIndex].value,theForm.elements[6].options[theForm.elements[6].selectedIndex].value,theForm.elements[7].options[theForm.elements[7].selectedIndex].value,theForm.elements[8].options[theForm.elements[8].selectedIndex].value,theForm.elements[9].options[theForm.elements[9].selectedIndex].value,theForm.elements[10].options[theForm.elements[10].selectedIndex].value,theForm.elements[11].checked,theForm.elements[12].checked,theForm.elements[13].checked,theForm.elements[14].checked,arrayOfGroups,startsForChime[0]);
	}
	return true;
}
function identCheck (columnSeq)	{
	var result = 1;
	var bigResult = 1;
	for (var m = 0; m < columnSeq.length; m++)	{
		if (columnSeq.charAt(m).toUpperCase() != "X")	{
			var re = new RegExp (columnSeq.charAt(m),"gi");
			result = (columnSeq.match(re)).length;
		}
		if (result > bigResult)	{
			bigResult = result;
		}
	}
	return bigResult;
}
function makeColorsForScript (arrayOfSequences,arrayOfTitles,colorDel,colorIdent,colorSim,consensus,colorNoMatch,colorDefault,labelGaps,labelIdentical,labelSimilar,labelNoMatch,arrayOfGroups,realBase)	{
	top.window.status = 'Please Wait....';
	var tempColorArray = new Array;
	var comparisonTitles = '';
	var solvedTitle = '';
	var scriptTextCombosa = '#script generated by COMBOSA3D; ';
	tempColorArray = colorDel.split(/\,\s/);
	colorDel = 'color ' + tempColorArray[2] + '; ';
	scriptTextCombosa = scriptTextCombosa + '#indels = ' + tempColorArray[2] + ' (' + tempColorArray[3] + '); ';
	if (labelGaps)	{
		colorDel = colorDel + 'label residue; ';
	}
	tempColorArray = colorIdent.split(/\,\s/);
	colorIdent = 'color ' + tempColorArray[2] + '; ';
	scriptTextCombosa = scriptTextCombosa + '#identities = ' + tempColorArray[2] + ' (' + tempColorArray[3] + '); ';
	if (labelIdentical)	{
		colorIdent = colorIdent + 'label residue; ';
	}
	tempColorArray = colorSim.split(/\,\s/);
	colorSim = 'color ' + tempColorArray[2] + '; ';
	scriptTextCombosa = scriptTextCombosa + '#similarities = ' + tempColorArray[2] + ' (' + tempColorArray[3] + '); ';
	if (labelSimilar)	{
		colorSim = colorSim + 'label residue; ';
	}
	tempColorArray = colorNoMatch.split(/\,\s/);
	colorNoMatch = 'color ' + tempColorArray[2] + '; ';
	scriptTextCombosa = scriptTextCombosa + '#below consensus = ' + tempColorArray[2] + ' (' + tempColorArray[3] + '); ';
	if (labelNoMatch)	{
		colorNoMatch = colorNoMatch + 'label residue; ';
	}
	tempColorArray = colorDefault.split(/\,\s/);
	colorDefault = 'color ' + tempColorArray[2] + '; ';
	scriptTextCombosa = scriptTextCombosa + '#outside of alignment = ' + tempColorArray[2] + ' (' + tempColorArray[3] + '); ';
	for (var i = 0; i < (arrayOfTitles.length - 1); i++)	{
		comparisonTitles = comparisonTitles + arrayOfTitles[i].substring(0,arrayOfTitles[i].length - 1) + ',';
	}
	comparisonTitles = comparisonTitles.substring(0,comparisonTitles.length - 1);
	solvedTitle = arrayOfTitles[i].substring(0,arrayOfTitles[i].length - 1);
	scriptTextCombosa = scriptTextCombosa + '#consensus requirement: ' + consensus + '; #similar groups: ' + arrayOfGroups + '; #comparison sequence titles: ' + comparisonTitles + '; #solved sequence title: ' + solvedTitle + '; #end of comments; select all; ' + colorDefault;
	var lastColor = "start";
	var partialLine = false;
	consensus = (parseInt(consensus)) / 100;
	for (var i = 0; i < arrayOfSequences[0].length; i++)	{
		var tempString = "";
		var columnSeq = "";
		for (var j = 0; j < arrayOfSequences.length - 1; j++)	{
			columnSeq = columnSeq + arrayOfSequences[j].charAt(i);
		}
		if ((arrayOfSequences[arrayOfSequences.length - 1].charAt(i) == "-") || (arrayOfSequences[arrayOfSequences.length - 1].charAt(i) == "."))	{
			tempString = "";
			if (i == arrayOfSequences[0].length - 1)	{
				tempString = lastColor;
			}
		}
		else	{
			if ((delCheck(columnSeq) / columnSeq.length) >= consensus)	{
				tempString = colorDel;
				realBase = realBase + 1;
			}
			else	{
				if ((identCheck(columnSeq) / columnSeq.length) >= consensus)	{
					tempString = colorIdent;
					realBase = realBase + 1;
				}
				else	{
					if ((simCheck(columnSeq,arrayOfGroups) / columnSeq.length) >= consensus)	{
						tempString = colorSim;
						realBase = realBase + 1;
					}
					else	{
						tempString = colorNoMatch;
						realBase = realBase + 1;
					}
				}
			}
		}
		if ((tempString != "") && (lastColor != "start"))	{
			if (tempString == lastColor) {
				if (partialLine == false)	{
					scriptTextCombosa = scriptTextCombosa + 'select ' + (realBase - 1) + '-';
					partialLine = true;
				}
			}
			else	{
				if (partialLine == true)	{
					scriptTextCombosa = scriptTextCombosa + (realBase - 1) + '; ' + lastColor;
					partialLine = false;
				}
				else	{
					scriptTextCombosa = scriptTextCombosa + 'select ' + (realBase - 1) + '; ' + lastColor;
				}
			}
		}
		if ((tempString != "") && (i != arrayOfSequences[0].length - 1))	{
			lastColor = tempString;
		}
		else	{
			if (tempString != "")	{
				if (tempString == lastColor)	{
					scriptTextCombosa = scriptTextCombosa + realBase + '; ' + tempString;
				}
				else	{
					scriptTextCombosa = scriptTextCombosa + 'select ' + realBase + '; ' + tempString;
				}
			}
		}
	}
	scriptTextCombosa = scriptTextCombosa + 'set hydrogen false; select hetero; wireframe 40; color cpk; select dna; wireframe 40; color cpk; label false; select protein; strands false; ribbons false; cartoon false; wireframe false; backbone false; spacefill;';
	sendRasmolScriptToChime('combosaView',scriptTextCombosa);
	top.controlArea.document.seqIn.chimeCommand.value = scriptTextCombosa.replace(/;\s*/g,"\r");
	top.window.status = 'Done';
	return true;
}
function makeTag (alignChar,amAcids,amColors,frontOrBack,extraTagStart,extraTagEnd)	{
	var colorForTag = "";
	for (var k = 0; k < amAcids.length; k++)	{
		if (alignChar.toUpperCase() == amAcids[k].toUpperCase())	{
			colorForTag = amColors[k];
			break;
		}
	}
	var amColorsArray = amColors[k].split(/\,\s/);
	if (frontOrBack == 'front')	{
		return '<td ALIGN="center" VALIGN="center">' + extraTagStart + '<font size=' + theFontSize + '><font face="' + theFontFace + '"><font color="' + amColorsArray[0] + '">' + alignChar + '</font></font></font>' + extraTagEnd + '</td>';
	}
	else	{
		return '<td ALIGN="center" VALIGN="center" bgcolor="' + amColorsArray[0] + '">' + extraTagStart + '<font size=' + theFontSize + '><font face="' + theFontFace + '"><font color="' + amColorsArray[1] + '">' + alignChar + '</font></font></font>' + extraTagEnd + '</td>';
	}
}
function oneToThree (protein)	{
	var resultSeq = "";
	var arrayOfTriplets = ["ALA","CYS","ASP","GLU","PHE","GLY","HIS","ILE","LYS","LEU","MET","ASN","PRO","GLN","ARG","SER","THR","VAL","TRP","TYR","???"];
	var arrayOfAminoAcids = ["A","C","D","E","F","G","H","I","K","L","M","N","P","Q","R","S","T","V","W","Y","X"];
	for (var j = 0; j < arrayOfAminoAcids.length; j++)	{
		if (protein.toUpperCase() == arrayOfAminoAcids[j])	{
			resultSeq = arrayOfTriplets[j];
			break;
		}
	}
	return resultSeq;
}
function openWindow () {
	outputWindow=window.open("","displayWindow","resizable=yes,menubar=yes,toolbar=yes,height=400,width=700,scrollbars=yes,status=yes,offscreenBuffering=false");
	outputWindow.focus();
	outputWindow.document.open();
	outputWindow.document.write('<HTML><HEAD><TITLE>Alignment</TITLE><STYLE type="text/css"><!--A {text-decoration: none} --></STYLE></HEAD>\n');
	outputWindow.document.write('<body text="#000000" bgcolor="#FFFFFF" link="#0000FF" vlink="#551A8B" alink="#0000FF">\n');
	outputWindow.document.write('<font size=+1><center>COMBOSA3D Reference Alignment</center></font><br>');
	outputWindow.document.write('<nobr><tt>');
	outputWindow.status = 'Please Wait...';
	return true;
}
function prepareAlign (alignArray)	{
	titleArray = new Array (alignArray.length - 1);
	sequenceArray = new Array (alignArray.length - 1);
	longestTitle = 0;
	for (var i = 1; i < alignArray.length; i++)	{
		titleArray[i-1] = alignArray[i].match(/[^\f\n\r]+[\f\n\r]/);
		titleArray[i-1] = filterFastaTitle(titleArray[i-1].toString());
		if (titleArray[i-1].length > longestTitle)	{
			longestTitle = titleArray[i-1].length;
		}
		sequenceArray[i-1] = alignArray[i].replace(/[^\f\n\r]+[\f\n\r]/,"");
		sequenceArray[i-1] = filterAlignSeq (sequenceArray[i-1]);
	}
	return true;
}
function rightNum(theNumber,sequenceToAppend,lengthOfColumn,tabIn)	{
	var j = 0;
	var tempString = "";
	theNumber = theNumber.toString();
	for (var j = theNumber.length; j < lengthOfColumn; j++)	{
		tempString = tempString + "&nbsp;";
	}
	theNumber = tempString + theNumber + "&nbsp;";
	sequenceToAppend = sequenceToAppend + theNumber + tabIn;
	return sequenceToAppend;
}
function simCheck (columnSeq,arrayOfGroups)	{
	var result = 1;
	var bigResult = 1;
	for (var m = 0; m < arrayOfGroups.length; m++)	{
		var re = new RegExp ("[" + arrayOfGroups[m] + "]","gi");
		if (columnSeq.search(re) != -1)	{
			result = (columnSeq.match(re)).length;
		}
		if (result > bigResult)	{
			bigResult = result;
		}
	}
	return bigResult;
}
function splitDigitList (listOfStarts)	{
	var positions = new Array (sequenceArray.length);
	if (listOfStarts.search(/\S/) == -1)	{
		listOfStarts = "0,0";
	}
	var listStartsArray = listOfStarts.split(/,/);
	for (var i = 0; i < positions.length; i++)	{
		if (i >= listStartsArray.length)	{
			positions[i] = 0;
		}
		else	{
			if ((listStartsArray[i].search(/\d/) != -1) && (listStartsArray[i].search(/[^\d\-]/) == -1))	{
				positions[i] = parseInt(listStartsArray[i]);
			}
			else	{
				alert('An incorrect starting position was encountered. It was set to 0.');
				positions[i] = 0;
			}
		}
	}
	return positions;
}
//Copyright (C) 2000 Paul Stothard.
//
//
//
//
//
//
//
//
function checkId (formElement)	{
	if (formElement.value.search(/\S/) == -1)	{
		alert ("Please enter a PDB ID.");
		return false;
	}
	return true;
}
function getMolInfo (theForm) {	
	if ((checkId (theForm.elements[0]) == false) || (verifyId (theForm.elements[0].value) == false))	{
		return false;
	}
	getStructure(theForm.elements[0].value,theForm.elements[1].options[theForm.elements[1].selectedIndex].value);
	return true;
}
function getStructure (theId,theServer)	{
	var thePath = "";
	theId = theId.replace(/\s/g,"");
	theId = theId.toLowerCase();
	thePath = theServer + theId + ".pdb?&format=PDB&compress=chime&pdbId=" + theId;
	sendRasmolScriptToChime('combosaView','zap; load ' + thePath);
	return true;
}
function sendPathToChime (targetchimename,filePath)	{
	if (filePath.charAt(0) == '/')	{	//Mac
		filePath = 'file://' + filePath;
	}
	else	{
		filePath = filePath.replace(/\\/g,"/");
		filePath = 'file://' + filePath;
	}
	sendRasmolScriptToChime(targetchimename,'zap; load ' + filePath);
	return true;
}
function sendRasmolScriptToChime (targetchimename,script)	{ //this function was obtained from MDL Information Systems, Inc. Developed by Eric Martz, U Mass (Amherst).
	top.hiddenFrame.document.open();
        top.hiddenFrame.document.writeln("<html><head></head><body>");
        top.hiddenFrame.document.writeln('<embed type="application/x-spt"');
        top.hiddenFrame.document.writeln('width=10 height=10 button=push target="' + targetchimename + '"');
        top.hiddenFrame.document.writeln('script="' + script + '" immediate=true>');
        top.hiddenFrame.document.writeln("</body></html>");
        top.hiddenFrame.document.close();
}
function toggleItems (arrayOfItems,direction)	{
	var valueArray = new Array;
	var scriptToSend = "";
	for (var i = 0; i < arrayOfItems.length; i++)	{
		if (arrayOfItems[i].selected)	{
			valueArray = arrayOfItems[i].value.split(/\,/g);
			if (direction)	{
				scriptToSend = scriptToSend + valueArray[0] + '; ';
			}
			else	{
				scriptToSend = scriptToSend + valueArray[1] + '; ';
			}
		}
	}
	sendRasmolScriptToChime('combosaView',scriptToSend);
	return true;
}
function verifyId (theId)	{
	theId = theId.replace(/\s/g,"");
	if (theId.length != 4)	{
		alert("The PDB ID must consist of four characters.");
		return false;
	}
	if (theId.search(/\d[A-Za-z\d]{3}/) == -1)	{
		alert("The entered PDB ID is not valid.")
		return false;
	}
	return true;
}