/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class MainPanel
extends JPanel {
    Component parent;
    String matrixPath = "";
    String scanp = "";
    String psParams = "";
    String program = "scan";
    JFileChooser file = new JFileChooser();
    private JLabel emailJL;
    private JTextField directoryJTF;
    private JButton matrixPathJB;
    private JLabel psParamsJL;
    private JLabel jLabel1;
    private JComboBox scanRange2JCB;
    private JLabel matrixTypeJL;
    private JLabel scanRange;
    private JLabel titleJP;
    private JButton helpJB;
    private JTextField matrixPathJTF;
    private JLabel directoryJL;
    private JLabel scanpJL;
    private JButton scanpJB;
    private JComboBox mrnaVersionJCB;
    private JLabel mrnaVersionJL;
    private JTextField emailJTF;
    private JTextField scanpJTF;
    private JButton psParamsJB;
    private JLabel matrixPathJL;
    private JTextField psParamsJTF;
    private JComboBox matrixTypeJCB;
    private JComboBox scanRange1JCB;

    public MainPanel(Component parent) {
        this.parent = parent;
        this.initComponents();
        this.resetItems();
    }

    public void resetItems() {
        this.psParamsJL.setVisible(false);
        this.psParamsJTF.setVisible(false);
        this.psParamsJB.setVisible(false);
        this.scanpJTF.setText("default");
        this.matrixTypeJCB.setVisible(true);
        this.matrixTypeJCB.setEnabled(true);
        this.matrixPathJTF.setText("default");
        this.psParamsJTF.setText("default");
        this.directoryJTF.setText("default");
        this.emailJTF.setText("");
        this.psParams = "";
        this.scanp = "";
        this.matrixPath = "";
        this.mrnaVersionJCB.setVisible(true);
        this.setProgram(this.program);
    }

    public void setChrmList(String[] chrm, int length) {
        this.scanRange1JCB.removeAllItems();
        this.scanRange2JCB.removeAllItems();
        int i = 0;
        while (i < length) {
            this.scanRange1JCB.addItem(chrm[i]);
            this.scanRange2JCB.addItem(chrm[i]);
            ++i;
        }
        this.scanRange1JCB.setSelectedIndex(0);
        this.scanRange2JCB.setSelectedIndex(length - 1);
    }

    public int setMrnaVersion(String[] inp, int num) {
        if (inp == null) {
            return -1;
        }
        this.mrnaVersionJCB.removeAllItems();
        int i = 0;
        while (i < num) {
            this.mrnaVersionJCB.addItem(new String(inp[i]));
            ++i;
        }
        return 1;
    }

    public String getMrnaVersion() {
        return ((String)this.mrnaVersionJCB.getSelectedItem()).trim();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.titleJP = new JLabel();
        this.scanpJTF = new JTextField();
        this.scanpJB = new JButton();
        this.matrixPathJB = new JButton();
        this.psParamsJTF = new JTextField();
        this.psParamsJB = new JButton();
        this.helpJB = new JButton();
        this.directoryJL = new JLabel();
        this.directoryJTF = new JTextField();
        this.scanpJL = new JLabel();
        this.matrixPathJL = new JLabel();
        this.psParamsJL = new JLabel();
        this.emailJL = new JLabel();
        this.emailJTF = new JTextField();
        this.scanRange = new JLabel();
        this.scanRange1JCB = new JComboBox();
        this.scanRange2JCB = new JComboBox();
        this.mrnaVersionJL = new JLabel();
        this.mrnaVersionJCB = new JComboBox();
        this.matrixTypeJL = new JLabel();
        this.matrixTypeJCB = new JComboBox();
        this.matrixPathJTF = new JTextField();
        this.jLabel1.setText("jLabel1");
        this.setLayout(new GridBagLayout());
        this.titleJP.setHorizontalAlignment(0);
        this.titleJP.setText("Enter the main parameters");
        this.titleJP.setBorder(new LineBorder(new Color(0, 0, 0)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 21, 0);
        this.add((Component)this.titleJP, gridBagConstraints);
        this.scanpJTF.setColumns(10);
        this.scanpJTF.setText("default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.scanpJTF, gridBagConstraints);
        this.scanpJB.setText("Browse");
        this.scanpJB.setHorizontalAlignment(2);
        this.scanpJB.setHorizontalTextPosition(10);
        this.scanpJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.scanpJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.scanpJB, gridBagConstraints);
        this.matrixPathJB.setText("Browse");
        this.matrixPathJB.setHorizontalAlignment(2);
        this.matrixPathJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.matrixPathJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.matrixPathJB, gridBagConstraints);
        this.psParamsJTF.setColumns(10);
        this.psParamsJTF.setText("default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.psParamsJTF, gridBagConstraints);
        this.psParamsJB.setText("Browse");
        this.psParamsJB.setHorizontalAlignment(2);
        this.psParamsJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.psParamsJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.psParamsJB, gridBagConstraints);
        this.helpJB.setText("Help");
        this.helpJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.helpJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.insets = new Insets(8, 5, 8, 5);
        this.add((Component)this.helpJB, gridBagConstraints);
        this.directoryJL.setText("Dest Directory Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.directoryJL, gridBagConstraints);
        this.directoryJTF.setColumns(10);
        this.directoryJTF.setText("default");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.directoryJTF, gridBagConstraints);
        this.scanpJL.setText("Scanp Path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.scanpJL, gridBagConstraints);
        this.matrixPathJL.setText("Ribl Path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.matrixPathJL, gridBagConstraints);
        this.psParamsJL.setText("PSParams path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.psParamsJL, gridBagConstraints);
        this.emailJL.setText("Email Address");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.emailJL, gridBagConstraints);
        this.emailJTF.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.emailJTF, gridBagConstraints);
        this.scanRange.setText("Chrm Range");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.scanRange, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.scanRange1JCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.scanRange2JCB, gridBagConstraints);
        this.mrnaVersionJL.setText("Genome Assembly Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.mrnaVersionJL, gridBagConstraints);
        this.mrnaVersionJCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MainPanel.this.mrnaVersionJCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.mrnaVersionJCB, gridBagConstraints);
        this.matrixTypeJL.setText("Matrix Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.matrixTypeJL, gridBagConstraints);
        this.matrixTypeJCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Information(ribl)", "User Defined"}));
        this.matrixTypeJCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                MainPanel.this.matrixTypeJCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.matrixTypeJCB, gridBagConstraints);
        this.matrixPathJTF.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.matrixPathJTF, gridBagConstraints);
    }

    private void mrnaVersionJCBItemStateChanged(ItemEvent evt) {
        String str = (String)evt.getItem();
        if (this.directoryJTF != null) {
            this.directoryJTF.setText(str + "/");
        }
    }

    private void matrixTypeJCBItemStateChanged(ItemEvent evt) {
        if (this.matrixTypeJCB.getSelectedIndex() == 0) {
            this.matrixPathJL.setText("Ribl Path");
            this.matrixPathJTF.setText("default");
        } else if (this.matrixTypeJCB.getSelectedIndex() == 1) {
            this.matrixPathJL.setText("Matrix Path");
            this.matrixPathJTF.setText("");
        }
    }

    public void setMrnaVersionJCBItemListener(ItemListener itemList) {
        System.out.println("mainpanel: setting the mrnajcb.itemlistener");
        this.mrnaVersionJCB.addItemListener(itemList);
    }

    public JComboBox getMrnaVersionJCB() {
        return this.mrnaVersionJCB;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String prg) {
        this.program = prg = prg.trim().toLowerCase();
        if (prg.equals("promotsite")) {
            this.scanpJL.setVisible(false);
            this.scanpJTF.setVisible(false);
            this.scanpJB.setVisible(false);
            this.matrixTypeJL.setVisible(false);
            this.matrixTypeJCB.setVisible(false);
            this.matrixPathJL.setVisible(false);
            this.matrixPathJTF.setVisible(false);
            this.matrixPathJB.setVisible(false);
            this.directoryJTF.setText("");
        } else {
            this.scanpJL.setVisible(true);
            this.scanpJTF.setVisible(true);
            this.scanpJB.setVisible(true);
            this.matrixTypeJL.setVisible(true);
            this.matrixTypeJCB.setVisible(true);
            this.matrixPathJL.setVisible(true);
            this.matrixPathJTF.setVisible(true);
            this.matrixPathJB.setVisible(true);
            if (prg.equals("scan")) {
                // empty if block
            }
        }
    }

    private String scanHelp() {
        String mesg = "Scan is the parameter file for scan. \n";
        mesg = mesg + "Note: Select the Scanp file here or enter the parameters manually later.\n";
        mesg = mesg + "Matrix Type: If this is of type 'Information', then the input file is a ribl.\n";
        mesg = mesg + "Note: Ribl file has to be selected here.\n";
        mesg = mesg + "If the matrix type is 'User Defined', then the user can upload a local file \n";
        mesg = mesg + "or else if the 'Matrix Path' is left empty, the user is presented with a form\n";
        mesg = mesg + "to enter the values. The format of the user-defined matrix file is \n";
        mesg = mesg + "Line 1 should contain the title of the matrix\n";
        mesg = mesg + "Line 2 should contain the length of the site\n";
        mesg = mesg + "Line 3 should contain the number of sequences to be simulated in  \n";
        mesg = mesg + "order to convert this user-defined matrix into a ribl";
        mesg = mesg + "From line 4 to line ( 4 +(length of the site) - 1 ), enter the\n";
        mesg = mesg + "integral frequencies of a,c,g,t in each line separated by spaces.\n";
        mesg = mesg + "\nNote: Enter \"default\" for scanp, ribl to let the server choose the  \n";
        mesg = mesg + "default files. There is no default for user-defined matrices\n";
        mesg = mesg + "\nDest Directory: A directory with this name is created on the \n";
        mesg = mesg + "server to store the results\n";
        mesg = mesg + "Note: Enter \"default\" for Dest Directory to let the server choose \n";
        mesg = mesg + "a name for this directory\n\n";
        return mesg;
    }

    private String psHelp() {
        String mesg = "Dest Directory: The name of a directory on the server\n";
        mesg = mesg + "in which the results of 'scan' are stored\n";
        mesg = mesg + "This directory is stored in the server at a location defined\n";
        mesg = mesg + "by the server environment variable DELGEN_RESULTS\n";
        mesg = mesg + "This value cannot be empty or default for promotsite\n\n";
        return mesg;
    }

    private void helpJBActionPerformed(ActionEvent evt) {
        String mesg = "Genome Assembly Version: The genome draft as released by UCSC\n";
        mesg = mesg + "Chrm Range: The range of chromosomes on which the program\n";
        mesg = mesg + "is executed. To choose a single chromosome, select both values\n";
        mesg = mesg + "as equal\n\n";
        mesg = !this.getProgram().equals("promotsite") ? mesg + this.scanHelp() : mesg + this.psHelp();
        mesg = mesg + "Email Address: The email address to which a notification\n";
        mesg = mesg + "is sent when the scan process is completed\n";
        JOptionPane.showMessageDialog(this.parent, mesg, "Help", 1);
    }

    private void psParamsJBActionPerformed(ActionEvent evt) {
        this.file.setFileSelectionMode(0);
        this.file.setDialogTitle("Select PromotSite Params File");
        int result = this.file.showOpenDialog(this.parent);
        this.psParams = result != 1 ? this.file.getSelectedFile().getPath() : "";
        this.psParamsJTF.setText(this.psParams);
    }

    private void matrixPathJBActionPerformed(ActionEvent evt) {
        this.file.setFileSelectionMode(0);
        this.file.setDialogTitle("Select matrix File");
        int result = this.file.showOpenDialog(this.parent);
        this.matrixPath = result != 1 ? this.file.getSelectedFile().getPath() : "";
        this.matrixPathJTF.setText(this.matrixPath);
    }

    private void scanpJBActionPerformed(ActionEvent evt) {
        this.file.setFileSelectionMode(0);
        this.file.setDialogTitle("Select Scanp File");
        int result = this.file.showOpenDialog(this.parent);
        this.scanp = result != 1 ? this.file.getSelectedFile().getPath() : "";
        this.scanpJTF.setText(this.scanp);
    }

    public String getScanRange1() {
        return ((String)this.scanRange1JCB.getSelectedItem()).trim();
    }

    public String getScanRange2() {
        return ((String)this.scanRange2JCB.getSelectedItem()).trim();
    }

    public int getScanRange1int() {
        return this.scanRange1JCB.getSelectedIndex();
    }

    public int getScanRange2int() {
        return this.scanRange2JCB.getSelectedIndex();
    }

    public String getMatrixType() {
        String str = "";
        if (this.matrixTypeJCB.getSelectedIndex() == 0) {
            str = "ribl";
        } else if (this.matrixTypeJCB.getSelectedIndex() == 1) {
            str = "user";
        }
        return str;
    }

    public String getMatrixPath() {
        return this.matrixPathJTF.getText();
    }

    public String getScanp() {
        return this.scanpJTF.getText();
    }

    public String getPsParams() {
        return this.psParamsJTF.getText();
    }

    public String getDestDirectory() {
        return this.directoryJTF.getText();
    }

    public void setDestDirectory(String dir) {
        this.directoryJTF.setText(dir);
    }

    public String getEmailAddr() {
        return this.emailJTF.getText();
    }

    public String getUserData() {
        String ret = "";
        ret = ret + "email " + this.getEmailAddr() + "\n";
        return ret.trim();
    }
}

