/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;

public class ScanFront
extends JFrame {
    MainPanel mainPanel;
    ScanpPanel scanpPanel;
    PromotSitePanel psitePanel;
    FilePanel filePanel;
    WMatrixPanel wmPanel;
    String[] genversions;
    String[][] genverChrm;
    ItemListener itemListener = new ItemListener(){

        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == ScanFront.this.mainPanel.getMrnaVersionJCB()) {
                ScanFront.this.mrnaVersionJCBItemStateChanged(ScanFront.this.mainPanel.getMrnaVersionJCB());
            }
        }
    };
    File scanp;
    File ribl;
    File psparams;
    SendText sock;
    String[] windows = new String[]{"main", "scanp", "promotsite", "filepanel", "matrix"};
    String curWin = this.windows[0];
    HashMap parentHash;
    private JButton nextJB;
    private JPanel bottomJP;
    private JButton resetJB;
    private JLabel titleJL;
    private JPanel titleJP;
    private JButton backJB;
    private JScrollPane midJSP;
    private JLabel mesgJL;

    public ScanFront(HashMap parentHash) {
        this.initComponents();
        this.parentHash = parentHash;
        this.mainPanel = new MainPanel(this);
        this.scanpPanel = new ScanpPanel(this);
        this.psitePanel = new PromotSitePanel(this);
        this.filePanel = new FilePanel(this);
        this.wmPanel = new WMatrixPanel(this);
        Toolkit tlk = this.getToolkit();
        Dimension d = tlk.getScreenSize();
        this.setSize(d.width - 40 > 525 ? 525 : d.width - 40, d.height - 40 > 675 ? 675 : d.height - 40);
        this.setLocation(10, 10);
        this.show();
        this.mainPanel.setProgram(this.getProgram());
        this.midJSP.setViewportView(this.mainPanel);
        this.sock = new SendText(this.getServerAddr(), this.getPort());
        this.sock.resetItems();
        this.sock.addParam("basedirenv", "DELGEN_GENOMES");
        this.sock.addParam("filename", "genversions");
        this.sock.addParam("dirname", "");
        int ret = this.sock.sendText("getfile", "");
        String[] glist = new String[1000];
        int gencnt = 0;
        if (ret >= 200 && ret <= 299) {
            String strret = new String(this.sock.getContent());
            StringTokenizer st = new StringTokenizer(strret, "\n\r\f");
            while (st.hasMoreTokens() && gencnt < 1000) {
                glist[gencnt++] = st.nextToken();
            }
            if (gencnt <= 0) {
                this.showError("No genomes installed at the server", "Server error");
                return;
            }
        } else {
            this.showError(this.sock.getErrString(), "Error in retrieving Genome Version list from server");
            this.dispose();
            return;
        }
        this.mainPanel.setMrnaVersion(glist, gencnt);
        this.genversions = new String[gencnt];
        this.genverChrm = new String[gencnt][];
        int i = 0;
        while (i < gencnt) {
            this.genversions[i] = glist[i];
            ++i;
        }
        this.setChrmList(glist[0], 0);
        glist = null;
        this.mainPanel.setMrnaVersionJCBItemListener(this.itemListener);
    }

    public void setChrmList(String genver, int genindex) {
        String[] chrmlist;
        int cnt = 0;
        if (this.genverChrm[genindex] == null) {
            chrmlist = new String[1000];
            this.sock.addParam("basedirenv", "DELGEN_GENOMES");
            this.sock.addParam("dirname", genver.trim());
            this.sock.addParam("filename", "chrmlist");
            int ret = this.sock.sendText("getfile", "");
            if (ret >= 200 && ret <= 299) {
                String strret = new String(this.sock.getContent());
                StringTokenizer st1 = new StringTokenizer(strret, "\n\r");
                while (st1.hasMoreTokens()) {
                    String line = st1.nextToken().trim();
                    if (line.startsWith("*") || line.equals("")) continue;
                    StringTokenizer st2 = new StringTokenizer(line);
                    String chnum = st2.nextToken();
                    chrmlist[cnt] = st2.nextToken();
                    if (chrmlist[cnt].equals("")) {
                        this.showError("No chrm name listed for " + chnum + " in chrmlist for " + genver + "from server", "Server Error");
                        return;
                    }
                    ++cnt;
                }
                if (cnt <= 0) {
                    this.showError("No chromosomes listed in chrmlist for " + genver + "from server", "Server Error");
                    return;
                }
            } else {
                this.showError(this.sock.getErrString(), "Error in retrieving the chrmlist for " + genver + " from server");
                this.dispose();
                return;
            }
            this.genverChrm[genindex] = new String[cnt];
            int i = 0;
            while (i < cnt) {
                this.genverChrm[genindex][i] = chrmlist[i];
                ++i;
            }
        } else {
            chrmlist = this.genverChrm[genindex];
            cnt = this.genverChrm[genindex].length;
        }
        this.mainPanel.setChrmList(chrmlist, cnt);
    }

    protected void mrnaVersionJCBItemStateChanged(JComboBox jcb) {
        int indx = -1;
        String genver = ((String)jcb.getSelectedItem()).trim();
        int i = 0;
        while (i < this.genversions.length) {
            if (this.genversions[i].trim().equals(genver)) {
                indx = i;
            }
            ++i;
        }
        this.setChrmList((String)jcb.getSelectedItem(), indx);
    }

    public void resetItems() {
        this.backJB.setEnabled(false);
        this.nextJB.setText("Next");
        this.nextJB.setEnabled(true);
        this.mesgJL.setText("");
        this.sock = null;
        this.sock = new SendText(this.getServerAddr(), this.getPort());
        this.psparams = null;
        this.ribl = null;
        this.scanp = null;
        this.curWin = this.windows[0];
        this.mainPanel.resetItems();
        this.scanpPanel.resetItems();
        this.psitePanel.resetItems();
        this.filePanel.resetItems();
        this.midJSP.setViewportView(this.mainPanel);
        Toolkit tlk = this.getToolkit();
        Dimension d = tlk.getScreenSize();
        this.setSize(d.width - 40 > 525 ? 525 : d.width - 40, d.height - 40 > 675 ? 675 : d.height - 40);
        this.setLocation(10, 10);
    }

    public int getPort() {
        String ret = (String)this.parentHash.get("port");
        ret = ret.trim();
        int rint = 7070;
        try {
            rint = Integer.parseInt(ret);
        }
        catch (Exception e) {}
        return rint;
    }

    public String getServerAddr() {
        String ret = (String)this.parentHash.get("serveraddress");
        return ret.trim();
    }

    public String getProgram() {
        String ret = (String)this.parentHash.get("program");
        return ret.trim();
    }

    private void initComponents() {
        this.titleJP = new JPanel();
        this.titleJL = new JLabel();
        this.midJSP = new JScrollPane();
        this.bottomJP = new JPanel();
        this.backJB = new JButton();
        this.nextJB = new JButton();
        this.mesgJL = new JLabel();
        this.resetJB = new JButton();
        this.setTitle("Delila-genome Front End Tool");
        this.titleJP.setPreferredSize(new Dimension(20, 20));
        this.titleJL.setText("Genome Binding Site Scan");
        this.titleJP.add(this.titleJL);
        this.getContentPane().add((Component)this.titleJP, "North");
        this.midJSP.setViewportBorder(new EtchedBorder());
        this.getContentPane().add((Component)this.midJSP, "Center");
        this.bottomJP.setLayout(new GridBagLayout());
        this.bottomJP.setMinimumSize(new Dimension(20, 20));
        this.bottomJP.setPreferredSize(new Dimension(120, 65));
        this.backJB.setText("back");
        this.backJB.setEnabled(false);
        this.backJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScanFront.this.backJBActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomJP.add((Component)this.backJB, gridBagConstraints);
        this.nextJB.setText("next");
        this.nextJB.setMaximumSize(new Dimension(90, 26));
        this.nextJB.setMinimumSize(new Dimension(62, 26));
        this.nextJB.setPreferredSize(new Dimension(75, 26));
        this.nextJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScanFront.this.nextJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.bottomJP.add((Component)this.nextJB, gridBagConstraints);
        this.mesgJL.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 3, 8, 3);
        this.bottomJP.add((Component)this.mesgJL, gridBagConstraints);
        this.resetJB.setText("Reset All");
        this.resetJB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScanFront.this.resetJBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 20);
        this.bottomJP.add((Component)this.resetJB, gridBagConstraints);
        this.getContentPane().add((Component)this.bottomJP, "South");
        this.pack();
    }

    private void resetJBActionPerformed(ActionEvent evt) {
        this.resetItems();
    }

    private void backJBActionPerformed(ActionEvent evt) {
        String status = this.curWin;
        String prog = this.getProgram().trim();
        String matrixType = this.mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = this.mainPanel.getMatrixPath().trim().toLowerCase();
        this.nextJB.setEnabled(true);
        if (status.equals(this.windows[0])) {
            this.backJB.setEnabled(false);
            this.nextJB.setText("next");
        } else if (status.equals(this.windows[4])) {
            this.curWin = this.windows[0];
            this.backJB.setEnabled(false);
            this.nextJB.setText("next");
            this.midJSP.setViewportView(this.mainPanel);
        } else if (status.equals(this.windows[1])) {
            if (matrixType.equals("user") && matrixPath.equals("")) {
                this.curWin = this.windows[4];
                this.backJB.setEnabled(true);
                this.nextJB.setText("next");
                this.midJSP.setViewportView(this.wmPanel);
            } else {
                this.curWin = this.windows[0];
                this.backJB.setEnabled(false);
                this.nextJB.setText("next");
                this.midJSP.setViewportView(this.mainPanel);
            }
        } else if (prog.equals("scan")) {
            if (status.equals(this.windows[2])) {
                this.curWin = this.windows[1];
                this.backJB.setEnabled(true);
                this.nextJB.setText("next");
                this.midJSP.setViewportView(this.scanpPanel);
            } else if (status.equals(this.windows[3])) {
                String win = this.filePanel.getWindow();
                if (win.equals("base")) {
                    this.curWin = this.windows[1];
                    this.midJSP.setViewportView(this.scanpPanel);
                } else if (win.equals("scanp")) {
                    String errString = "Any final editing in the scanp and weight matrix files will be lost\n";
                    int option = JOptionPane.showConfirmDialog(this, errString = errString + "Continue??\n", "Important", 0);
                    if (option == 0) {
                        this.curWin = this.windows[1];
                        this.midJSP.setViewportView(this.scanpPanel);
                    }
                } else if (win.equals("ribl")) {
                    this.filePanel.setScanp();
                    this.nextJB.setText("Next");
                }
            }
        } else if (prog.equals("promotsite")) {
            if (status.equals(this.windows[2])) {
                this.curWin = this.windows[0];
                this.backJB.setEnabled(false);
                this.nextJB.setText("next");
                this.midJSP.setViewportView(this.mainPanel);
            } else if (status.equals(this.windows[3])) {
                this.curWin = this.windows[2];
                this.backJB.setEnabled(true);
                this.nextJB.setEnabled(true);
                this.nextJB.setText("next");
                this.midJSP.setViewportView(this.psitePanel);
            }
        } else if (status.equals(this.windows[2])) {
            this.curWin = this.windows[1];
            this.backJB.setEnabled(true);
            this.nextJB.setText("next");
            this.midJSP.setViewportView(this.scanpPanel);
        } else if (status.equals(this.windows[3])) {
            String win = this.filePanel.getWindow();
            if (win.equals("base")) {
                this.curWin = this.windows[2];
                this.midJSP.setViewportView(this.psitePanel);
            } else if (win.equals("scanp")) {
                String errString = "Any final editing in the scanp, psparams and ribl files will be lost\n";
                int option = JOptionPane.showConfirmDialog(this, errString = errString + "Continue??\n", "Important", 0);
                if (option == 0) {
                    this.curWin = this.windows[2];
                    this.midJSP.setViewportView(this.psitePanel);
                }
            } else if (win.equals("ribl")) {
                this.filePanel.setScanp();
            } else if (win.equals("psparams")) {
                this.nextJB.setText("Next");
                this.filePanel.setRibl();
            }
        }
    }

    private void nextJBActionPerformed(ActionEvent evt) {
        String status = this.curWin;
        String prog = this.getProgram().trim();
        if (prog.equals("scan")) {
            if (status.equals(this.windows[0])) {
                this.doScanMain();
            } else if (status.equals(this.windows[1])) {
                this.doScanScanp();
            } else if (status.equals(this.windows[3])) {
                this.doScanFileDisplay();
            } else if (status.equals(this.windows[4])) {
                this.doScanUserMatrix();
            }
        } else if (prog.equals("promotsite")) {
            if (status.equals(this.windows[0])) {
                this.doPSMain();
            } else if (status.equals(this.windows[2])) {
                this.doPSPromotSite();
            } else if (status.equals(this.windows[3])) {
                this.doPSFileDisplay();
            }
        } else if (status.equals(this.windows[0])) {
            this.doMain();
        } else if (status.equals(this.windows[1])) {
            this.doScanp();
        } else if (status.equals(this.windows[2])) {
            this.doPromotSite();
        } else if (status.equals(this.windows[3])) {
            this.doFileDisplay();
        } else if (status.equals(this.windows[4])) {
            this.doUserMatrix();
        }
    }

    protected void doScanMain() {
        this.doMain();
    }

    protected void doScanUserMatrix() {
        this.doUserMatrix();
    }

    protected void doUserMatrix() {
        String errstr = this.wmPanel.parseMatrix().trim();
        if (!errstr.equals("")) {
            this.showError(errstr, "Error in weight matrix parameters");
            return;
        }
        this.backJB.setEnabled(true);
        this.setScanpParams();
    }

    protected void doScanScanp() {
        String retVal = "";
        retVal = this.scanpPanel.parseScanp();
        if (!retVal.trim().equals("")) {
            System.out.println("Error Inputs\n" + retVal);
            this.showError(retVal, "Error in Scanp Parameters");
            return;
        }
        this.backJB.setEnabled(true);
        this.curWin = this.windows[3];
        this.filePanel.resetItems();
        this.midJSP.setViewportView(this.filePanel);
        this.doScanFileDisplay();
    }

    protected void doScanFileDisplay() {
        String win = this.filePanel.getWindow();
        String matrixType = this.mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = this.mainPanel.getMatrixPath().trim().toLowerCase();
        if (win.equals("base")) {
            this.filePanel.resetItems();
            this.filePanel.setScanp(this.scanpPanel.getScanpText());
        } else if (win.equals("scanp")) {
            if (!this.filePanel.isRiblSet()) {
                if (matrixType.equals("ribl")) {
                    if (matrixPath.equals("default")) {
                        this.sock.resetItems();
                        this.sock.addParam("filename", "ribl");
                        this.sock.addParam("dirname", "");
                        int ret = this.sock.sendText("getfile", "");
                        if (ret >= 200 && ret <= 299) {
                            this.filePanel.setRibl(new String(this.sock.getContent()));
                        } else {
                            this.showError(this.sock.getErrString(), "Error in retrieving ribl from server");
                        }
                    } else {
                        try {
                            this.filePanel.setRibl(new File(matrixPath));
                        }
                        catch (Exception e) {
                            this.showError(e.toString(), "Error in opening Ribl file");
                        }
                    }
                } else if (matrixType.equals("user")) {
                    if (matrixPath.equals("")) {
                        this.filePanel.setRibl(this.wmPanel.getMatrixText());
                    } else {
                        try {
                            this.filePanel.setRibl(new File(matrixPath));
                        }
                        catch (Exception e) {
                            this.showError(e.toString(), "Error in opening weight matrix file " + matrixPath);
                        }
                    }
                }
            } else {
                this.filePanel.setRibl();
            }
            this.nextJB.setText("Submit");
            this.nextJB.setEnabled(true);
        } else if (win.equals("ribl")) {
            this.sendScanfiles();
        }
    }

    protected void sendScanfiles() {
        this.sendfiles(1);
    }

    protected void doPSMain() {
        int scanend;
        String progName = this.getProgram().trim();
        String ddir = this.mainPanel.getDestDirectory().trim();
        String servaddr = this.getServerAddr().trim();
        int scanst = this.mainPanel.getScanRange1int();
        if (scanst > (scanend = this.mainPanel.getScanRange2int())) {
            String mesg = "Incorrect Chrm Scan Range\n";
            mesg = mesg + "The start is greater than the end value\n";
            JOptionPane.showMessageDialog(this, mesg, "Error", 0);
            return;
        }
        if (ddir.equals("")) {
            String mesg = "Please enter the Destination Directory Name";
            JOptionPane.showMessageDialog(this, mesg, "Error", 0);
            return;
        }
        if (ddir.equals("default")) {
            String mesg = "Promotsite needs the name of an existing directory\n";
            mesg = mesg + "on the server containing the results of scan\n";
            JOptionPane.showMessageDialog(this, mesg, "Error", 0);
            return;
        }
        if (servaddr.equals("")) {
            String mesg = "Please enter the Server Address";
            JOptionPane.showMessageDialog(this, mesg, "Error", 0);
            return;
        }
        this.sock = new SendText(servaddr, this.getPort());
        this.sock.resetItems();
        String tempdir = ddir;
        this.sock.addParam("dirname", tempdir);
        int sret = this.sock.sendText("checknewdir", "");
        if (sret >= 200 && sret <= 299) {
            String mesg = "No destination directory found with the user specified value\n";
            mesg = mesg + "Promotsite needs an existing directory name containing \n";
            mesg = mesg + "the results of scan";
            this.showError(mesg, "Error");
            return;
        }
        this.curWin = this.windows[2];
        this.backJB.setEnabled(true);
        this.psitePanel.resetItems();
        this.sock.resetItems();
        this.sock.addParam("filename", "genversions");
        this.sock.addParam("dirname", "");
        int ret = this.sock.sendText("getfile", "");
        if (ret >= 200 && ret <= 299) {
            String strret = new String(this.sock.getContent());
            StringTokenizer st = new StringTokenizer(strret, "\n\r\f");
            String[] glist = new String[1000];
            int i = 0;
            while (st.hasMoreTokens() && i < 1000) {
                glist[i++] = st.nextToken();
            }
            this.psitePanel.setMrnaVersion(this.mainPanel.getMrnaVersion());
        } else {
            this.showError(this.sock.getErrString(), "Error in retrieving Genome Version list from server");
        }
        this.midJSP.setViewportView(this.psitePanel);
    }

    protected void doPSPromotSite() {
        String retVal = "";
        retVal = this.psitePanel.parsePSParams();
        if (!retVal.trim().equals("")) {
            System.out.println("Error Inputs\n" + retVal);
            this.showError(retVal, "Error in PromoSite Parameters");
            return;
        }
        this.curWin = this.windows[3];
        this.filePanel.resetItems();
        this.midJSP.setViewportView(this.filePanel);
        this.doPSFileDisplay();
    }

    protected void doPSFileDisplay() {
        String win = this.filePanel.getWindow();
        if (win.equals("base")) {
            this.filePanel.resetItems();
            this.filePanel.setPsParams(this.psitePanel.getPsParamsText());
            this.nextJB.setText("Submit");
        } else if (win.equals("psparams")) {
            this.sendPSfiles();
        }
    }

    protected void sendPSfiles() {
        this.sendfiles(2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doMain() {
        String matrixPath;
        String matrixType;
        block19: {
            int scanend;
            String progName = this.getProgram().trim();
            String scanpName = this.mainPanel.getScanp().trim();
            matrixType = this.mainPanel.getMatrixType().trim().toLowerCase();
            matrixPath = this.mainPanel.getMatrixPath().trim().toLowerCase();
            String ddir = this.mainPanel.getDestDirectory().trim();
            String servaddr = this.getServerAddr().trim();
            int scanst = this.mainPanel.getScanRange1int();
            if (scanst > (scanend = this.mainPanel.getScanRange2int())) {
                String mesg = "Incorrect Chrm Scan Range\n";
                mesg = mesg + "The start is greater than the end value\n";
                JOptionPane.showMessageDialog(this, mesg, "Error", 0);
                return;
            }
            System.out.println("matrixtype=" + matrixType + " path=" + matrixPath);
            if (matrixType.equals("ribl")) {
                if (matrixPath.equals("")) {
                    String mesg = "Please select a Ribl file";
                    JOptionPane.showMessageDialog(this, mesg, "Error", 0);
                    return;
                }
                if (!matrixPath.toLowerCase().equals("default") && !this.fileExists(matrixPath)) {
                    this.showError("Unable to read Ribl file " + matrixPath, "Error");
                    return;
                }
            } else {
                if (!matrixType.equals("user")) {
                    this.showError("Unrecognized matrix type" + matrixPath, "Internal Error");
                    return;
                }
                if (!matrixPath.equals("")) {
                    if (matrixPath.equals("default")) {
                        this.showError("No default files defined for user defined matrices" + matrixPath, "Error");
                        return;
                    }
                    if (!this.fileExists(matrixPath)) {
                        this.showError("Unable to read Ribl file " + matrixPath, "Error");
                        return;
                    }
                }
            }
            if (!(scanpName.equals("") || scanpName.toLowerCase().equals("default") || this.fileExists(scanpName))) {
                this.showError("Unable to read Scanp file", "Error");
                return;
            }
            if (ddir.equals("")) {
                String mesg = "Please enter the Destination Directory Name";
                JOptionPane.showMessageDialog(this, mesg, "Error", 0);
                return;
            }
            if (servaddr.equals("")) {
                String mesg = "Please enter the Server Address";
                JOptionPane.showMessageDialog(this, mesg, "Error", 0);
                return;
            }
            this.sock = new SendText(servaddr, this.getPort());
            if (ddir.toLowerCase().equals("default")) {
                this.sock.resetItems();
                this.sock.addHeader("Content-length", "0");
                int sret = this.sock.sendText("getnewdir", "");
                if (sret >= 200 && sret <= 299) {
                    String tempdir = this.sock.getErrString().trim();
                    this.mainPanel.setDestDirectory(tempdir);
                    this.mesgJL.setText("Destination Dir : " + tempdir);
                    break block19;
                } else {
                    this.showError(this.sock.getErrString(), "Error");
                    return;
                }
            }
            this.sock.resetItems();
            String tempdir = ddir;
            this.sock.addParam("dirname", tempdir);
            int sret = this.sock.sendText("checknewdir", "");
            if (sret >= 200 && sret <= 299) {
                this.mesgJL.setText("Destination Dir : " + tempdir);
            } else {
                this.showError(this.sock.getErrString(), "Error");
                return;
            }
        }
        if (matrixType.equals("ribl")) {
            this.setScanpParams();
            return;
        }
        if (!matrixType.equals("user")) return;
        if (matrixPath.equals("")) {
            this.curWin = this.windows[4];
            this.wmPanel.resetItems();
            this.backJB.setEnabled(true);
            this.midJSP.setViewportView(this.wmPanel);
            return;
        }
        this.setScanpParams();
    }

    protected void setScanpParams() {
        block8: {
            String scanpName;
            block9: {
                this.curWin = this.windows[1];
                this.backJB.setEnabled(true);
                this.midJSP.setViewportView(this.scanpPanel);
                scanpName = this.mainPanel.getScanp().trim();
                this.scanpPanel.resetItems();
                if (!scanpName.toLowerCase().equals("default")) break block9;
                this.sock.resetItems();
                this.sock.addParam("filename", "scanp");
                this.sock.addParam("dirname", "");
                int ret = this.sock.sendText("getfile", "");
                if (ret >= 200 && ret <= 299) {
                    try {
                        String strret = this.scanpPanel.parseScanp(new String(this.sock.getContent()));
                        System.out.println("Result::" + strret);
                        if (!strret.trim().equals("")) {
                            this.showError(strret, "Error in Scanp file");
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        this.showError("Error in retrieving scanp from server", "Error");
                    }
                } else {
                    this.showError(this.sock.getErrString(), "Error in retrieving scanp from server");
                }
                break block8;
            }
            if (scanpName.equals("")) break block8;
            try {
                this.scanp = new File(scanpName);
                String ret = this.scanpPanel.parseScanp(new FileInputStream(this.scanp));
                System.out.println("Result::" + ret);
                if (!ret.trim().equals("")) {
                    this.showError(ret, "Error in Scanp file");
                }
            }
            catch (Exception e) {
                this.showError("Scanp file not found", "Error");
            }
        }
    }

    protected void doScanp() {
        String retVal = "";
        retVal = this.scanpPanel.parseScanp();
        if (!retVal.trim().equals("")) {
            System.out.println("Error Inputs\n" + retVal);
            this.showError(retVal, "Error in Scanp Parameters");
            return;
        }
        this.backJB.setEnabled(true);
        this.psitePanel.setMrnaVersion(this.mainPanel.getMrnaVersion());
        this.curWin = this.windows[2];
        this.midJSP.setViewportView(this.psitePanel);
    }

    protected void doPromotSite() {
        String retVal = "";
        retVal = this.psitePanel.parsePSParams();
        if (!retVal.trim().equals("")) {
            System.out.println("Error Inputs\n" + retVal);
            this.showError(retVal, "Error in PromoSite Parameters");
            return;
        }
        this.curWin = this.windows[3];
        this.filePanel.resetItems();
        this.midJSP.setViewportView(this.filePanel);
        this.doFileDisplay();
    }

    protected void doFileDisplay() {
        String win = this.filePanel.getWindow();
        String matrixType = this.mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = this.mainPanel.getMatrixPath().trim().toLowerCase();
        if (win.equals("base")) {
            this.filePanel.resetItems();
            this.filePanel.setScanp(this.scanpPanel.getScanpText());
        } else if (win.equals("scanp")) {
            if (!this.filePanel.isRiblSet()) {
                if (matrixType.equals("ribl")) {
                    if (matrixPath.equals("default")) {
                        this.sock.resetItems();
                        this.sock.addParam("filename", "ribl");
                        this.sock.addParam("dirname", "");
                        int ret = this.sock.sendText("getfile", "");
                        if (ret >= 200 && ret <= 299) {
                            this.filePanel.setRibl(new String(this.sock.getContent()));
                        } else {
                            this.showError(this.sock.getErrString(), "Error in retrieving Ribl from server");
                        }
                    } else {
                        try {
                            this.filePanel.setRibl(new File(matrixPath));
                        }
                        catch (Exception e) {
                            this.showError(e.toString(), "Error in opening Ribl file");
                        }
                    }
                } else if (matrixType.equals("user")) {
                    if (matrixPath.equals("")) {
                        this.filePanel.setRibl(this.wmPanel.getMatrixText());
                    } else {
                        try {
                            this.filePanel.setRibl(new File(matrixPath));
                        }
                        catch (Exception e) {
                            this.showError(e.toString(), "Error in opening weight matrix file");
                        }
                    }
                }
            } else {
                this.filePanel.setRibl();
            }
        } else if (win.equals("ribl")) {
            if (!this.filePanel.isPsParamsSet()) {
                this.filePanel.setPsParams(this.psitePanel.getPsParamsText());
            } else {
                this.filePanel.setPsParams();
            }
            this.nextJB.setText("Submit");
        } else if (win.equals("psparams")) {
            this.sendfiles(3);
        }
    }

    protected void sendfiles(int prog) {
        String errString = "";
        String errTitle = "";
        String matrixType = this.mainPanel.getMatrixType().trim().toLowerCase();
        boolean flag = false;
        int ret = 200;
        this.nextJB.setEnabled(false);
        switch (prog) {
            case 1: {
                errTitle = "Scan process submission status:";
                break;
            }
            case 2: {
                errTitle = "Promotsite process submission status:";
                break;
            }
            case 3: {
                errTitle = "Scan+Promotsite process submission status:";
                break;
            }
        }
        if (prog != 2) {
            this.sock.resetItems();
            this.sock.addParam("filename", "scanp");
            this.sock.addParam("dirname", this.mainPanel.getDestDirectory());
            ret = this.sock.sendText("savefile", this.filePanel.getScanp());
            if (ret < 0 || ret > 299) {
                flag = true;
                errString = errString + "scanp:" + this.sock.getErrString() + "\n";
            }
            System.out.println("Scanp Sent");
            this.sock.resetItems();
            if (matrixType.equals("ribl")) {
                this.sock.addParam("filename", "ribl");
            } else if (matrixType.equals("user")) {
                this.sock.addParam("filename", "wmatrix");
            }
            this.sock.addParam("dirname", this.mainPanel.getDestDirectory());
            ret = this.sock.sendText("savefile", this.filePanel.getRibl());
            if (ret < 0 || ret > 299) {
                flag = true;
                errString = errString + "Weight Matrix:" + this.sock.getErrString() + "\n";
            }
            System.out.println("Weight matrix Sent");
        }
        if (prog != 1) {
            this.sock.resetItems();
            this.sock.addParam("filename", "psparams");
            this.sock.addParam("dirname", this.mainPanel.getDestDirectory());
            ret = this.sock.sendText("savefile", this.filePanel.getPsParams());
            if (ret < 0 || ret > 299) {
                flag = true;
                errString = errString + "PSParams:" + this.sock.getErrString() + "\n";
            }
            System.out.println("psparams Sent");
        }
        if (flag) {
            this.showError(errString, "Error in uploading files to the server");
            this.nextJB.setEnabled(true);
            return;
        }
        this.sock.resetItems();
        this.sock.addParam("runprogram", String.valueOf(prog));
        this.sock.addParam("dirname", this.mainPanel.getDestDirectory());
        this.sock.addParam("chrmst", this.mainPanel.getScanRange1());
        this.sock.addParam("chrmend", this.mainPanel.getScanRange2());
        this.sock.addParam("email", this.mainPanel.getEmailAddr());
        this.sock.addParam("mrnaversion", this.mainPanel.getMrnaVersion());
        if (matrixType.equals("user")) {
            this.sock.addParam("matrixType", "user");
        } else {
            this.sock.addParam("matrixType", "ribl");
        }
        ret = this.sock.sendText("runscan", "");
        if (ret < 0 || ret > 299) {
            errString = errString + this.sock.getErrString() + "\n";
            this.showError(errString, errTitle + "Error");
            this.nextJB.setEnabled(true);
        } else {
            this.nextJB.setEnabled(false);
            errString = this.sock.getErrString();
            JOptionPane.showMessageDialog(this, errString, errTitle + "Success", 1);
        }
    }

    public boolean fileExists(String file) {
        try {
            return new File(file).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void showError(String errString, String errTitle) {
        if (errString != null) {
            JOptionPane.showMessageDialog(this, errString, errTitle, 0);
        }
    }

    public static void main(String[] args) {
    }
}

