/*
 * FilePanel.java
 *
 * Created on December 26, 2002, 11:33 AM
 */

/**
 *
 * @author  sashidhar gadiraju
 */
/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class FilePanel extends javax.swing.JPanel {
    java.awt.Component parent;
    String window="base";
    int scanpSet=0;
    int riblSet=0;
    int psparamsSet=0;
    /** Creates new form FilePanel */
    public FilePanel(java.awt.Component parent) {
        this.parent = parent;
        initComponents();
        //resetItems();
    }
    
    public void resetItems()
    {
        scanpJTA.setText("");
        riblJTA.setText("");
        psParamsJTA.setText("");
        scanpSet=0;
        riblSet=0;
        psparamsSet=0;
        window="base";
        //setScanp("");
    }
    
    public void resetScanp()
    {   scanpJTA.setText(""); scanpSet=0;}
    
    public void resetRibl()
    {   riblJTA.setText(""); riblSet=0;}
    
    public void resetPsParams()
    {   psParamsJTA.setText(""); psparamsSet=0;}        
    //the below 3 functions return a string contained in the filepanel display
    public String getScanp()
    {   return scanpJTA.getText();  }
    
    public String getRibl()
    {   return riblJTA.getText();  }
    
    public String getPsParams()
    {   return psParamsJTA.getText();  }
    //the below 3 functions return a boolean indicating whether the particular window has already been set for the first time
    public boolean isScanpSet() { return (scanpSet==0)?false:true;  }
    
    public boolean isRiblSet() { return (riblSet==0)?false:true;  }
    
    public boolean isPsParamsSet() { return (psparamsSet==0)?false:true;  }
    //getWindow returns the current window being displayed in filepanel as a string
    public String getWindow(){  return window;  }
    
    public void setScanp()
    {
        scanpSet=1;
        window="scanp";
        titleScanpJL.setVisible(true);
        titleRiblJL.setVisible(false);
        titlePsParamsJL.setVisible(false);
        fileJSP.setViewportView(scanpJTA);
        scanpHJB.setVisible(true);
        riblHJB.setVisible(false);
        psParamsHJB.setVisible(false);
    }
    public void setScanp(String ftext)
    {
        setScanp();
        scanpJTA.setText(ftext);        
    }
    
    public void setRibl()
    {
        riblSet=1;
        window="ribl";
        titleScanpJL.setVisible(false);
        titleRiblJL.setVisible(true);
        titlePsParamsJL.setVisible(false);
        fileJSP.setViewportView(riblJTA);
        scanpHJB.setVisible(false);
        riblHJB.setVisible(true);
        psParamsHJB.setVisible(false);
    }
    
    public void setRibl(String ftext)
    {
        setRibl();
        riblJTA.setText(ftext);
    }
    
    public void setRibl(java.io.File file) throws Exception
    {
        int len = (int)file.length();//change this to reflect long files
        byte buffer[] = new byte[len];
        java.io.FileInputStream fstr = new java.io.FileInputStream(file);
        fstr.read(buffer);
        setRibl(new String(buffer) );
    }
        
    
    public void setPsParams()
    {
        psparamsSet=1;
        window="psparams";
        titleScanpJL.setVisible(false);
        titleRiblJL.setVisible(false);
        titlePsParamsJL.setVisible(true);
        fileJSP.setViewportView(psParamsJTA);
        scanpHJB.setVisible(false);
        riblHJB.setVisible(false);
        psParamsHJB.setVisible(true);
    }    
    
    public void setPsParams(String ftext)
    {
        setPsParams();
        psParamsJTA.setText(ftext);
    }    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        titleScanpJL = new javax.swing.JLabel();
        titleRiblJL = new javax.swing.JLabel();
        titlePsParamsJL = new javax.swing.JLabel();
        fileJSP = new javax.swing.JScrollPane();
        scanpJTA = new javax.swing.JTextArea();
        riblJTA = new javax.swing.JTextArea();
        psParamsJTA = new javax.swing.JTextArea();
        scanpHJB = new javax.swing.JButton();
        riblHJB = new javax.swing.JButton();
        psParamsHJB = new javax.swing.JButton();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        titleScanpJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleScanpJL.setText("View/Final Edit Scanp File");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(3, 0, 3, 0);
        add(titleScanpJL, gridBagConstraints1);
        
        titleRiblJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleRiblJL.setText("View/Final Edit Weight Matrix File");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(3, 0, 3, 0);
        add(titleRiblJL, gridBagConstraints1);
        
        titlePsParamsJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titlePsParamsJL.setText("View/Final Edit Promot Site Params file");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(3, 0, 3, 0);
        add(titlePsParamsJL, gridBagConstraints1);
        
        scanpJTA.setColumns(40);
        scanpJTA.setRows(20);
        scanpJTA.setTabSize(4);
        fileJSP.setViewportView(scanpJTA);
        
        riblJTA.setColumns(40);
        riblJTA.setRows(20);
        riblJTA.setTabSize(4);
        fileJSP.setViewportView(riblJTA);
        
        psParamsJTA.setColumns(40);
        psParamsJTA.setRows(20);
        psParamsJTA.setTabSize(4);
        fileJSP.setViewportView(psParamsJTA);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 0, 5, 0);
        add(fileJSP, gridBagConstraints1);
        
        scanpHJB.setText("Help");
        scanpHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scanpHJBActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 9;
        gridBagConstraints1.insets = new java.awt.Insets(3, 0, 3, 0);
        add(scanpHJB, gridBagConstraints1);
        
        riblHJB.setText("Help");
        riblHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                riblHJBActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 11;
        gridBagConstraints1.insets = new java.awt.Insets(3, 0, 3, 0);
        add(riblHJB, gridBagConstraints1);
        
        psParamsHJB.setText("Help");
        psParamsHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                psParamsHJBActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 13;
        gridBagConstraints1.insets = new java.awt.Insets(3, 0, 3, 0);
        add(psParamsHJB, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void psParamsHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_psParamsHJBActionPerformed
        // Add your handling code here:
        String mesg="Perform any final changes to the psparams file before sending it to the server\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_psParamsHJBActionPerformed

    private void riblHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_riblHJBActionPerformed
        // Add your handling code here:
        String mesg="Perform any final changes to the weight matrix file before sending it to the server\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_riblHJBActionPerformed

    private void scanpHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_scanpHJBActionPerformed
        // Add your handling code here:
        String mesg="Perform any final changes to the scanp file before sending it to the server\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_scanpHJBActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel titleScanpJL;
    private javax.swing.JLabel titleRiblJL;
    private javax.swing.JLabel titlePsParamsJL;
    private javax.swing.JScrollPane fileJSP;
    private javax.swing.JTextArea scanpJTA;
    private javax.swing.JTextArea riblJTA;
    private javax.swing.JTextArea psParamsJTA;
    private javax.swing.JButton scanpHJB;
    private javax.swing.JButton riblHJB;
    private javax.swing.JButton psParamsHJB;
    // End of variables declaration//GEN-END:variables
    
}
