/*
 * MainPanel.java
 *
 * Created on December 13, 2002, 3:10 AM
 */

/**
 *
 * @author  sashidhar gadiraju
 */

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class MainPanel extends javax.swing.JPanel {
    java.awt.Component parent;
    String matrixPath = "";   //matrix(ribl, user defined) file path
    String scanp = "";  //scanp file path
    String psParams = "";   //promotsite params file
    String program = "scan";        
    javax.swing.JFileChooser file = new javax.swing.JFileChooser();
    
    /** Creates new form MainPanel */
    public MainPanel(java.awt.Component parent) {
        this.parent = parent;
        initComponents();
        //disable the psparams components, these parameters will be manually entered
        resetItems();
    }

    public void resetItems()
    {
        psParamsJL.setVisible(false);
        psParamsJTF.setVisible(false);
        psParamsJB.setVisible(false);           
        scanpJTF.setText("default");
        matrixTypeJCB.setVisible(true);                
        matrixTypeJCB.setEnabled(true);        
        matrixPathJTF.setText("default");        
        psParamsJTF.setText("default");
        directoryJTF.setText("default");        
        emailJTF.setText("");
        matrixPath=scanp=psParams="";
        /*
        scanRange1JCB.removeAllItems();
        scanRange2JCB.removeAllItems();
        for(int i=1;i<=22;++i)
        {
            scanRange1JCB.addItem(String.valueOf(i) );
            scanRange2JCB.addItem(String.valueOf(i) );
        }
        scanRange1JCB.addItem("X");    scanRange1JCB.addItem("Y");
        scanRange2JCB.addItem("X");    scanRange2JCB.addItem("Y");
        scanRange1JCB.setSelectedIndex(0);
        scanRange2JCB.setSelectedIndex(23);
         */
        mrnaVersionJCB.setVisible(true);        
        setProgram(this.program);
    }
    
    public void setChrmList(String chrm[], int length)
    {
        scanRange1JCB.removeAllItems();
        scanRange2JCB.removeAllItems();
        for(int i=0;i<length;++i)
        {
            scanRange1JCB.addItem( chrm[i] );
            scanRange2JCB.addItem( chrm[i] );
        }
        scanRange1JCB.setSelectedIndex(0);
        scanRange2JCB.setSelectedIndex(length-1);
    }
    
    public int setMrnaVersion(String[] inp, int num)
    {
        if(inp == null) 
            return -1;
        mrnaVersionJCB.removeAllItems();
        for(int i=0; i<num;++i)
        {   mrnaVersionJCB.addItem(new String(inp[i]) );    }
        return 1;
    }
    
    public String getMrnaVersion()
    {   return ( (String) mrnaVersionJCB.getSelectedItem() ).trim();    }
	       
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        titleJP = new javax.swing.JLabel();
        scanpJTF = new javax.swing.JTextField();
        scanpJB = new javax.swing.JButton();
        matrixPathJB = new javax.swing.JButton();
        psParamsJTF = new javax.swing.JTextField();
        psParamsJB = new javax.swing.JButton();
        helpJB = new javax.swing.JButton();
        directoryJL = new javax.swing.JLabel();
        directoryJTF = new javax.swing.JTextField();
        scanpJL = new javax.swing.JLabel();
        matrixPathJL = new javax.swing.JLabel();
        psParamsJL = new javax.swing.JLabel();
        emailJL = new javax.swing.JLabel();
        emailJTF = new javax.swing.JTextField();
        scanRange = new javax.swing.JLabel();
        scanRange1JCB = new javax.swing.JComboBox();
        scanRange2JCB = new javax.swing.JComboBox();
        mrnaVersionJL = new javax.swing.JLabel();
        mrnaVersionJCB = new javax.swing.JComboBox();
        matrixTypeJL = new javax.swing.JLabel();
        matrixTypeJCB = new javax.swing.JComboBox();
        matrixPathJTF = new javax.swing.JTextField();

        jLabel1.setText("jLabel1");

        setLayout(new java.awt.GridBagLayout());

        titleJP.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleJP.setText("Enter the main parameters");
        titleJP.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 21, 0);
        add(titleJP, gridBagConstraints);

        scanpJTF.setColumns(10);
        scanpJTF.setText("default");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(scanpJTF, gridBagConstraints);

        scanpJB.setText("Browse");
        scanpJB.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        scanpJB.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);
        scanpJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scanpJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(scanpJB, gridBagConstraints);

        matrixPathJB.setText("Browse");
        matrixPathJB.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        matrixPathJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                matrixPathJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(matrixPathJB, gridBagConstraints);

        psParamsJTF.setColumns(10);
        psParamsJTF.setText("default");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(psParamsJTF, gridBagConstraints);

        psParamsJB.setText("Browse");
        psParamsJB.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        psParamsJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                psParamsJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(psParamsJB, gridBagConstraints);

        helpJB.setText("Help");
        helpJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.insets = new java.awt.Insets(8, 5, 8, 5);
        add(helpJB, gridBagConstraints);

        directoryJL.setText("Dest Directory Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(directoryJL, gridBagConstraints);

        directoryJTF.setColumns(10);
        directoryJTF.setText("default");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(directoryJTF, gridBagConstraints);

        scanpJL.setText("Scanp Path");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(scanpJL, gridBagConstraints);

        matrixPathJL.setText("Ribl Path");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(matrixPathJL, gridBagConstraints);

        psParamsJL.setText("PSParams path");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(psParamsJL, gridBagConstraints);

        emailJL.setText("Email Address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(emailJL, gridBagConstraints);

        emailJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(emailJTF, gridBagConstraints);

        scanRange.setText("Chrm Range");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(scanRange, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(scanRange1JCB, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(scanRange2JCB, gridBagConstraints);

        mrnaVersionJL.setText("Genome Assembly Date");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(mrnaVersionJL, gridBagConstraints);

        mrnaVersionJCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                mrnaVersionJCBItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(mrnaVersionJCB, gridBagConstraints);

        matrixTypeJL.setText("Matrix Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(matrixTypeJL, gridBagConstraints);

        matrixTypeJCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Information(ribl)", "User Defined" }));
        matrixTypeJCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                matrixTypeJCBItemStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(matrixTypeJCB, gridBagConstraints);

        matrixPathJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(matrixPathJTF, gridBagConstraints);

    }//GEN-END:initComponents

    private void mrnaVersionJCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_mrnaVersionJCBItemStateChanged
        // Add your handling code here:
        String str = (String) evt.getItem();
        if(directoryJTF != null )
            directoryJTF.setText(str+"/");
    }//GEN-LAST:event_mrnaVersionJCBItemStateChanged

    private void matrixTypeJCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_matrixTypeJCBItemStateChanged
        // Add your handling code here:
        if(matrixTypeJCB.getSelectedIndex() == 0 )  // matrix type is ribl
        {   
            matrixPathJL.setText("Ribl Path");  
            matrixPathJTF.setText("default");
        }
        else if(matrixTypeJCB.getSelectedIndex() == 1 )  // matrix type is user defined
        {   
            matrixPathJL.setText("Matrix Path");  
            matrixPathJTF.setText("");        
        }            
    }//GEN-LAST:event_matrixTypeJCBItemStateChanged

    public void setMrnaVersionJCBItemListener(java.awt.event.ItemListener itemList)
    {
        System.out.println("mainpanel: setting the mrnajcb.itemlistener");
        mrnaVersionJCB.addItemListener(itemList);
    }
    
    public javax.swing.JComboBox getMrnaVersionJCB()
    {   return mrnaVersionJCB;  }
        
    public String getProgram()
    {   return program; }
    
    public void setProgram(String prg)
    {        
        prg = prg.trim().toLowerCase();
        this.program = prg;
        if(prg.equals("promotsite") )
        {
            scanpJL.setVisible(false);  scanpJTF.setVisible(false); scanpJB.setVisible(false);
            matrixTypeJL.setVisible(false); matrixTypeJCB.setVisible(false);
            matrixPathJL.setVisible(false); matrixPathJTF.setVisible(false); 
            matrixPathJB.setVisible(false);
            directoryJTF.setText("");
        }
        else
        {
            scanpJL.setVisible(true);  scanpJTF.setVisible(true); scanpJB.setVisible(true);
            matrixTypeJL.setVisible(true); matrixTypeJCB.setVisible(true);
            matrixPathJL.setVisible(true); matrixPathJTF.setVisible(true); 
            matrixPathJB.setVisible(true);            
            if( prg.equals("scan") );                
            else;
        }
            
    }//setProgram()
        
    private String scanHelp()
    {
        String mesg;
        mesg = "Scanp and Ribl are the parameter files for Scan. \n";
        mesg += "Note: Select the Scanp file here or enter the \n";
        mesg += "parameters manually later.";
        mesg += "\nNote: Ribl file has to be selected here.";
        mesg += "\nNote: Enter \"default\" for scanp, ribl to let \n";
        mesg += "the server choose the default files.\n";
        mesg += "\nDest Directory: A directory with this name is\n";
        mesg += "created on the server to store the results\n";        
        mesg += "Note: Enter \"default\" for Dest Directory to let\n";
        mesg += "the server choose a name for this directory\n\n";
        return mesg;
    }
    private String psHelp()
    {
        String mesg;
        mesg = "Dest Directory: The name of a directory on the server\n";
        mesg+= "in which the results of 'scan' are stored\n";
        mesg+= "This directory is stored in the server at a location defined\n"; 
        mesg+= "by the server environment variable DELGEN_RESULTS\n";        
        mesg+= "This value cannot be empty or default for promotsite\n\n";
        return mesg;
    }
    private void helpJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpJBActionPerformed
        // Add your handling code here:
        String mesg;
        mesg = "Program to run: Select a listed program to run on the server\n\n";
        mesg +="Chrm Range: The range of chromosomes on which the program\n";
        mesg +="is executed. To choose a single chromosome, select both values\n";
        mesg +="as equal\n\n";
        if( !getProgram().equals("promotsite") )
            mesg += scanHelp();
        else    mesg += psHelp();
        mesg += "\nServer Address: The Hostname/IPAdress of the server\n";
        
        mesg += "\nEmail Address: The email address to which a notification\n";
        mesg += "is sent when the scan process is completed\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_helpJBActionPerformed
    
    private void psParamsJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_psParamsJBActionPerformed
        // Add your handling code here:
        //javax.swing.JFileChooser file = new javax.swing.JFileChooser();
        file.setFileSelectionMode( javax.swing.JFileChooser.FILES_ONLY );
        file.setDialogTitle( "Select PromotSite Params File" );
        int result = file.showOpenDialog(parent);
        if ( ! (result == javax.swing.JFileChooser.CANCEL_OPTION) ) {
            psParams = file.getSelectedFile().getPath();
        }
        else
            psParams = "";
        psParamsJTF.setText(psParams);
    }//GEN-LAST:event_psParamsJBActionPerformed
    
    private void matrixPathJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_matrixPathJBActionPerformed
        // Add your handling code here:
        //javax.swing.JFileChooser file = new javax.swing.JFileChooser();
        file.setFileSelectionMode( javax.swing.JFileChooser.FILES_ONLY );
        file.setDialogTitle( "Select matrix File" );
        int result = file.showOpenDialog(parent);
        if ( ! (result == javax.swing.JFileChooser.CANCEL_OPTION) ) {
            matrixPath = file.getSelectedFile().getPath();
        }
        else
            matrixPath = "";        
        matrixPathJTF.setText(matrixPath);
    }//GEN-LAST:event_matrixPathJBActionPerformed
    
    private void scanpJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_scanpJBActionPerformed
        // Add your handling code here:
        //javax.swing.JFileChooser file = new javax.swing.JFileChooser();
        file.setFileSelectionMode( javax.swing.JFileChooser.FILES_ONLY );
        file.setDialogTitle( "Select Scanp File" );
        int result = file.showOpenDialog(parent);
        if ( ! (result == javax.swing.JFileChooser.CANCEL_OPTION)   ) {
            scanp = file.getSelectedFile().getPath();
        }
        else
            scanp = "";
        scanpJTF.setText(scanp);
    }//GEN-LAST:event_scanpJBActionPerformed
    
        
    public String getScanRange1()  { return ((String)scanRange1JCB.getSelectedItem()).trim(); }
    public String getScanRange2()  { return ((String)scanRange2JCB.getSelectedItem()).trim(); }    
    // The below two functions return the selected index and NOT the ranges parsed as integers
    public int getScanRange1int()  { return scanRange1JCB.getSelectedIndex();    }
    public int getScanRange2int()  { return scanRange2JCB.getSelectedIndex();    }
    
    public String getMatrixType() 
    { 
        String str="";
        if( matrixTypeJCB.getSelectedIndex() == 0 )
            str="ribl";
        else if( matrixTypeJCB.getSelectedIndex() == 1 )
            str="user";
        return str;
    }
            
    public String getMatrixPath()
    {   return matrixPathJTF.getText(); }
    
    //public String getRibl()    {   return (riblJCB.getSelectedItem().toString());    }
    
    public String getScanp()    {   return scanpJTF.getText();   }
    
    public String getPsParams()    {   return psParamsJTF.getText();   }
    
    public String getDestDirectory()    {   return directoryJTF.getText(); }
    
    public void setDestDirectory(String dir)    {   directoryJTF.setText(dir);  }
    
        
    public String getEmailAddr()    {   return emailJTF.getText();  }
        
    public String getUserData()
    {
        String ret ="";
        ret += "email" + " " + getEmailAddr() + "\n";        
        return ret.trim();
    }    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel emailJL;
    private javax.swing.JTextField directoryJTF;
    private javax.swing.JButton matrixPathJB;
    private javax.swing.JLabel psParamsJL;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JComboBox scanRange2JCB;
    private javax.swing.JLabel matrixTypeJL;
    private javax.swing.JLabel scanRange;
    private javax.swing.JLabel titleJP;
    private javax.swing.JButton helpJB;
    private javax.swing.JTextField matrixPathJTF;
    private javax.swing.JLabel directoryJL;
    private javax.swing.JLabel scanpJL;
    private javax.swing.JButton scanpJB;
    private javax.swing.JComboBox mrnaVersionJCB;
    private javax.swing.JLabel mrnaVersionJL;
    private javax.swing.JTextField emailJTF;
    private javax.swing.JTextField scanpJTF;
    private javax.swing.JButton psParamsJB;
    private javax.swing.JLabel matrixPathJL;
    private javax.swing.JTextField psParamsJTF;
    private javax.swing.JComboBox matrixTypeJCB;
    private javax.swing.JComboBox scanRange1JCB;
    // End of variables declaration//GEN-END:variables
    
}
