/*
 * PromotSitePanel.java
 *
 * Created on December 13, 2002, 3:58 AM
 */

/**
 *
 * @author  sashidhar gadiraju
 */

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class PromotSitePanel extends javax.swing.JPanel {
    java.awt.Component parent;
    String mrnaVersion="";
    /** Creates new form PromotSitePanel */
    public PromotSitePanel(java.awt.Component parent) {
        this.parent = parent;
        initComponents();
        //coordinatesJTF.setVisible(false);
        //coordinatesJL.setVisible(false);
        //coordinatesHJB.setVisible(false);
        directionJCB.addItem(new String("u") );
        directionJCB.addItem(new String("d") );
        directionJCB.addItem(new String("b") );        
        setUpStream();
    }
    
    public int setMrnaVersion(String inp)
    {
        if(inp == null) 
            return -1;
        mrnaVersion=inp;        
        return 1;
    }
	
    public void resetItems()
    {        
        mrnaVersion="";
        wSizeUpJTF.setText("10000");
        setUpStream();
        directionJCB.setSelectedIndex(0);
        distanceJTF.setText("1000000");
        coordinatesJTF.setText("");
        trackColorRJTF.setText("128"); trackColorRJTF.setEnabled(true);
        trackColorGJTF.setText("128"); trackColorGJTF.setEnabled(true);
        trackColorBJTF.setText("128"); trackColorBJTF.setEnabled(true);
        trackShadeJCB.setSelectedIndex(0);        
    }
        
    public void setUpStream()
    {        
        directionJCB.setSelectedItem("u");
        wSizeUpJTF.setEditable(true);
        wSizeDownJTF.setText("0");
        wSizeDownJTF.setEditable(false);
    }
    
    public void setDownStream()
    {
        directionJCB.setSelectedItem("d");
        wSizeDownJTF.setEditable(true);
        wSizeUpJTF.setText("0");
        wSizeUpJTF.setEditable(false);
    }
    
    public void setBothStreams()
    {
        directionJCB.setSelectedItem("b");
        wSizeUpJTF.setEditable(true);
        wSizeDownJTF.setEditable(true);
    }
    
    public String getTrackColor()
    {
        String color = trackColorRJTF.getText().trim() + "," +
                       trackColorGJTF.getText().trim() + "," + 
                       trackColorBJTF.getText().trim();
        return color;
    }
    
    public String getTrackShade()
    {   return ((String)trackShadeJCB.getSelectedItem()).trim();    }    
    
    public String getDirection()
    {   return ( (String)directionJCB.getSelectedItem() ).trim(); }
    
    public String getCoordinates()
    {   return coordinatesJTF.getText().trim() ;  }
    
    public String getPsParamsText()
    {
        String ret="";
        String dir = getDirection();
        if( dir.equals("u") )
            ret += "wsize "+wSizeUpJTF.getText().trim()+"\n";
        else if( dir.equals("d") )
            ret += "wsize "+wSizeDownJTF.getText().trim()+"\n";
        else if( dir.equals("b") )
            ret += "wsize "+wSizeUpJTF.getText().trim()+" "+wSizeDownJTF.getText().trim()+"\n";
        ret += "mrnaversion " + mrnaVersion.trim() + "\n";
        ret += "psdistance " + distanceJTF.getText().trim()+"\n";
        ret += "direction " + getDirection() + "\n";
        String coord = getCoordinates();
        if(! coord.equals("") )
            ret += "coordinates " + coord + "\n";
        ret += "trackcolor " + getTrackColor();
        System.out.println("PSParams file:\n"+ret);
        return ret;
    }//getPSParamsText()

    protected int validateWSizeUp(String line)
    {   return validateWSize(line); }
    
    protected int validateWSizeDown(String line)
    {   return validateWSize(line); }
        
    protected int validateWSize(String line)
    {
        if(line==null)
            return -1;
        else if(!MyUtils.isULong(line) )
            return -1;
        return 1;
    }
    
    protected int validateMRNAVersion(String line)
    {
        if(line==null)
            return -1;
        return 1;
    }
    
    protected int validateDirection(String line)
    {
        if(line==null)
            return -1;
        else
        {
            String tline = line.trim().toLowerCase();
            if( !tline.equals("u") && !tline.equals("d") && !tline.equals("b") )
                return -1;
        }
        return 1;
    }
    
    protected int validateCoordinates(String line)
    {
        return 1;
    }
    
    protected int validatePSDistance(String line)
    {
        if(line==null)
            return -1;
        else
        {
            if( !MyUtils.isULong(line) )
                return -1;
        }
        return 1;
    }
    
    protected int validateTrackColor(String red, String green, String blue)
    {
        if( !MyUtils.isInteger(red,0,255) || !MyUtils.isInteger(green,0,255) || !MyUtils.isInteger(blue,0,255) )
            return -1;
        return 1;
    }
    
    public String i2a(int i)    {   return String.valueOf(i);   }
    
    public String parsePSParams()
    {
        int gret =1, ret =1;
        String errString="";
        
        ret = validateWSizeUp(wSizeUpJTF.getText() );
        if(ret < 0) {errString+=getErrorMesg(7); gret = -1;  }
        
        ret = validateWSizeDown(wSizeDownJTF.getText() );
        if(ret < 0) {errString+=getErrorMesg(8); gret = -1;  }
        
        ret = validateDirection( (String)directionJCB.getSelectedItem() );
        if(ret < 0) {errString+=getErrorMesg(3); gret = -1;  }
        
        ret = validatePSDistance( distanceJTF.getText() );
        if(ret < 0) {errString+=getErrorMesg(4); gret = -1;  }
        
        ret = validateCoordinates( coordinatesJTF.getText() );
        if( ret < 0) {errString+=getErrorMesg(5); gret = -1;    }
        
        ret = validateTrackColor( trackColorRJTF.getText(), 
                                    trackColorGJTF.getText(),
                                    trackColorBJTF.getText());
        if(ret < 0) {errString+=getErrorMesg(6); gret = -1;  }
        
        if(gret>0)  errString ="";
        return errString;
    }
    
    public String getErrorMesg(int err)
    {
        String mesg="";
        switch(err)
        {
            case 0:{	mesg = ""; break;	}
            case 1:{	mesg = "Error in MRNA Version\n"; break;	}				   
            case 2:{	mesg = "Error in Window Size\n"; break;	}				   
            case 3:{	mesg = "Error in Direction\n"; break;	}    
            case 4:{	mesg = "Error in PS Distance\n"; break;	}				   
            case 5:{	mesg = "Error in Search Coordinates String\n"; break;	}				   
            case 6:{	mesg = "Error in Track Colors\n"; break;	}
            case 7:{    mesg = "Error in Upstream window size\n";break;   }
            case 8:{    mesg = "Error in Downstream window size\n";break;   }
            default:{	mesg = ""; break;	}
        }
        return mesg;
    }
		
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        titleJL = new javax.swing.JLabel();
        wSizeJL = new javax.swing.JLabel();
        wSizeUpJTF = new javax.swing.JTextField();
        wSizeDownJTF = new javax.swing.JTextField();
        wSizeHJB = new javax.swing.JButton();
        directionJL = new javax.swing.JLabel();
        directionJCB = new javax.swing.JComboBox();
        directionHJB = new javax.swing.JButton();
        distanceJL = new javax.swing.JLabel();
        distanceJTF = new javax.swing.JTextField();
        distanceHJB = new javax.swing.JButton();
        coordinatesJL = new javax.swing.JLabel();
        coordinatesJTF = new javax.swing.JTextField();
        coordinatesHJB = new javax.swing.JButton();
        trackColorJL = new javax.swing.JLabel();
        trackColorRJTF = new javax.swing.JTextField();
        trackColorHJB = new javax.swing.JButton();
        trackColorGJTF = new javax.swing.JTextField();
        trackColorBJTF = new javax.swing.JTextField();
        trackShadeJL = new javax.swing.JLabel();
        trackShadeJCB = new javax.swing.JComboBox();
        trackShadeHJB = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setForeground(new java.awt.Color(0, 0, 0));
        titleJL.setForeground(new java.awt.Color(0, 0, 0));
        titleJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleJL.setText("Enter the promotsite parameters");
        titleJL.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(titleJL, gridBagConstraints);

        wSizeJL.setText("Window Size(Upstr Downstr)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(wSizeJL, gridBagConstraints);

        wSizeUpJTF.setColumns(8);
        wSizeUpJTF.setText("10000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(wSizeUpJTF, gridBagConstraints);

        wSizeDownJTF.setColumns(8);
        wSizeDownJTF.setText("10000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(wSizeDownJTF, gridBagConstraints);

        wSizeHJB.setText("Help");
        wSizeHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wSizeHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(wSizeHJB, gridBagConstraints);

        directionJL.setText("Search Direction");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(directionJL, gridBagConstraints);

        directionJCB.setMaximumRowCount(3);
        directionJCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                directionJCBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(directionJCB, gridBagConstraints);

        directionHJB.setText("Help");
        directionHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                directionHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(directionHJB, gridBagConstraints);

        distanceJL.setText("Distance between Paralogs");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(distanceJL, gridBagConstraints);

        distanceJTF.setColumns(8);
        distanceJTF.setText("1000000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(distanceJTF, gridBagConstraints);

        distanceHJB.setText("Help");
        distanceHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                distanceHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(distanceHJB, gridBagConstraints);

        coordinatesJL.setText("Search Coordinates String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(coordinatesJL, gridBagConstraints);

        coordinatesJTF.setColumns(8);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(coordinatesJTF, gridBagConstraints);

        coordinatesHJB.setText("Help");
        coordinatesHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                coordinatesHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(coordinatesHJB, gridBagConstraints);

        trackColorJL.setText("Track Color(RGB)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackColorJL, gridBagConstraints);

        trackColorRJTF.setColumns(3);
        trackColorRJTF.setText("128");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackColorRJTF, gridBagConstraints);

        trackColorHJB.setText("Help");
        trackColorHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trackColorHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackColorHJB, gridBagConstraints);

        trackColorGJTF.setColumns(3);
        trackColorGJTF.setText("128");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackColorGJTF, gridBagConstraints);

        trackColorBJTF.setColumns(3);
        trackColorBJTF.setText("128");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackColorBJTF, gridBagConstraints);

        trackShadeJL.setText("Track Shade");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackShadeJL, gridBagConstraints);

        trackShadeJCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "", "100,50,0", "0,60,120" }));
        trackShadeJCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trackShadeJCBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackShadeJCB, gridBagConstraints);

        trackShadeHJB.setText("Help");
        trackShadeHJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trackShadeHJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(trackShadeHJB, gridBagConstraints);

    }//GEN-END:initComponents

    private void trackShadeHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trackShadeHJBActionPerformed
        // Add your handling code here:
        String mesg = "For all user defined track colors, the track\n"; 
               mesg +="is displayed in shades of grey unless the \n";
               mesg +="track color is set to 100,50,0(shades of brown)\n";
               mesg +="or 0,60,120(shades of blue)\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Promotsite Help", javax.swing.JOptionPane.INFORMATION_MESSAGE);                
    }//GEN-LAST:event_trackShadeHJBActionPerformed

    private void trackShadeJCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trackShadeJCBActionPerformed
        // Add your handling code here:
        switch( trackShadeJCB.getSelectedIndex() )
        {
            case 0 :    {   trackColorRJTF.setEnabled(true); trackColorGJTF.setEnabled(true);
                            trackColorBJTF.setEnabled(true); break; }
            case 1 :    {   trackColorRJTF.setEnabled(false); trackColorRJTF.setText(i2a(100));
                            trackColorGJTF.setEnabled(false); trackColorGJTF.setText(i2a(50));
                            trackColorBJTF.setEnabled(false); trackColorBJTF.setText(i2a(0));
                            break;  }
            case 2 :    {   trackColorRJTF.setEnabled(false); trackColorRJTF.setText(i2a(0));
                            trackColorGJTF.setEnabled(false); trackColorGJTF.setText(i2a(60));
                            trackColorBJTF.setEnabled(false); trackColorBJTF.setText(i2a(120));
                            break;  }
            default:    {   trackColorRJTF.setEnabled(true); trackColorGJTF.setEnabled(true);
                            trackColorBJTF.setEnabled(true); break; }
        }//switch
                            
    }//GEN-LAST:event_trackShadeJCBActionPerformed

    private void directionJCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_directionJCBActionPerformed
        // Add your handling code here:
        if(directionJCB.getSelectedItem().equals("d") )
        {   setDownStream();    }
        else if(directionJCB.getSelectedItem().equals("u") )
        {   setUpStream();  }
        else if(directionJCB.getSelectedItem().equals("b") )
        {   System.out.println("in both streams");
            setBothStreams();   }
    }//GEN-LAST:event_directionJCBActionPerformed

    private void trackColorHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trackColorHJBActionPerformed
        // Add your handling code here:
        String mesg="TrackColor: The color in RGB for the genome browser display\n";
        mesg+="Values for each of R, G, and B: 0..255\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Promotsite Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_trackColorHJBActionPerformed

    private void coordinatesHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_coordinatesHJBActionPerformed
        // Add your handling code here:
        String mesg="Search Coordinates String:\n";
        mesg+="Specify the coordinate range and the chromosome names\n";
        mesg+="list to pull the sites. A site is reported if its \n";
        mesg+="coordinate lies within the given range.\n\n";        
        mesg+="Cordinate String format: BASIC;BASIC;....\n";
        mesg+="BASIC Format: chrNUM:COORD,COORD,....\n";
        mesg+="NUM format: 1..22/X/Y\n";
        mesg+="COORD Format: START-END,START-END,...\n";
        mesg+="START format: Any positive integer\n";
        mesg+="END format: Any positive integer\n";
        
        mesg+="\n";
        mesg+="Ex: \n"; 
        mesg+=":-  #a valid string to repesent all chromosomes and all ranges\n";
        mesg+="chr:-    #same as above, 'chr' means all chromosomes\n";                
        mesg+="chrX:1000-		#sites on X above coordinate 1000 \n";
        mesg+="chr4:-4000		#sites on 4 below coordinate 4000 \n";
        mesg+="chrX:1000		#same as chrX:1000-\n";
        mesg+="chr10:100-200	#sites on 10 between coordinates 100 and 200	\n";
        mesg+="chr:10000-20000	#sites on all chromosomes between coordinates 10000 and 20000\n";
        mesg+="chr5:100000-200000,3000000-400000   #two different ranges on chromosome 5\n";
        
        mesg+="chrY:200-5000,10000-40000;chr1:3000;chr1:5000-10000	#multiple chrmosomes\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Promotsite Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 			 
    }//GEN-LAST:event_coordinatesHJBActionPerformed

    private void distanceHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_distanceHJBActionPerformed
        // Add your handling code here:
        String mesg="Distance Between Paralogs: Minimum distance between the paralogs\n";
        mesg+="with the same accession number\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Promotsite Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_distanceHJBActionPerformed

    private void directionHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_directionHJBActionPerformed
        // Add your handling code here:
        String mesg="Direction for search of binding sites from \n";
        mesg+="the gene start coordinate\n\n";
        mesg+="u : upstream from the start coordinate\n";
        mesg+="d : downstream from the start coordinate\n";
        mesg+="b : both upstream and downstream from the start coordinate\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Promotsite Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_directionHJBActionPerformed

    private void wSizeHJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wSizeHJBActionPerformed
        // Add your handling code here:
        String mesg="Window size:Distance from the gene start co-ordinate\n";
        mesg+="in which the search for binding sites is performed";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Promotsite Help", javax.swing.JOptionPane.INFORMATION_MESSAGE); 
    }//GEN-LAST:event_wSizeHJBActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel directionJL;
    private javax.swing.JButton trackColorHJB;
    private javax.swing.JTextField wSizeUpJTF;
    private javax.swing.JComboBox trackShadeJCB;
    private javax.swing.JButton trackShadeHJB;
    private javax.swing.JLabel distanceJL;
    private javax.swing.JTextField distanceJTF;
    private javax.swing.JTextField trackColorRJTF;
    private javax.swing.JLabel coordinatesJL;
    private javax.swing.JLabel titleJL;
    private javax.swing.JTextField trackColorBJTF;
    private javax.swing.JLabel trackColorJL;
    private javax.swing.JTextField coordinatesJTF;
    private javax.swing.JButton distanceHJB;
    private javax.swing.JLabel trackShadeJL;
    private javax.swing.JTextField trackColorGJTF;
    private javax.swing.JTextField wSizeDownJTF;
    private javax.swing.JLabel wSizeJL;
    private javax.swing.JComboBox directionJCB;
    private javax.swing.JButton wSizeHJB;
    private javax.swing.JButton coordinatesHJB;
    private javax.swing.JButton directionHJB;
    // End of variables declaration//GEN-END:variables
    
}
