/*
 * ScanFront.java
 *
 * Created on December 13, 2002, 12:46 AM
 * version time 12/16/2002 5.45pm
 */

/**
 *
 * @author  sashidhar gadiraju
 */

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


import java.util.*;

public class ScanFront extends javax.swing.JFrame {
    MainPanel mainPanel;
    ScanpPanel scanpPanel;
    PromotSitePanel psitePanel;
    FilePanel filePanel;
    WMatrixPanel wmPanel;
    String genversions[];   //for storing the genome versions list
    String genverChrm[][];  //for storing the chrmlist for each genversion
    // itemListener is used to listen to any items(like combos) which the panels in 
    // ScanFront generates
    java.awt.event.ItemListener itemListener = new java.awt.event.ItemListener() 
    {
        public void itemStateChanged(java.awt.event.ItemEvent evt) 
        {            
            if(evt.getSource() == (Object)mainPanel.getMrnaVersionJCB())
            {
                mrnaVersionJCBItemStateChanged(mainPanel.getMrnaVersionJCB());
            }
        }
    };
    
    java.io.File scanp,ribl,psparams;
    SendText sock;
    String windows[] = { "main", "scanp", "promotsite", "filepanel", "matrix" };
    String curWin = windows[0];
    HashMap parentHash;
    
    
    /** Creates new form ScanFront */
    public ScanFront(HashMap parentHash) {        
        initComponents();        
        this.parentHash = parentHash;
        mainPanel = new MainPanel(this);
        scanpPanel = new ScanpPanel(this);
        psitePanel = new PromotSitePanel(this);
        filePanel = new FilePanel(this);
        wmPanel = new WMatrixPanel(this);
        
        java.awt.Toolkit tlk = getToolkit();
        java.awt.Dimension d = tlk.getScreenSize();
        //System.out.println(" Screen size is " + d.width + "  " + d.height );
        setSize( ((d.width -40) > 525)? 525:(d.width-40) ,((d.height -40) > 675)? 675:(d.height-40));        
        setLocation( 10, 10 ); 
        show();
        
        mainPanel.setProgram( getProgram() );        
        midJSP.setViewportView(mainPanel);                
        //get the Genome Assembly version list from the server
        sock = new SendText(getServerAddr(), getPort());
        sock.resetItems();
        // set the server basedir for retrieving the genversions file to the environment var DELGEN_GENOMES
        sock.addParam("basedirenv", "DELGEN_GENOMES");          
        sock.addParam("filename","genversions");
        sock.addParam("dirname","");
        int ret = sock.sendText("getfile","");
        String glist[] = new String[1000];
        int gencnt =0;
        if(ret>=200 && ret<=299)
        {
            String strret = new String(sock.getContent());
            java.util.StringTokenizer st = new java.util.StringTokenizer(strret, "\n\r\f");                        
            while(st.hasMoreTokens() && gencnt<1000)
            {   glist[gencnt++] = st.nextToken();    }
            if(gencnt<=0)
            {   showError("No genomes installed at the server" , "Server error");   return; }            
            mainPanel.setMrnaVersion(glist,gencnt);
        }
        else
        {   
            showError(sock.getErrString(),"Error in retrieving Genome Version list from server");                
            dispose();
            return;
        }
        genversions = new String[gencnt];    //initialize the genversions array        
        genverChrm = new String[gencnt][];  //the chrm list array for each genversion
        
        for(int i=0;i<gencnt; ++i)
            genversions[i] = glist[i];   //save the genome version list in global string array genver
        //Now set the chromosome list range in the main scanpanel
        setChrmList(glist[0],0);  //the first genome version installed as per the genversions list
        glist = null;   //set object ready for garbage collection
        // now set the mrnajcb listener
        // setting this before the genversions array is created might cause the program to crash
        mainPanel.setMrnaVersionJCBItemListener(itemListener);
        
    }//scanFront()
        
    //sets the chrm list in the main panel
    //genver is the genome version being used
    //genindex is the index of genver in the genversions list
    public void setChrmList(String genver, int genindex)
    {   
        String chrmlist[]; int cnt = 0;    //cnt is the number of chrm in chrmlist
        if( genverChrm[genindex] == null)   // chrmlist for genver not found in cache
        {
            chrmlist = new String[1000];             
            // set the server basedir for retrieving the chrmlist file to the environment var DELGEN_GENOMES
            sock.addParam("basedirenv", "DELGEN_GENOMES");          
            sock.addParam("dirname", genver.trim());    //the dir name in DELGEN_GENOMES
            sock.addParam("filename","chrmlist");        
            int ret = sock.sendText("getfile","");
            if(ret>=200 && ret<=299)
            {
                String strret = new String(sock.getContent());
                java.util.StringTokenizer st1 = new java.util.StringTokenizer(strret, "\n\r");  //brk on new lines
                while(st1.hasMoreTokens() )
                {
                    String line = st1.nextToken().trim();
                    if(line.startsWith("*") || line.equals("")) //go to next line if comment or empty
                        continue;   // if line starts with '*', its a comment
                    java.util.StringTokenizer st2 = new java.util.StringTokenizer(line);
                    String chnum = st2.nextToken();   //chrm num is in the first column
                    chrmlist[cnt]=st2.nextToken();    //chrm name is in the second column
                    if(chrmlist[cnt].equals(""))
                    {
                        showError("No chrm name listed for "+chnum+" in chrmlist for "+genver+ "from server", "Server Error");
                        return;
                    }
                    cnt++;
                }            
                if(cnt<=0)
                {
                    showError("No chromosomes listed in chrmlist for "+genver+ "from server", "Server Error");
                    return;
                }
            }// if no error in retrieving the chrmlist file
            else
            {   
                showError(sock.getErrString(),"Error in retrieving the chrmlist for "+genver+" from server");                
                dispose();
                return;
            } 
            genverChrm[genindex] = new String[cnt];
            for(int i=0;i<cnt;++i)
                genverChrm[genindex][i]=chrmlist[i];    //temporary cache
        }
        else    //chrmlist found in temporary list
        {
            chrmlist = genverChrm[genindex];
            cnt = genverChrm[genindex].length;
        }
        mainPanel.setChrmList(chrmlist, cnt);
        
        
    }//setChrmList()
    
    protected void mrnaVersionJCBItemStateChanged(javax.swing.JComboBox jcb)
    {
        //store the chrmlist in the temporary cache genverchrm[][]
        //first find the corresponding index of genversions
        int indx = -1;
        String genver = ((String)jcb.getSelectedItem()).trim();
        for(int i=0;i<genversions.length; ++i)
            if(genversions[i].trim().equals( genver ) ) indx=i;
        setChrmList((String)jcb.getSelectedItem(), indx);
    }
    
    public void resetItems()
    {
        backJB.setEnabled(false);
        nextJB.setText("Next");
        nextJB.setEnabled(true);
        mesgJL.setText("");
        sock= null;
        sock = new SendText(getServerAddr(), getPort());        
        scanp = ribl= psparams = null;
        curWin=  windows[0];        
        
        mainPanel.resetItems();
        scanpPanel.resetItems();
        psitePanel.resetItems();
        filePanel.resetItems();
        
        midJSP.setViewportView(mainPanel);        
        
        java.awt.Toolkit tlk = getToolkit();
        java.awt.Dimension d = tlk.getScreenSize();
        //System.out.println(" Screen size is " + d.width + "  " + d.height );
        setSize( ((d.width -40) > 525)? 525:(d.width-40) ,((d.height -40) > 675)? 675:(d.height-40));        
        setLocation( 10, 10 ); 
    }
    
    public int getPort()
    {
        String ret = (String)parentHash.get("port");
        ret = ret.trim();
        int rint = 7070;  //default value
        try{    rint = Integer.parseInt(ret);   }
        catch(Exception e ){    }
        return rint;
    }
    
    public String getServerAddr()
    {
        String ret = (String)parentHash.get("serveraddress");
        return ret.trim();
    }
    
    public String getProgram()
    {
        String ret = (String)parentHash.get("program");
        return ret.trim();
    }
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        titleJP = new javax.swing.JPanel();
        titleJL = new javax.swing.JLabel();
        midJSP = new javax.swing.JScrollPane();
        bottomJP = new javax.swing.JPanel();
        backJB = new javax.swing.JButton();
        nextJB = new javax.swing.JButton();
        mesgJL = new javax.swing.JLabel();
        resetJB = new javax.swing.JButton();

        setTitle("Delila-genome Front End Tool");
        titleJP.setPreferredSize(new java.awt.Dimension(20, 20));
        titleJL.setText("Genome Binding Site Scan");
        titleJP.add(titleJL);

        getContentPane().add(titleJP, java.awt.BorderLayout.NORTH);

        midJSP.setViewportBorder(new javax.swing.border.EtchedBorder());
        getContentPane().add(midJSP, java.awt.BorderLayout.CENTER);

        bottomJP.setLayout(new java.awt.GridBagLayout());

        bottomJP.setMinimumSize(new java.awt.Dimension(20, 20));
        bottomJP.setPreferredSize(new java.awt.Dimension(120, 65));
        backJB.setText("back");
        backJB.setEnabled(false);
        backJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        bottomJP.add(backJB, gridBagConstraints);

        nextJB.setText("next");
        nextJB.setMaximumSize(new java.awt.Dimension(90, 26));
        nextJB.setMinimumSize(new java.awt.Dimension(62, 26));
        nextJB.setPreferredSize(new java.awt.Dimension(75, 26));
        nextJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        bottomJP.add(nextJB, gridBagConstraints);

        mesgJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(8, 3, 8, 3);
        bottomJP.add(mesgJL, gridBagConstraints);

        resetJB.setText("Reset All");
        resetJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 20);
        bottomJP.add(resetJB, gridBagConstraints);

        getContentPane().add(bottomJP, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents

    private void resetJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetJBActionPerformed
        // Add your handling code here:
        resetItems();
    }//GEN-LAST:event_resetJBActionPerformed

    private void backJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backJBActionPerformed
        // Add your handling code here:
        String status = curWin;    
        String prog = getProgram().trim();
        String matrixType = mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = mainPanel.getMatrixPath().trim().toLowerCase();
        
        nextJB.setEnabled(true);
        if( status.equals(windows[0]) ) //in the mainpanel
        {
            backJB.setEnabled(false);            
            nextJB.setText("next");
        }
        else if( status.equals(windows[4]) )    //in the wmpanel
        {
            //go to the mainPanel parameters panel            
            curWin = windows[0];
            backJB.setEnabled(false);            
            nextJB.setText("next");
            midJSP.setViewportView(mainPanel);
        }
        else if( status.equals(windows[1]) )
        {
            //go to wmpanel if matrix type is user def. and the user 
            //entered params through the wmpanel and not through a file
            if(matrixType.equals("user") && matrixPath.equals("") )
            {
                //go to the wmpanel parameters panel            
                curWin = windows[4];
                backJB.setEnabled(true);            
                nextJB.setText("next");
                midJSP.setViewportView(wmPanel);
            }
            else
            {
                //go to the mainPanel parameters panel            
                curWin = windows[0];
                backJB.setEnabled(false);            
                nextJB.setText("next");
                midJSP.setViewportView(mainPanel);
            }
        }
        else if(prog.equals("scan") )
        {
            if( status.equals(windows[2]) )
            {            
                //go to the scanp parameters panel            
                curWin = windows[1];
                backJB.setEnabled(true);
                nextJB.setText("next");
                midJSP.setViewportView(scanpPanel);
            }
            else if(status.equals(windows[3]) )
            {
                //process the file display appropriately
                String win = filePanel.getWindow();
                if(win.equals("base") )
                {   curWin = windows[1];
                    midJSP.setViewportView(scanpPanel); }
                else if(win.equals("scanp") )
                {   
                    String errString = "Any final editing in the scanp and weight matrix files will be lost\n";
                    errString += "Continue??\n";
                    int option = javax.swing.JOptionPane.showConfirmDialog(this, errString, "Important", javax.swing.JOptionPane.YES_NO_OPTION);
                    if( option == javax.swing.JOptionPane.YES_OPTION )
                    {
                        curWin = windows[1];
                        midJSP.setViewportView(scanpPanel); 
                    }
                }
                else if(win.equals("ribl") )
                {   filePanel.setScanp(); nextJB.setText("Next"); }                
            }
        }//if: scan
        else if(prog.equals("promotsite") )
        {
            if( status.equals(windows[2]) )
            {
                //go to the mainPanel parameters panel            
                curWin = windows[0];
                backJB.setEnabled(false);         
                nextJB.setText("next");
                midJSP.setViewportView(mainPanel);
            }
            else if( status.equals(windows[3]) )
            {
                //go the the promotsite panel
                curWin = windows[2];
                backJB.setEnabled(true);
                nextJB.setEnabled(true);
                nextJB.setText("next");
                midJSP.setViewportView(psitePanel);
            }
        }
        else    //scan+promotsite
        {
            if( status.equals(windows[2]) )
            {            
                //go to the scanp parameters panel            
                curWin = windows[1];
                backJB.setEnabled(true);
                nextJB.setText("next");
                midJSP.setViewportView(scanpPanel);
            }
            else if(status.equals(windows[3]) )
            {
                //process the file display appropriately
                String win = filePanel.getWindow();
                if(win.equals("base") )
                {   curWin = windows[2];
                    midJSP.setViewportView(psitePanel); }
                else if(win.equals("scanp") )
                {   
                    String errString = "Any final editing in the scanp, psparams and ribl files will be lost\n";
                    errString += "Continue??\n";
                    int option = javax.swing.JOptionPane.showConfirmDialog(this, errString, "Important", javax.swing.JOptionPane.YES_NO_OPTION);
                    if( option == javax.swing.JOptionPane.YES_OPTION )
                    {
                        curWin = windows[2];
                        midJSP.setViewportView(psitePanel); 
                    }
                }
                else if(win.equals("ribl") )
                {   filePanel.setScanp(); }
                else if(win.equals("psparams") )
                {   nextJB.setText("Next");   filePanel.setRibl(); }
            }
        }//if:scan+promotsite
                
    }//GEN-LAST:event_backJBActionPerformed

    private void nextJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextJBActionPerformed
        // Add your handling code here:
        String status = curWin;
        String prog = getProgram().trim();
        
        //System.out.println("In nextjb action, program = " + prog + "window="+curWin);
        
        if( prog.equals("scan") )
        {
            if(status.equals(windows[0] ) )
            {   doScanMain();   }   //same for scan and scan+promotsite 
            else if(status.equals(windows[1] ) )
            {   doScanScanp(); }
            else if(status.equals(windows[3] ) )
            {   doScanFileDisplay();  }
            else if(status.equals(windows[4] ) )
            {   doScanUserMatrix(); }
        }
        else if( prog.equals("promotsite") )
        {
            if(status.equals(windows[0] ) )
            {   doPSMain();   }
            else if(status.equals(windows[2] ) )
            {   doPSPromotSite(); }
            else if(status.equals(windows[3] ) )
            {   doPSFileDisplay();  }                
        }            
        else    //scan+promotsite
        {
            if( status.equals(windows[0]) )
            {   doMain();   }
            else if( status.equals(windows[1]) )    
            {   doScanp();   }
            else if( status.equals(windows[2]) )
            {   doPromotSite();   }
            else if(status.equals(windows[3]) )
            {   doFileDisplay();   }
            else if(status.equals(windows[4] ) )
            {   doUserMatrix(); }
        }
    }

    //The below functions implement the window flow logic for each of
    //scan, promotsite and scan+promotsite.
    protected void doScanMain()    {   doMain();   }//doScanMain()
    
    protected void doScanUserMatrix()   {   doUserMatrix(); }
    protected void doUserMatrix()   
    {
        String errstr = wmPanel.parseMatrix().trim();
        if( ! errstr.equals("") )
        {   showError(errstr, "Error in weight matrix parameters");  return; }
        backJB.setEnabled(true);
        setScanpParams();   //go the next panel which is the scanp panel
    }// doUserMatrix()    
    
    protected void doScanScanp()
    {
        String retVal="";
        //go to the file display panel            
        retVal = scanpPanel.parseScanp();
        if(!retVal.trim().equals("") )
        {
            System.out.println("Error Inputs\n" +retVal );
            showError(retVal, "Error in Scanp Parameters");
            return;
        }        
        backJB.setEnabled(true);
        curWin = windows[3];
        filePanel.resetItems();
        midJSP.setViewportView(filePanel);
        doScanFileDisplay();
    }//doScanScanp()
    
    protected void doScanFileDisplay()
    {
        String win = filePanel.getWindow();
        String matrixType = mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = mainPanel.getMatrixPath().trim().toLowerCase();
        
        if(win.equals("base") )
        {            
            filePanel.resetItems();
            filePanel.setScanp(scanpPanel.getScanpText() );
        }
        else if(win.equals("scanp") )
        {            
            if(!filePanel.isRiblSet() )
            {  
                if( matrixType.equals("ribl") )
                {
                    if(matrixPath.equals("default") )
                    {
                        //get the ribl file from the server and display
                        sock.resetItems();
                        sock.addParam("filename","ribl");
                        sock.addParam("dirname","");
                        int ret = sock.sendText("getfile","");
                        if(ret>=200 && ret<=299)
                        {   filePanel.setRibl( new String(sock.getContent() ) );    }
                        else
                        {   showError(sock.getErrString(),"Error in retrieving ribl from server");    }
                    }//if
                    else
                    {               
                        try{    filePanel.setRibl(new java.io.File(matrixPath));  }
                        catch(Exception e){ showError(e.toString(),"Error in opening Ribl file");   }
                    }
                }// if "ribl
                else if( matrixType.equals("user") )    //user def. wgt. matrix
                {
                    if(matrixPath.equals("") )   //user has entered params in the wmpanel
                    {
                        filePanel.setRibl( wmPanel.getMatrixText() );
                    }
                    else    // user had given a weight matrix file path
                    {
                        try{    filePanel.setRibl(new java.io.File(matrixPath));  }
                        catch(Exception e){ showError(e.toString(),"Error in opening weight matrix file "+matrixPath);   }
                    }
                }            
            }//if isRiblSet
            else
            {   filePanel.setRibl();    }
            nextJB.setText("Submit");
            nextJB.setEnabled(true);
        }
        else if(win.equals("ribl") )
        {
            sendScanfiles();
        }
    }//doScanFileDisplay()
    
    protected void sendScanfiles()
    {   sendfiles(1);   }
    
    protected void doPSMain()
    {
        String progName = getProgram().trim();
        String ddir = mainPanel.getDestDirectory().trim();
        String servaddr = getServerAddr().trim();               
                
        //check if the chromosome range is correct i.e. start <= end
        int scanst=mainPanel.getScanRange1int();
        int scanend=mainPanel.getScanRange2int();        
        if(scanst > scanend)
        {
            String mesg = "Incorrect Chrm Scan Range\n";
            mesg += "The start is greater than the end value\n";
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        //if the destination directory is empty, show error message
        if(ddir.equals("") )
        {
            String mesg = "Please enter the Destination Directory Name";            
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        else if(ddir.equals("default") )
        {
            String mesg = "Promotsite needs the name of an existing directory\n";
            mesg += "on the server containing the results of scan\n";
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        //if the server address is empty, show error message
        if (servaddr.equals("") )
        {
            String mesg = "Please enter the Server Address";            
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        sock = new SendText(servaddr, getPort());
        sock.resetItems();
        String tempdir = ddir;
        sock.addParam("dirname",tempdir);
        int sret = sock.sendText("checknewdir","");
        if(sret>=200 && sret<=299)
        {                
            String mesg ="No destination directory found with the user specified value\n";
            mesg += "Promotsite needs an existing directory name containing \n";
            mesg += "the results of scan";
            showError(mesg, "Error");
            return;
        }
        //go to the psparams panel            
        curWin = windows[2];
        backJB.setEnabled(true);            
        psitePanel.resetItems();
        
        sock.resetItems();
        sock.addParam("filename","genversions");
        sock.addParam("dirname","");
        int ret = sock.sendText("getfile","");
        if(ret>=200 && ret<=299)
        {
            String strret = new String(sock.getContent());
            java.util.StringTokenizer st = new java.util.StringTokenizer(strret, "\n\r\f");
            String glist[] = new String[1000];
            int i =0;
            while(st.hasMoreTokens() && i<1000)
            {   glist[i++] = st.nextToken();    }
            psitePanel.setMrnaVersion(mainPanel.getMrnaVersion());
        }
        else
        {   showError(sock.getErrString(),"Error in retrieving Genome Version list from server");    }
        midJSP.setViewportView(psitePanel);            
    }//doPSMain()

    protected void doPSPromotSite()
    {
        String retVal="";
        retVal = psitePanel.parsePSParams();
        if(!retVal.trim().equals("") )
        {
            System.out.println("Error Inputs\n" +retVal );
            showError(retVal, "Error in PromoSite Parameters");
            return;
        }	
        curWin = windows[3];
        filePanel.resetItems();
        midJSP.setViewportView(filePanel);
        doPSFileDisplay();
        //process completed. display the files to the user    
    }//doPSPromotSite()
    
    protected void doPSFileDisplay()
    {   
        String win = filePanel.getWindow();
        if(win.equals("base") )
        {            
            filePanel.resetItems();
            filePanel.setPsParams(psitePanel.getPsParamsText() );
            nextJB.setText("Submit");
        }
        else if(win.equals("psparams") )
        {
            //send the files to the server
            sendPSfiles();
        }
    }//doPSFileDisplay()
    
    protected void sendPSfiles()
    {   sendfiles(2);   }    
    
    protected void doMain()
    {
        String progName = getProgram().trim();
        String scanpName = mainPanel.getScanp().trim(); 
        String matrixType = mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = mainPanel.getMatrixPath().trim().toLowerCase();
        //String riblName = mainPanel.getRibl().trim();
        String ddir = mainPanel.getDestDirectory().trim();
        String servaddr = getServerAddr().trim();               
                
        //check if the chromosome range is correct i.e. start <= end
        int scanst=mainPanel.getScanRange1int();
        int scanend=mainPanel.getScanRange2int();        
        if(scanst > scanend)
        {
            String mesg = "Incorrect Chrm Scan Range\n";
            mesg += "The start is greater than the end value\n";
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        
        //check for the validity of the input parameter files
        //if the ribl file is empty, show error message
        System.out.println("matrixtype="+matrixType+" path="+matrixPath);
        if(matrixType.equals("ribl"))
        {        
            if( matrixPath.equals("") )
            {
                String mesg = "Please select a Ribl file";            
                javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
                return;
            }
            else if(!matrixPath.toLowerCase().equals("default") )        
                if (! fileExists(matrixPath) )
                {   showError("Unable to read Ribl file "+matrixPath,"Error"); return; }
        }
        else if(matrixType.equals("user"))  // user def. wgt. matrix
        {
            if(! matrixPath.equals("") )    // user gives input as a file
            {
                if(matrixPath.equals("default") )
                {   
                    showError("No default files defined for user defined matrices"+matrixPath,"Error"); 
                    return; 
                }
                else if (! fileExists(matrixPath) )
                {   showError("Unable to read Ribl file "+matrixPath,"Error"); return; }
            }
        }
        else
        {   showError("Unrecognized matrix type"+matrixPath,"Internal Error"); return; }

        //if the scanp file is empty, show error message
        if( scanpName.equals("") )
        {
            /*
            String mesg = "Please select a Scanp file";            
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
            */
        }
        else if(!scanpName.toLowerCase().equals("default") )
            if (! fileExists( scanpName ) )
            {   showError("Unable to read Scanp file","Error"); return; }        
        
        //if the destination directory is empty, show error message
        if(ddir.equals("") )
        {
            String mesg = "Please enter the Destination Directory Name";            
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        //if the server address is empty, show error message
        if (servaddr.equals("") )
        {
            String mesg = "Please enter the Server Address";            
            javax.swing.JOptionPane.showMessageDialog(this, mesg, "Error",javax.swing.JOptionPane.ERROR_MESSAGE);
            return;
        }
        
        //send a request to create a new directory at the server
        sock = new SendText(servaddr, getPort());
        if(ddir.toLowerCase().equals("default") )
        {
            sock.resetItems();
            sock.addHeader("Content-length","0");
            int sret = sock.sendText("getnewdir","");
            if(sret>=200 && sret<=299)
            {
                String tempdir = sock.getErrString().trim();
                mainPanel.setDestDirectory(tempdir);                
                //String temperrs = "Destination directory created created on the server:"+tempdir;
                //javax.swing.JOptionPane.showMessageDialog(this, temperrs, "", javax.swing.JOptionPane.INFORMATION_MESSAGE);
                mesgJL.setText("Destination Dir : "+tempdir);
            }
            else
            {   showError(sock.getErrString(), "Error"); return; }
        }//if:outer
        else//a directory name specified
        {
            sock.resetItems();
            String tempdir = ddir;
            sock.addParam("dirname",tempdir);
            int sret = sock.sendText("checknewdir","");
            if(sret>=200 && sret<=299)
            {                
                //mainPanel.setDestDirectory(tempdir);
                //String temperrs = "Specified destination directory created on the server";
                //javax.swing.JOptionPane.showMessageDialog(this, temperrs, "", javax.swing.JOptionPane.INFORMATION_MESSAGE);
                mesgJL.setText("Destination Dir : "+tempdir);
            }
            else
            {   showError(sock.getErrString(), "Error");  return;}
        }//else:outer
        
        //based on value of matrix type decide whether to go to scanp panel or wmatrixpanel
        if( matrixType.equals("ribl") )
        {
            setScanpParams();
        }
        else if( matrixType.equals("user") )  // user defined weight matrix
        {
            if(matrixPath.equals("") )
            {
                curWin = windows[4];    // set current window as the matrix parameter input panel
                wmPanel.resetItems();
                backJB.setEnabled(true);
                midJSP.setViewportView(wmPanel);
            }
            else    // user specified a file path. so no need to go to wmpanel 
            {
                setScanpParams();
            }
                
        }
    }//doMain

    protected void setScanpParams()
    {
        //go to the scanp parameters panel            
        curWin = windows[1];
        backJB.setEnabled(true);                    
        midJSP.setViewportView(scanpPanel);                    
        
        String scanpName = mainPanel.getScanp().trim(); 
        scanpPanel.resetItems();                
        if(scanpName.toLowerCase().equals("default"))
        {
            //get the scanp file from the server and display
            sock.resetItems();
            sock.addParam("filename","scanp");
            sock.addParam("dirname","");
            int ret = sock.sendText("getfile","");
            if(ret>=200 && ret<=299)
            {   
                try{
                String strret = scanpPanel.parseScanp(new String(sock.getContent() ) ); 
                System.out.println("Result::"+strret);
                if(!strret.trim().equals("") )
                    showError(strret , "Error in Scanp file");
                }catch(Exception e )
                {   showError("Error in retrieving scanp from server","Error"); }
            }
            else
            {   showError(sock.getErrString(),"Error in retrieving scanp from server");    }
        }            
        else if( !scanpName.equals("") )//change to scan for default file
        {
            try{
            scanp  = new java.io.File(scanpName);				
            String ret  = scanpPanel.parseScanp( new java.io.FileInputStream(scanp) );
            System.out.println("Result::"+ret);
            if(!ret.trim().equals("") )
                showError(ret , "Error in Scanp file");

            }catch(Exception e ){	showError("Scanp file not found","Error");	}
        }
        
    }// setScanpParams()
    
        
    protected void doScanp()
    {   
        String retVal="";
        //go to the promotsite parameters panel            

        retVal = scanpPanel.parseScanp();
        if(!retVal.trim().equals("") )
        {
            System.out.println("Error Inputs\n" +retVal );
            showError(retVal, "Error in Scanp Parameters");
            return;
        }
        
        backJB.setEnabled(true);
        //nextJB.setText("Submit");
        //psitePanel.resetItems();
                
        psitePanel.setMrnaVersion(mainPanel.getMrnaVersion());
        
        curWin = windows[2];
        midJSP.setViewportView(psitePanel);        
    }//doScanp()    
    
    protected void doPromotSite()
    {    
        String retVal="";
        retVal = psitePanel.parsePSParams();
        if(!retVal.trim().equals("") )
        {
            System.out.println("Error Inputs\n" +retVal );
            showError(retVal, "Error in PromoSite Parameters");
            return;
        }	
        curWin = windows[3];
        filePanel.resetItems();
        midJSP.setViewportView(filePanel);
        doFileDisplay();
        //process completed. display the files to the user    
    }//GEN-LAST:event_nextJBActionPerformed
    
        
    protected void doFileDisplay()
    {   
        String win = filePanel.getWindow();
        String matrixType = mainPanel.getMatrixType().trim().toLowerCase();
        String matrixPath = mainPanel.getMatrixPath().trim().toLowerCase();
        
        if(win.equals("base") )
        {            
            filePanel.resetItems();
            filePanel.setScanp(scanpPanel.getScanpText() );
        }
        else if(win.equals("scanp") )
        {            
            if(!filePanel.isRiblSet() )
            {   
                if(matrixType.equals("ribl") )
                {
                    if(matrixPath.equals("default") )
                    {
                        //get the ribl file from the server and display
                        sock.resetItems();
                        sock.addParam("filename","ribl");
                        sock.addParam("dirname","");
                        int ret = sock.sendText("getfile","");
                        if(ret>=200 && ret<=299)
                        {   filePanel.setRibl( new String(sock.getContent() ) );    }
                        else
                        {   showError(sock.getErrString(),"Error in retrieving Ribl from server");    }
                    }//if
                    else
                    {                
                        try{    filePanel.setRibl(new java.io.File(matrixPath ));  }
                        catch(Exception e){ showError(e.toString(),"Error in opening Ribl file");   }
                    }
                }// if type=ribl
                else if(matrixType.equals("user") )
                {
                    if(matrixPath.equals("") )
                        filePanel.setRibl( wmPanel.getMatrixText() );
                    else
                    {
                        try{    filePanel.setRibl(new java.io.File(matrixPath ));  }
                        catch(Exception e){ showError(e.toString(),"Error in opening weight matrix file");   }
                    }   
                }//else if type=user
            }else
            {   filePanel.setRibl();    }
        }
        else if(win.equals("ribl") )
        {
            if(!filePanel.isPsParamsSet() )
                filePanel.setPsParams(psitePanel.getPsParamsText());
            else
                filePanel.setPsParams();
            nextJB.setText("Submit");
        }
        else if(win.equals("psparams") )
        {
            //send the files to the server
            sendfiles(3);
        }
    }//doFileDisplay()
    
    
    protected void sendfiles(int prog)
    {
        String errString="";
        String errTitle="";
        String matrixType = mainPanel.getMatrixType().trim().toLowerCase();        
        boolean flag=false;
        int ret = 200;  //default return value
        
        this.nextJB.setEnabled(false);
        switch (prog)
        {
            case 1: {   errTitle="Scan process submission status:"; break;  }
            case 2: {   errTitle="Promotsite process submission status:"; break;  }
            case 3: {   errTitle="Scan+Promotsite process submission status:"; break;  }
            default: { }
        }
        
        if( prog != 2)  // no need to send scanp,ribl if running promotsite
        {
            //send scanp
            sock.resetItems();
            sock.addParam("filename","scanp");
            sock.addParam("dirname",mainPanel.getDestDirectory());
            ret = sock.sendText("savefile",filePanel.getScanp());
            if(ret<0 || ret > 299) 
            {   flag = true;
                errString+="scanp:"+sock.getErrString()+"\n";    }
            System.out.println("Scanp Sent");

            //send ribl
            sock.resetItems();
            if(matrixType.equals("ribl") )            
                sock.addParam("filename","ribl");                
            else if(matrixType.equals("user") )
                sock.addParam("filename","wmatrix");                
            sock.addParam("dirname",mainPanel.getDestDirectory());
            ret = sock.sendText("savefile",filePanel.getRibl());
                
            if(ret<0 || ret > 299) 
            {   flag=true;
                errString+="Weight Matrix:"+sock.getErrString()+"\n"; }
            System.out.println("Weight matrix Sent");
        }//prog!=promotsite
        
        if( prog != 1)  //send psparams for promotsite
        {
            //send psparams
            sock.resetItems();
            sock.addParam("filename","psparams");
            sock.addParam("dirname",mainPanel.getDestDirectory());
            ret = sock.sendText("savefile",filePanel.getPsParams());
            if(ret<0 || ret > 299) 
            {   flag=true;
                errString+="PSParams:"+sock.getErrString()+"\n"; }
            System.out.println("psparams Sent");
        }
        
        if(flag)
        {   
            showError(errString,"Error in uploading files to the server" ); 
            this.nextJB.setEnabled(true);
            return;
        }        
        
        //send the request for starting the scan process at the server
        sock.resetItems();
        sock.addParam("runprogram",String.valueOf(prog) );  //runprogram option 
        sock.addParam("dirname",mainPanel.getDestDirectory());
        sock.addParam("chrmst", mainPanel.getScanRange1() );
        sock.addParam("chrmend", mainPanel.getScanRange2() );        
        sock.addParam("email",mainPanel.getEmailAddr() );
        sock.addParam("mrnaversion",mainPanel.getMrnaVersion() );
        if(matrixType.equals("user") )
            sock.addParam("matrixType","user" );
        else
            sock.addParam("matrixType","ribl" );
        ret = sock.sendText("runscan","");
        if(ret<0 || ret > 299) 
        {   
            errString+=sock.getErrString()+"\n";
            showError(errString,errTitle+"Error" );    
            this.nextJB.setEnabled(true);
        }
        else
        {   
            this.nextJB.setEnabled(false);
            errString = sock.getErrString();            
            javax.swing.JOptionPane.showMessageDialog(this, errString, errTitle+"Success", javax.swing.JOptionPane.INFORMATION_MESSAGE);
        }        
            
    }//sendfiles()
        
    //check whether a file exists or not    
    public boolean fileExists(String file)
    {     
        try{    return new java.io.File(file).exists(); }
        catch(Exception e)  {   return false;   }
    }
    
    protected void showError(String errString, String errTitle)
    {
        if(errString!= null)
        {
            javax.swing.JOptionPane.showMessageDialog(this, errString, errTitle, javax.swing.JOptionPane.ERROR_MESSAGE);
        }
    }//showError()
    
    /** Exit the Application */    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        //new ScanFront().show();
    }    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton nextJB;
    private javax.swing.JPanel bottomJP;
    private javax.swing.JButton resetJB;
    private javax.swing.JLabel titleJL;
    private javax.swing.JPanel titleJP;
    private javax.swing.JButton backJB;
    private javax.swing.JScrollPane midJSP;
    private javax.swing.JLabel mesgJL;
    // End of variables declaration//GEN-END:variables
    
}
