/*
 * wMatrixPanel.java
 *
 * Created on August 6, 2003, 11:23 AM
 */

/**
 *
 * @author  sashidhar gadiraju
*/

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class WMatrixPanel extends javax.swing.JPanel {
    java.awt.Component parent;    
    javax.swing.JTextField acgt[][]; 
    int length=0;
    int nSeq=0;
    boolean freqEntered = false;    // indicates if the frequency tables have been filled or not
    
    public void resetItems()
    {
        length = 0;
        nSeq=0;
        nSeqJTF.setText("");
        freqEntered = false;
        acgt = null;
        matrixJSP.setMinimumSize(new java.awt.Dimension(25, 25));
        matrixJSP.setPreferredSize(new java.awt.Dimension(150, 150));
        matrixJSP.setViewportView(null);
    }
    
    /** Creates new form wMatrixPanel */
    public WMatrixPanel(java.awt.Component parent ) {
        this.parent = parent;
        initComponents();
        resetItems();
        setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        matrixJSP = new javax.swing.JScrollPane();
        acgtJP = new javax.swing.JPanel();
        titleJL = new javax.swing.JLabel();
        lengthJL = new javax.swing.JLabel();
        lengthJTF = new javax.swing.JTextField();
        nSeqJL = new javax.swing.JLabel();
        nSeqJTF = new javax.swing.JTextField();
        goJB = new javax.swing.JButton();
        riblTitleJL = new javax.swing.JLabel();
        riblTitleJTF = new javax.swing.JTextField();
        helpJB = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        matrixJSP.setMinimumSize(new java.awt.Dimension(25, 25));
        matrixJSP.setPreferredSize(new java.awt.Dimension(100, 100));
        acgtJP.setLayout(new java.awt.GridLayout(0, 5, 2, 2));

        acgtJP.setPreferredSize(new java.awt.Dimension(100, 50));
        matrixJSP.setViewportView(acgtJP);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(matrixJSP, gridBagConstraints);

        titleJL.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        titleJL.setText("Generic Weight Matrix Parameters");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 20, 0);
        add(titleJL, gridBagConstraints);

        lengthJL.setText("Length of the site");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(lengthJL, gridBagConstraints);

        lengthJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(lengthJTF, gridBagConstraints);

        nSeqJL.setFont(new java.awt.Font("Dialog", 0, 12));
        nSeqJL.setText("Number of Sequences");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(nSeqJL, gridBagConstraints);

        nSeqJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(nSeqJTF, gridBagConstraints);

        goJB.setText("Fill the positional frequencies(as integers) of bases");
        goJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(goJB, gridBagConstraints);

        riblTitleJL.setText("Site Title");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(riblTitleJL, gridBagConstraints);

        riblTitleJTF.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 5, 3, 5);
        add(riblTitleJTF, gridBagConstraints);

        helpJB.setText("Help");
        helpJB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpJBActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        add(helpJB, gridBagConstraints);

    }//GEN-END:initComponents

    private void helpJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpJBActionPerformed
        // Add your handling code here:
        String mesg = "";        
        mesg += "Title: Title of the weight matrix generated\n\n";
        mesg += "Length of the Site: Number of positions in the site\n\n";
        mesg += "Number of sequences simulated:\n";   
        mesg += "Using the frequencies of bases at each position of a site,\n"; 
        mesg += "a random number generator is used to make up sequences.\n";
        mesg += "Using these sequences, a pseudo information weight matrix is\n"; 
        mesg += "created for performing the scans.\n";
        mesg += "This parameter defines the number of such sequences generated.\n";
        mesg += "   default: If the parameter is left empty, it takes the default\n";
        mesg += "   value of the minimum of the summed up frquencies for a,c,g,t \n";
        mesg += "   overall all the positions\n\n";
        mesg += "Frequencies: These indicate the number of occurences of a,c,g,t \n";
        mesg += "at each position in the site from a given set of sequences\n";
        mesg += "which define that site\n\n";
        mesg += "NOTE: The matrix region in the generated information matrix is \n";
        mesg += "defined from 0 to (length of the site -1). So, set the from,to \n";
        mesg += "parameters accordingly in the corresponding scanp file\n";
        javax.swing.JOptionPane.showMessageDialog(this.parent, mesg, "Help", javax.swing.JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_helpJBActionPerformed

    private void goJBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_goJBActionPerformed
        // Add your handling code here:
        
        if(! MyUtils.isInteger(lengthJTF.getText(), 1, Integer.MAX_VALUE ) )
        {
            showError("Length parameter is not a positive integer", "ERROR");
            return;
        }
        else
            length = Integer.parseInt((lengthJTF.getText()));
        System.out.println("length=" + length);
        if( nSeqJTF.getText().trim().equals("") ) {}    // do nothing
        else if(!MyUtils.isInteger(nSeqJTF.getText(), 1, Integer.MAX_VALUE ) )
        {
            showError("Number of sequences is not a positive integer", "ERROR");
            return;
        }
        else
            nSeq = Integer.parseInt((nSeqJTF.getText()));        
        setMatrix(length);
        freqEntered = true;
        
    }//GEN-LAST:event_goJBActionPerformed

    // check to see if all the entered values are correct and valid
    public String parseMatrix()
    {        
        String errStr = "";
        if(! MyUtils.isInteger(lengthJTF.getText(), 1, Integer.MAX_VALUE ) )
        {   errStr="Length parameter is not a positive integer";return errStr; }        
        else
        {
            int len = Integer.parseInt(lengthJTF.getText() );
            if (len != length)
            {   
                errStr = "Length does not match with the number of freq. rows. Fill values again";
                return errStr;
            }
        }
        
        if( nSeqJTF.getText().trim().equals("") ) {}    // do nothing
        else if(!MyUtils.isInteger(nSeqJTF.getText(), 1, Integer.MAX_VALUE ) )
        {   errStr="Number of sequences parameter is not a positive integer";return errStr; }
        
        
        if(! freqEntered )
        {
            errStr = "Frequency values not entered";
            return errStr;
        }        
        
        String ncl[] = { "a","c","g","t" };
        for(int i=0;i <length; ++i)
            for(int j=0;j <4; ++j)
                if(! MyUtils.isInteger(acgt[i][j].getText(),0,Integer.MAX_VALUE ))
                {   
                    errStr="The frequency value at position "+i+","+ncl[j]+" is not a positive integer";
                    return errStr;
                }
        return "";
    }
    
    //get the text of the values in this form as text
    //this function should be called after checking with parseMatrix
    public String getMatrixText()
    {
        StringBuffer str = new StringBuffer("");
        str.append(riblTitleJTF.getText() + "\n" );
        str.append(Integer.toString(length) + "\n" );
        String nSeqStr = nSeqJTF.getText().trim();
        if(! nSeqStr.equals(""))
        {   str.append(nSeqJTF.getText() + "\n" ); }
        else
        {
            int minfreq=Integer.MAX_VALUE;
            for(int i=0;i <length; ++i)
            {
                int tmp=0;
                String ncl[] = { "a","c","g","t" };
                for(int j=0;j <4; ++j)            
                {
                    try{
                        tmp += Integer.parseInt( acgt[i][j].getText() );
                    }catch(NumberFormatException e)
                    {   showError("Frequency not an integer at position "+i+","+ncl[j]+",","parseError");   
                        return str.toString();
                    }                    
                }
                if(tmp<minfreq) minfreq = tmp;
            }            
            str.append( Integer.toString(minfreq) + "\n");    //the new nSeq value
        }
        
        for(int i=0;i <length; ++i)
        {
            for(int j=0;j <4; ++j)            
                str.append(acgt[i][j].getText() + " ");
            str.append("\n");
        }
        return str.toString();
    }
        
    //Set the matrix panel with the required number of rows, cols for filling the
    //a,c,g,t frequencies
    public void setMatrix(int len)
    {        
        if(acgtJP != null)
            acgtJP.removeAll();
        acgt=null;  acgtJP=null;
        acgtJP = new javax.swing.JPanel();
        acgtJP.setLayout(new java.awt.GridLayout(0, 5, 2, 2));                
        System.out.println("In setMatrix " + "len");
        javax.swing.JLabel header[] = new javax.swing.JLabel[5];
        for(int i=0;i<5; ++i )
        {
            header[i] = new javax.swing.JLabel();
            header[i].setMinimumSize(new java.awt.Dimension(20,10) );         
            header[i].setPreferredSize(new java.awt.Dimension(20,10) );
            header[i].setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
            header[i].setEnabled(true);
            header[i].setVisible(true);                
            acgtJP.add(header[i]);
        }
        header[0].setText("Position");
        header[1].setText("A");
        header[2].setText("C");
        header[3].setText("G");
        header[4].setText("T");
        
        acgt = new javax.swing.JTextField[len][4];
        for(int i=0; i<len; ++i )
            for(int j=0; j<4; ++j )
            {        
                acgt[i][j] = new javax.swing.JTextField(10);
                acgt[i][j].setMinimumSize(new java.awt.Dimension(20,10) );
                acgt[i][j].setPreferredSize(new java.awt.Dimension(20,10) );
                acgt[i][j].setEnabled(true);
                acgt[i][j].setVisible(true);                
            }
            
        for(int i=0;i < len; ++i)
        {               
            javax.swing.JLabel tmpJL = new javax.swing.JLabel( Integer.toString(i) );
            tmpJL.setMinimumSize(new java.awt.Dimension(20,10) );
            tmpJL.setPreferredSize(new java.awt.Dimension(20,10) );
            acgtJP.add( tmpJL);    // position
            for(int j=0; j<4; ++j )
                acgtJP.add( acgt[i][j] );
        }
        acgtJP.setEnabled(true);
        acgtJP.setVisible(true);
        //acgtJP.setMaximumSize(new java.awt.Dimension(100,250) );
        acgtJP.setPreferredSize(new java.awt.Dimension(150, (25 * len)));                
        matrixJSP.setViewportView(acgtJP);        
        if(30*len < 350)
            matrixJSP.setPreferredSize(new java.awt.Dimension(150,(30 * len)) );
        else
            matrixJSP.setPreferredSize(new java.awt.Dimension(150,300 ));
        matrixJSP.setMaximumSize(new java.awt.Dimension(150,300) );
        matrixJSP.repaint();
        acgtJP.repaint();

    }//setMatrix()
    
    protected void showError(String errString, String errTitle)
    {
        if(errString!= null)
        {
            javax.swing.JOptionPane.showMessageDialog(this.parent, errString, errTitle, javax.swing.JOptionPane.ERROR_MESSAGE);
        }
    }//showError()
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton goJB;
    private javax.swing.JTextField riblTitleJTF;
    private javax.swing.JLabel lengthJL;
    private javax.swing.JLabel nSeqJL;
    private javax.swing.JLabel titleJL;
    private javax.swing.JTextField nSeqJTF;
    private javax.swing.JButton helpJB;
    private javax.swing.JPanel acgtJP;
    private javax.swing.JScrollPane matrixJSP;
    private javax.swing.JLabel riblTitleJL;
    private javax.swing.JTextField lengthJTF;
    // End of variables declaration//GEN-END:variables
    
    public static void main(String args[])
    {
        javax.swing.JFrame jf = new javax.swing.JFrame("Test");        
        WMatrixPanel wm = new WMatrixPanel(jf);        
        wm.setEnabled(true);
        jf.getContentPane().add( wm);
        jf.pack();                     
        jf.show();
        
    }
}
