#!/usr/bin/perl

# Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# Program : joborder
# version : 0.1
# Description : This program assigns nodes to various jobs depending on
# their sizes, so that the overall execution time is minimized. This program
# is used in the load-balancing feature of Delila-Genome.
# This program takes as it input a file containing 2 columns,
# the jobnumber and the jobsize. The output is a file containing 2 columns,
# the jobnumber and the node number
#
use strict;

my $nodes=3;	# number of nodes
my @proc=();	# each element represents a node, and contains a job size
my @jobnum=();	# job number
my @jobsize=();	# job size
my @jobnode=();	# the node assigned to this job
my $ifile="";	# assuming the file is ordered descendingly on the job size
my $ofile="jobs.out";	# output file with jobnum and nodenum


if( @ARGV  < 2) 
{	usage("Insufficient number of arguments") and exit;	}
($nodes,$ifile) = @ARGV;	# number of nodes, input file
usage("ERROR: num_of_nodes should be greater than zero\n") and exit if($nodes <= 0);
open (IF,"$ifile") || die "Cannot open $ifile\n";

my $cnt=0;
while( my $line=<IF> )
{
	$line = trim($line);
	next if( "$line" eq "" );	# discard empty lines
	($jobnum[$cnt],$jobsize[$cnt]) = split( /\s+/, $line);
	$cnt++;
}
close IF;

# print "Number of jobs = $cnt\n;
print "No jobs listed in the file $ifile\n" and exit if($cnt == 0);	# no jobs to process, maybe an empty file

# first fill up all the available nodes
my $curjob=0;	# the current job in progress is $jobnum[$curjob];
for(my $i = 0; $i<$nodes; ++$i)
{
	$proc[$i]=$jobsize[$curjob];
	$jobnode[$curjob++]=$i;	# assign the current proc to the current job
	last if($curjob == @jobnum);	# number of jobs < number of nodes
}

while ($curjob< @jobnum)
{
	my ($minproc,$minjsize) = findmin(@proc);
	foreach(@proc)
	{	$_ -= $minjsize;	print "Error: Proc job size < 0\n" if($_<0);	}
	$jobnode[$curjob] = $minproc;

	$proc[$minproc] = $jobsize[$curjob++];
}
		
open (OF,">$ofile") || die "Cannot open $ofile\n";
for(my $i = 0; $i<@jobnum ; ++$i)
{	print OF "$jobnum[$i] $jobnode[$i]\n";	}
#*************** END OF MAIN *******************#
sub findmin
{
	my( @procs) = @_;
	my $minp=0; 
	for(my $i=1; $i<@procs; ++$i)
	{	$minp=$i if( $procs[$i] < $procs[$minp] );	}
	return ($minp, $procs[$minp]);
}# sub findmin()

sub trim
{
	my $ipline = shift;
	$ipline =~ s/^\s+//;
	$ipline =~ s/\s+$//;
	$ipline;
}

sub usage
{	
	print "$_[0]\n" if( $_[0] );
	print "usage: $0 num_of_nodes input_file\n";
	print "\toutput file: jobs.out\n";
}
