
# Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#


package DGTools;

use vars qw($DR $DRS);
use Exporter;
@ISA = ('Exporter');
@EXPORT = qw(closef hasUndef isInt isPosInt isNegInt trim getdate $DR $DRS 
			isReal isPosReal isNegReal printDummyInstLine printDummyInstHeader 
			prgname touch dtouch parseRibl
			);
@EXPORT_OK = qw(closef hasUndef isInt isPosInt isNegInt trim getdate $DR $DRS
			isReal isPosReal isNegReal printDummyInstLine printDummyInstHeader 
			prgname touch dtouch parseRibl
			);

use strict;
# The tools needed in the delila-genome package
#
# the below two error vars should be in the delgen package
$DR=0;		# The Del-Gen error number, if any
$DRS="";	# The Del-Gen error string, if any

# close file handle references if defined 
sub closef
{
	foreach( @_ )
	{	close $_ if( defined $_ );	}
}

# check whether all elements in an array are defined
sub hasUndef
{
	foreach( @_ )	{	return 1 if( ! defined $_ ); 	}
	return 0;
}# hasAllDef()


sub isInt
{  return ($_[0] =~ /^\s*[\+-]?\d+\s*$/)?1:0;   }
 
sub isPosInt
{  return ($_[0] =~ /^\s*[\+]?\d+\s*$/)?1:0; }
 
sub isNegInt
{  return ($_[0] =~ /^\s*[-]?\d+\s*$/)?1:0;  }
 
sub isReal
{	return ($_[0] =~ /^\s*[\+-]?\d+[.]?\d*$/)?1:0;	}

sub isPosReal
{	return ($_[0] =~ /^\s*[\+]?\d+[.]?\d*$/)?1:0;	}

sub isNegReal
{	return ($_[0] =~ /^\s*[-]?\d+[.]?\d*$/)?1:0;	}

#remove leading and trailing ws from a line
sub trim
{
	return ( wantarray ? () : undef ) if( ! defined @_ );
	my @retarr=();
	foreach my $str (@_)
	{
		$str =~ s/^\s+//;   #remove leading whitespaces
		$str =~ s/\s+$//;   #remove trailing whitespaces
		push(@retarr, $str);
	}
	return wantarray ? @retarr : $retarr[0] ;
}	

sub getdate
{	return scalar localtime;	}

sub printDummyInstHeader
{
	my( $title, $OINST ) = @_;
	chomp $title;
	print $OINST "title \"$title\";\n";
	print $OINST "organism ORG; chromosome CHR;\n";
}# printDummyInstHeader

sub printDummyInstLine
{
	my( $piece, $name, $coord, $dir, $OFILE ) = @_;
	chomp $piece, $name, $coord, $dir;
	my $str = "";
	$str = "piece $piece; " if( "$piece" ne "" ) ;
	$str .= "name \"$name\"; " if( "$name" ne "" );
	if ("$dir" eq "+")
	{	$str .= "get from $coord -FROM to same +TO direction +; " ;	}
	elsif ("$dir" eq "-")
	{	$str .= "get from $coord +FROM to same -TO direction -; ";	} 
	else
	{	warn("WARNING: direction \'$dir\' not +/- for piece $piece, $name, $coord");	}
	print $OFILE "$str\n";
}# printDummyInstLine

# if program name is ../sa/././sd/ss return ss
sub prgname
{	return ($_[0] =~ /[\\\/]([^\\\/]+)$/)? $1 : $_[0]; }

# create empty file if not present
sub touch
{
	my @files = @_;
	foreach(@files)
	{	
		if(! -f "$_")
		{	open(F,">$_") || die "Cannot 'touch' file $_"; close F;	}
	}
}# touch()

# delete file and touch
sub dtouch
{
	my($file) = @_;
	unlink($file) if( -f "$file"); touch($file);
}# dtouch


# parseRibl
sub parseRibl
{
	$DR=0; $DRS="";
	my %hribl = ();
	open(R,"ribl") || die "ERROR: Cannot open file 'ribl'";	
	my @tmp = <R>;	close R; my @ribl=();
	map { push(@ribl,$_) if(! /^\s*\*/) } @tmp;
	#print "ribl=@ribl\n";
	$hribl{'title'}="";	# ribl title
	if( $ribl[0] =~ /\s*ribl\s+\"(.*)\"/i )
	{	$hribl{'title'} = $1;	}
	else
	{	$DR=1;	$DRS="ERROR: first line of ribl did not start with 'ribl'";	return %hribl;	}
	print "ribl2 = $ribl[2]\n";
	($hribl{'from'},$hribl{'to'}) = @{ [split(/\s+/,trim($ribl[1]) )] }[0,1];
	my $cnt=2;	my @matrix=();
	my $nrows = ($hribl{'to'} - $hribl{'from'} + 1) + 2;	#length of the site + 2(1st 2 rows)
	if( $nrows > @ribl)
	{	$DR=1;	$DRS="ERROR: Number of matrix rows < to-from+1";	return %hribl;	}
	@matrix = @ribl[2..($nrows-1)];	# array slice
	$cnt = $nrows;
	$hribl{'matrix'} = \@matrix;
	$hribl{'RiMean'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;
	$hribl{'RiSD'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;
	$hribl{'RiCon'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;
	$hribl{'RiAntiCon'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;
	$hribl{'RiAvg'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;
	#$hribl{'infVal'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;	
	# found the infVal in the documentation of Ri but not in the generated
	# ribl files.
	$hribl{'numofseq'} = [split(/\s+/,trim($ribl[$cnt++]) )]->[0] ;
	$hribl{'symmetry'} = [split(//,$ribl[$cnt++])]->[0] ;	# get just the first char
	my $wavest = $cnt; my $waveend = @ribl-2;
	my @wave=();
	while( ($cnt< @ribl) && (! $ribl[$cnt] =~ /\./) ) 
	{	push(@wave, $ribl[$cnt]); $cnt++;	}
	$hribl{'wave'} = \@wave;
	return %hribl;
}
	
		
		
		
		




1;	# This 1 is used so that if this package is imported, then the
# compilation will return a true value. This is because this whole package
# is in the BEGIN block the return value of which is the return value of the
# last statement in this package.

