import java.io.*;
import java.net.*;
/**
 *
 * @author  sashidhar gadiraju
 */

/*
Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
This file is part of DelgenFront.
DelgenFront is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

DelgenFront is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with DelgenFront; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


public class SendText
{	
        String params="";
	String entity="";
	byte content[];
        int content_length=0;
        File entityf;        
	int port = 9876;
	String serverURL = "";
	
        BufferedInputStream ips;
	PrintStream psout;
        HttpURLConnection hconn;
        URL url;
        String errString = "";
	int errCode= 200;        
        
	public SendText(String server)
	{   this.serverURL = server;    resetItems();	}

	public SendText(String server, int port) 
	{
            this.serverURL = server;
            this.port = port;       
            resetItems();
	}
        
        public void resetItems()
        {            
            content_length=0;
            content=null;
            entity = "";
            params="";
            errString = "";
            errCode=200;
            entityf = null;
        }
        
        protected void connect(String cname, String method) throws Exception
        {
            String gen_url = "http://"+serverURL+":"+port+"/"+cname+"?"+params;
            System.out.println("URL generated: "+gen_url);
            url = new URL(gen_url);           

            hconn = (HttpURLConnection)url.openConnection();               
            hconn.setRequestMethod(method);
            hconn.setRequestProperty("Connection","close");
            hconn.setDoOutput(true);
            hconn.setDoInput(true);
            hconn.connect();
            psout = new PrintStream(	hconn.getOutputStream() );
        }
        
        protected void connect(String cname) throws Exception   {   connect("GET",cname); }
        
        protected int close() 
	{
            int ret = 1;
            try{
                if(psout!=null)
                    psout.close();
                //hconn.disconnect();
            }
            catch(Exception e){ ret = -1; System.out.println("Error in closing the connection");    }
            return ret;
	}

	protected void addParam(String name, String value)
        {
            if(name == null) 
                return;
            if(value == null)   value ="";                            
            {   params+=name.trim()+"="+value.trim()+"&";   }
        }
                
        protected void addHeader(String name, String value) 
	{
            if(name == null) 
                return;
            if(value != null) value ="";                
            
	}                    
        
        public int getErrCode(){    return errCode; }
        
        public String getErrString(){   return errString;   }
        
        public byte[] getContent(){ return content; }
        
        public int getContentLength(){  return content_length;  }


	public int sendText(String cname, String inf)
	{
            //resetItems();
            int ret = 1;

            if(inf ==null)
                    ret = -1;	//error
            else
            {
                
                try{    connect(cname,"POST");  }
                catch(Exception e)
                { 
                    errString = "Error in connecting to "+serverURL;  
                    System.out.println("Error in connect()");
                    close();  
                    return -1;  }
                
                this.entity = inf;                
                //addHeader("content-length",String.valueOf(inf.length()) );                
                ret = send();
                if(ret<0)
                    errString = "Error in Sending File "+entityf.getName();  
                else
                {
                    try{
                    psout.close();
                    ret = errCode = hconn.getResponseCode();
                    errString = hconn.getResponseMessage();
                    
                    //now get the input
                    if(hconn.getContentLength()>0)
                    {
                        content_length = hconn.getContentLength();
                        content = read2array(hconn.getInputStream() );
                        /*
                        ips = new BufferedInputStream(hconn.getInputStream() );
                        content = new byte[content_length];
                        int nread = ips.read(content,0,content.length);
                         */
                        if(content.length < content_length)
                        {   
                            System.out.println("Full contents could not be read from server");
                            System.out.println("length:"+content_length+" read:"+content.length);
                        }
                    }
                    }catch(Exception e){  errString = "Error in connecting to server";    ret = -1;   }
                }
                
            }
            close(); 
            return ret;
	}//sendText()
        
	protected int send()
	{
            psout.print(entity);
            psout.flush();
            return 1;
	}

                
        public int sendFile(String cname, File inf)
	{
            //resetItems();
            int ret = 1;

            if(inf ==null)
                    ret = -1;	//error
            else
            {
                try{    connect(cname,"POST");  }
                catch(Exception e)
                { 
                    errString = "Error in connecting to "+serverURL;  
                    System.out.println("Error in connect()");
                    close();  
                    return -1;  }
                
                this.entityf = inf;                
                //addHeader("content-length",String.valueOf(inf.length()) );                
                ret = sendf();                
                if(ret<0)
                    errString = "Error in Sending File "+entityf.getName();  
                else
                {
                    try{
                    psout.close();
                    ret = errCode = hconn.getResponseCode();
                    errString = hconn.getResponseMessage();
                    
                    //now get the input
                    if(hconn.getContentLength()>0)
                    {
                        content_length = hconn.getContentLength();
                        content = read2array(hconn.getInputStream() );
                        /*
                        ips = new BufferedInputStream(hconn.getInputStream() );
                        content = new byte[content_length];
                        int nread = ips.read(content,0,content.length);
                         */
                        if(content.length < content_length)
                        {   
                            System.out.println("Full contents could not be read from server");
                            System.out.println("length:"+content_length+" read:"+content.length);
                        }
                    }
                    }catch(Exception e){  errString = "Error in connecting to server";    ret = -1;   }
                }
            }
            close(); 
            return ret;
	}
            
	protected int sendf()
	{
            int ret = 1;	
            try{
                FileInputStream in = new FileInputStream(entityf);
                int len = (int)entityf.length();
                byte buffer[] = new byte[len];
                in.read(buffer, 0, len);
                in.close();
                psout.write(buffer, 0, len);
                psout.flush();
            }
            catch(Exception e)
            {
                ret = -1;
                System.out.println("Error in sending the file\n"+e.toString());
            }
            return ret;
	}	
        
    public byte[] read2array(java.io.InputStream inf) throws Exception 
    {        
        byte[] out  = new byte[0];
        try{
            ips = new BufferedInputStream(inf);
            // the length of a buffer can vary
            int bufLen = 20000*1024;
            byte[] buf = new byte[bufLen];
            byte[] tmp = null;
            int len    = 0;
            while((len = ips.read(buf,0,bufLen)) != -1)
            {
                // extend array
                tmp = new byte[out.length + len];
                // copy data
                System.arraycopy(out,0,tmp,0,out.length);
                System.arraycopy(buf,0,tmp,out.length,len);
                out = tmp;
                tmp = null;          
            }
        }//try
        finally{
            // always close the stream
            if (ips != null) try{ ips.close();}catch (Exception e){}
        }
        return out;
    }
        
    public static void main(String args[])
    {
        SendText cl = new SendText("http://localhost", 7070);
        //cl.sendText("Testing Sequence\nHello Restricted World","testtitle");
        cl.addParam("filename","sendtext");
        cl.addParam("dirname","timepass");
        File f = new File("c:\\temp\\WS_FTP.log");
        try{new FileInputStream(f);}catch(Exception e){System.out.println(f.getPath()+":"+e.toString());}
        int ret = cl.sendFile("savefile",f);                
        if(ret <0 )
            System.out.println("Error in connection\n");
        else
            System.out.println("Connection Successful::SendFile\n"+"ErrCode:"+cl.getErrCode());            

        cl.resetItems();

        cl.addParam("filename","self");
        cl.addParam("dirname","timepass");
        ret = cl.sendText("savefiless","Testing Sequence");                
        if(ret <0 )
            System.out.println("Error in connection\n");
        else
            System.out.println("Connection Successful::SendText\n"+"ErrCode:"+cl.getErrCode());
            /*
        ret = cl.sendRequest("startScan");                
        if(ret <0 )
            System.out.println("Error in connection\n");
        else
            System.out.println("Connection Successful::SendRequest\n");
         */

    }
		
}

		

