#!/usr/bin/perl 
#
# Copyright 2003 Sashidhar Gadiraju, Peter K. Rogan
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#
#Program : server.pl
#Version : 1.3
#Author : Sashidhar Gadiraju
#This script simulates a webserver minimally. It accepts incoming http connections
#and can be used to store or get files from the $base_dir directory. 
#It can also run programs residing in the same directory or its sub directories.

#1.3 : reading mrnaversion from the url in the params string
#1.2 : Checking appropriate params(scanp, psparams, ribl ) for corresponding runopt
#1.1 : Adding the capability to give the chromosome range to runscan. 
#This new call to runscan will be compatible with runscanV1.5

use HTTP::Headers;
use HTTP::Daemon;
use URI::Escape;
use URI::URL;
use Mail::Mailer;
use POSIX;

# Global variables
my $Port = 7070;	#the TCP port which this server listens on 
my $base_dir = "$ENV{'DELGEN_RESULTS'}";	#the base output/results directory
my $serverlog = "${base_dir}/server.log";	#the server log file
#the fake email address of this server, which appears as 'from' id in the email to the user
my $base_email = "ScanProcess\@delilagenome.edu";	

#my $mrna_basedir = "";
if( ! $base_dir )
{	die "Envirorment variable DELGEN_RESULTS not set";	}

#dissociate from the controlling terminal 
if(my $spid = fork)
{ exit; } 
elsif(defined $spid)
{	print "server disassociated from the parent\n";	}
else
{	die " cannot fork ";	}
#exit if in the main process
exit if $spid; 
POSIX::setsid || warn "Cannot start a new session through setsid";

#stop child processes from becoming zombies
$SIG{CHLD} = 'IGNORE';
#make server survive logouts and other normal termination cases
$SIG{HUP} = $SIG{INT} = $SIG{TERM} = 'IGNORE';
#create the server
my $server = HTTP::Daemon->new( LocalPort => $Port,Reuse => 1) || 
die "Cannot create server : $@ \n";
#defined($server) || die "Server Could not be created";
print "Server created on local port " . $Port . "\n";

# creating an empty log file
open(LOG, ">$serverlog") || warn "WARNING: cannot open server log file at $serverlog";
close LOG;

#open the server log file
open(STDOUT, ">>${base_dir}/server.log");
open(STDERR, ">>${base_dir}/server.log");

#wait for the client connections
my $client;
while($client=$server->accept)
{
	print  "##########CONNECTED TO A CLIENT\n";
	
	while(my $answer = $client->get_request) {
		
		#print $answer->as_string . "\n";
		#print "URL::" . $answer->url . "\n";
		#print "sizeof url::" , length($answer->url ) , "\n";
		#print "URL::content_length" . $answer->headers->content_length(100) . "\n";
		#print "body::" . $answer->content . "\n";

		client_handler($answer, $client);
		$client->autoflush;
		#$client->send_file("serv.plsd");
		#print $client;		
	}
	#print "CLOSE:", $client->reason,"\n";
	$client->close;
	undef $client;
}
print  "Closing the server\n";

sub client_handler()
{
	my ($ans, $client) = ($_[0], $_[1]);
	print "in client_handler\n";
	print $ans->url."\n";
	my $url = new URI::URL( uri_unescape( $ans->url)  );
	my $prog_name = parse_url($url->epath);
	$prog_name = trim($prog_name);
	#print "program name = $prog_name\n";
	if($prog_name eq "getfile")
	{	getfile($url->query, $client);	}
	elsif($prog_name eq "savefile")
	{	
		if( ! defined($ans->content) )
		{	&senderr(400, "No file to save",$client);	}
		else
		{	savefile($url->query, $ans->content, $client);	}		
	}	
	elsif($prog_name eq "runscan")
	{	runscan($url->query, $client);	}	
	elsif($prog_name eq "getnewdir")
	{	getnewdir($url->query, $client);	}	
	elsif($prog_name eq "checknewdir")
	{	checknewdir($url->query, $client);	}	
	else
	{	&senderr(404,"Target script not found",$client);	}
	$client->autoflush;
	#$client->close;	
}
	
sub parse_query()
{
	my $qstr = shift;
	my %params;
	foreach ( split( /&/, $qstr))
	{
		/(.*)=(.*)/;
		$params{$1}=$2;
	}
	%params;	#return the params 
}
	
sub parse_url()
{
	my $url = $_[0];
	my $name="";
	if($url =~ /\/(\S*)$/)
	{	$name=$1;	}
	$name;
}

sub savefile()
{
	my ($pstr,$file,$client) = @_;
	my %par = &parse_query($pstr);
	my $fname,$dname;
	unless (chdir "$base_dir")
	{	&senderr(404,"Delila directory not found", $client);	return;	} 
	if(!	exists($par{filename})	)
	{	&senderr(404,"No file given to save", $client);	return;	}
	$fname = $par{filename};
	if(    (!exists($par{dirname})) || $par{dirname} eq "")
	{	&senderr(404, "Directory name not given", $client);	return;	}
	else
	{
		$dname = "${base_dir}/$par{dirname}";
		if(-f $dname)
		{	&senderr(404, "Invalid directory $par{dirname}", $client);	return;	}
		elsif(  ! -d $dname )
		{
			unless (mkdir ($dname, 0775) )
			{	&senderr(404, "cannot create dir $par{dirname}", $client);	return;	}
		}
	}
	#$dname = "${base_dir}/$par{dirname}";	
	unless (chdir "$dname")
	{	&senderr(404,"Directory $dname not found",$client);	return;	}
	unless (open(F, ">$fname"))
	{	&senderr(404, "cannot save file $fname",$client); return;	}
	print F "$file";
	close F;
	&senderr (200,"",$client);
}

sub senderr()
{
	my ($errcode, $errstr, $client ) = @_;
	print "ERROR MESG:$errstr\n";
	($errstr eq "")?($client->send_response($errcode))
	:($client->send_response($errcode,$errstr));
}
		
sub getfile()
{
	my ($pstr,$client) = @_;
	my %par = &parse_query($pstr);
	my $fname,$dname;
	$fname = $par{filename};
	if( (!exists($par{dirname})) || $par{dirname} eq "")
	{	$dname = "$base_dir";	}
	else
	{	$dname = "${base_dir}/$par{dirname}";	}
	$client->send_file_response("${base_dir}/${fname}") || warn "file ${base_dir}/${fname} not found";
}

sub runscan()
{
	my ($pstr,$client) = @_;
	my %par = &parse_query($pstr);
	my $fname,$dname;
	my ($chrmst, $chrmend) = (1,24);
	if( (!exists($par{dirname})) || $par{dirname} eq "")
	{	&senderr(400,"No directory name given", $client);	return;	}
	else
	{	$dname = "${base_dir}/$par{dirname}";	}
	if(! -d $dname)
	{	&senderr(400, "Directory $par{dirname} does not exist", $client);	return;	}
	
	#determine whether to run scan, promotsite or both. Default is both
	#Currently the front end supports only the "both" option
	my $runopt=3;	#3 indicates scan+promotsite
	if(exists($par{'runprogram'}) )
	{	$runopt = $par{'runprogram'};	}
	
	if( $runopt == 1 ){
		if( (! -f "${dname}/scanp") || (! -f "${dname}/ribl") )
		{	&senderr(404, "Missing parameter files", $client);	return;	}
	}
	if( $runopt == 2 ){
		if( (! -f "${dname}/ribl") || (! -f "${dname}/psparams") )
		{	&senderr(404, "Missing parameter files", $client);	return;	}
	}
	if( $runopt == 3 ){
		if( (! -f "${dname}/scanp") || (! -f "${dname}/ribl") || (! -f "${dname}/psparams") )
		{	&senderr(404, "Missing parameter files", $client);	return;	}
	}
	#unless( open(PSP, "<${dname}/psparams") )
	#{	&senderr(500, "Error in opening the parameter files", $client);	return;	}
	#determine the chromosomes range for scan and promotsite
	if( exists($par{'chrmst'}) )
	{	$chrmst = $par{'chrmst'};	}
	if( exists($par{'chrmend'}) )
	{	$chrmend = $par{'chrmend'};	}
	if($chrmst > $chrmend)
	{	
		&senderr(404, "Incorrect chrm scan range\nstart greater than end\n");
		return;
	}
	
	#my @pspar = <PSP>;
	#close PSP;
	#my %mrna_par = &mystrtok(" ", @pspar );
	my $gen_ver="oct00";
	if(my $pid = fork)
	{
		#parent here	my $sep = shift;
		&senderr(200, "Process initiated", $client);
		return;
	}
	elsif(defined $pid)	#child process
	{
		#if(! exists( $mrna_par{"mrnaversion"} ) )
		# 0.3 read the mrnaversion from the url instead of from the psparams file
		if(exists( $par{'mrnaversion'} ) )
		{	$gen_ver= $par{'mrnaversion'};	}
			print "mrnaversion = $gen_ver\n";
		
			my $usermsg = "scan start time:";
			$usermsg .= localtime;
			# start the scan process
			# below lines modified for runscan2.3
			my $scandir = "${base_dir}/$par{dirname}";
			my $runstr = "runscan -d $scandir ${gen_ver} $runopt $chrmst $chrmend ";
			my $res=system("$runstr 2>>${base_dir}/server.log");
			if($res)	# error in the execution
			{
				print "ERROR: in executing runscan : $!\n";
				print "\n###Mission not accomplised###\n";
				$usermsg .= "ERROR: in executing runscan : $!\n";
			}
			else
			{	print "\n###Mission accomplised###\n";	}
				


			#the user mail contents
			$usermsg .= "\nscan end time:";
			$usermsg .= localtime;
			$usermsg .= "\nScan Results Directory:";
			$usermsg .= "[$ENV{'HOSTNAME'}] \$ ${base_dir}/$par{dirname}\n";
			$usermsg .= "Chromosome range used for scan: $chrmst $chrmend\n";
			$usermsg .= "Genome Assembly version: $gen_ver\n";
			$usermsg .= "NOTE: In the results directory, the chrm_23 directory\n";
			$usermsg .= "represents chrX and chrm_24 represents chrY\n";
			
			if( exists($par{email}) )
			{
				my $mailid = trim( $par{email} );
				print "user email: $mailid\n";
				print "user body : $usermsg\n";
				if($mailid ne ""){&sendemail( "$base_email",$mailid, "runscan process", $usermsg );}
			}
				
		
		#
		#
		#end of child
		die "exiting the child process\n";
	}
	else	#cant fork
	{	&senderr(500, "Cannot start the scan program", $client);	return;	}

}
sub sendemail()
{
	my ($from, $to, $subj, $body) = @_;
	print "sending email to $to\n";
	print "email body: $body\n";
	eval{
	my $mailer = Mail::Mailer->new;
	$mailer->open({ From =>$from,
					To => $to,
					Subject =>	$subj,
				}) ;
	print $mailer $body;
	$mailer->close();
	};	
	#if an error occured
	if($@)
	{	print "Email could not be sent to $to : $!\n";	}
}	
	
sub mystrtok()
{
	my $sep = shift;
	my @qstr = @_;	#the rest of arguments
	my %params;
	foreach ( @qstr )
	{
		print $_ . "\n";
		$_=trim($_);
		/([^$sep]*)${sep}+(.*)/;
		$params{$1}=$2;
	}
	%params;	#return the params
}

sub checknewdir()
{
	my ($pstr,$client) = @_;
	my %par = &parse_query($pstr);
	my $dname;
	if(exists($par{dirname}) )
	{
		$dname = "${base_dir}/$par{dirname}";
		print "Directory for creation: $dname\n";
		if ( -d "$dname")
		{	$client->send_response(400,"Directory already present, choose a new name");	}
		else
		{	$client->send_response(200);	}
	}
	else
	{	$client->send_response(404,"No  directory to check");	}
}
sub getnewdir()
{
	my ($pstr,$client) = @_;
	my @ltime = localtime;
	my ($sec,$min,$hour,$day, $mon, $yr) = @ltime;
	$mon += 1;
	$yr += 1900;
	my $dname = "$mon$day$yr$hour$min";
	if(-f "${base_dir}/$dname}")
	{	&senderr(404, "Invalid directory name $dname ", $client);	return;	}
	if( -d "${base_dir}/${dname}")
	{		$dname = "$day$mon$yr$hour$min$sec";	}
	#unless (mkdir "${base_dir}/${dname}", 0775) 
	#	{	&senderr(404, "cannot create new directory ", $client);	return;	}
	&senderr (200,"$dname",$client);
}

sub trim()
{
	my $ipline = shift;
	$ipline =~ s/^\s+//;
	$ipline =~ s/\s+$//;
	$ipline;
}

#function to find whether a given argument is a digit or not
sub isadigit()
{	return ("$_[0]" =~ /^\s*[\+]?\d+\s*$/)?1:0;	}
