/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.ext.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.apptools.data.DataDescriptor;
import net.sf.apptools.data.IntegerDescriptor;
import net.sf.apptools.plugin.AbstractParameterPlugIn;
import net.sf.apptools.plugin.ParameterPlugIn;
import net.sf.apptools.textio.InputMapping;
import net.sf.apptools.textio.impl.ColumnIndexMapping;
import org.moltools.lib.seq.SequenceFormatException;
import org.moltools.lib.seq.io.SequenceDBDataReader;
import org.moltools.lib.seq.io.SequenceDataReader;
import org.moltools.lib.seq.io.impl.TextTableFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectColumnTextTableDBFormatPlugin
extends AbstractParameterPlugIn
implements ParameterPlugIn,
SequenceDBDataReader {
    public static final String KEY_ID_COL = "idColumn";
    public static final String KEY_SEQ_COL = "seqColumn";
    static final DataDescriptor idColDesc = new IntegerDescriptor("ID column", "Number of ID column", "idColumn", 1, Integer.MAX_VALUE);
    static final DataDescriptor seqColDesc = new IntegerDescriptor("Sequence column", "Number of sequence column", "seqColumn", 1, Integer.MAX_VALUE);

    public SelectColumnTextTableDBFormatPlugin() {
        super(new DataDescriptor[]{idColDesc, seqColDesc});
        this.setData(KEY_ID_COL, new Integer(1));
        this.setData(KEY_SEQ_COL, new Integer(2));
    }

    public static String getBriefDescription() {
        return "Text table with column selection";
    }

    public static String getLongDescription() {
        return "Text table with column selection";
    }

    public SequenceDataReader getSequenceInputFormatter() {
        int idCol = (Integer)this.getData(KEY_ID_COL) - 1;
        int seqCol = (Integer)this.getData(KEY_SEQ_COL) - 1;
        HashMap<Integer, String> cols = new HashMap<Integer, String>();
        cols.put(idCol, "ID");
        cols.put(seqCol, "sequence.seqstring");
        ColumnIndexMapping inMapping = new ColumnIndexMapping(cols);
        return new TextTableFormatter((InputMapping)inMapping, null, null);
    }

    public List<Map<String, String>> getDataMaps(Reader in) throws IOException, SequenceFormatException {
        BufferedReader br = new BufferedReader(in);
        ArrayList<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        SequenceDataReader sdr = this.getSequenceInputFormatter();
        Map map = null;
        while ((map = sdr.readNextFormattedSequence(br)) != null) {
            maps.add(map);
        }
        return maps;
    }
}

