/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.workbench.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.utils.HTMLRenderer;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.workbench.gui.Messages;
import org.moltools.workbench.gui.SequenceTableListener;
import org.moltools.workbench.gui.SequenceTableModel;

public class NucleotideSequenceTableListener
extends SequenceTableListener {
    protected JMenuItem getRevComp;
    protected JMenuItem getComp = new JMenuItem(Messages.getString("NucleotideSequenceTableListener.CAPTION_GET_COMPLEMENT"));

    public NucleotideSequenceTableListener(JTable table, SequenceTableModel tableModel, HTMLRenderer seqHTMLRenderer) {
        super(table, tableModel, seqHTMLRenderer);
        this.getComp.addActionListener(this);
        this.getRevComp = new JMenuItem(Messages.getString("NucleotideSequenceTableListener.CAPTION_GET_REVCOMP"));
        this.getRevComp.addActionListener(this);
        this.popupMenu.add(this.getComp);
        this.popupMenu.add(this.getRevComp);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Component src = (Component)e.getSource();
            int row = this.table.getSelectedRow();
            if (src == this.getRev) {
                if (row > -1) {
                    NucleotideSequence s = (NucleotideSequence)this.dataModel.getSequenceAt(row);
                    JPanel panel = new JPanel();
                    panel.add(new JLabel("3'-"));
                    JTextArea sf = new JTextArea();
                    sf.setFont(new Font("monospaced", 0, 12));
                    sf.setText(SequenceHandler.getRev((String)s.seqString()));
                    sf.setEditable(false);
                    panel.add(sf);
                    panel.add(new JLabel("-5'"));
                    JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), panel, Messages.getString("SequenceTableListener.TITLE_REVERSE") + s.getID(), -1);
                }
            } else if (src == this.getComp) {
                if (row > -1) {
                    NucleotideSequence s = (NucleotideSequence)this.dataModel.getSequenceAt(row);
                    JPanel panel = new JPanel();
                    panel.add(new JLabel("3'-"));
                    JTextArea sf = new JTextArea();
                    sf.setFont(new Font("monospaced", 0, 12));
                    sf.setText(NucleotideSequenceHandler.getComp((String)s.seqString(), (byte)s.getType()));
                    sf.setEditable(false);
                    panel.add(sf);
                    panel.add(new JLabel("-5'"));
                    JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), panel, Messages.getString("NucleotideSequenceTableListener.TITLE_COMPLEMENT") + s.getID(), -1);
                }
            } else if (src == this.getRevComp) {
                if (row > -1) {
                    NucleotideSequence s = (NucleotideSequence)this.dataModel.getSequenceAt(row);
                    JPanel panel = new JPanel();
                    panel.add(new JLabel("5'-"));
                    JTextArea sf = new JTextArea();
                    sf.setFont(new Font("monospaced", 0, 12));
                    sf.setText(NucleotideSequenceHandler.getRevComp((NucleotideSequence)s));
                    sf.setEditable(false);
                    panel.add(sf);
                    panel.add(new JLabel("-3'"));
                    JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), panel, Messages.getString("NucleotideSequenceTableListener.TITLE_REVCOMP") + s.getID(), -1);
                }
            } else {
                super.actionPerformed(e);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(GUIUtils.getParentFrame((Component)this.table), ex.getMessage(), Messages.getString("SequenceTableListener.TITLE_EXCEPTION"), 0);
        }
    }
}

