/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.alphabet;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.moltools.lib.seq.alphabet.DefaultDNAAlphabet;
import org.moltools.lib.seq.alphabet.DegenerateNucleotide;
import org.moltools.lib.seq.alphabet.NAAlphabet;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.alphabet.Symbol;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegenerateNAAlphabet
extends DefaultDNAAlphabet
implements NAAlphabet {
    static final Nucleotide dU = new Nucleotide('U', 0);
    static final Nucleotide dGap = new Nucleotide('-', 0);
    static final DegenerateNucleotide dB = new DegenerateNucleotide('B', 0, new Nucleotide[]{dC, dG, dT});
    static final DegenerateNucleotide dD = new DegenerateNucleotide('D', 0, new Nucleotide[]{dA, dG, dT});
    static final DegenerateNucleotide dH = new DegenerateNucleotide('H', 0, new Nucleotide[]{dA, dC, dT});
    static final DegenerateNucleotide dK = new DegenerateNucleotide('K', 0, new Nucleotide[]{dG, dT});
    static final DegenerateNucleotide dM = new DegenerateNucleotide('M', 0, new Nucleotide[]{dA, dC});
    static final DegenerateNucleotide dN = new DegenerateNucleotide('N', 0, new Nucleotide[]{dA, dC, dG, dT});
    static final DegenerateNucleotide dR = new DegenerateNucleotide('R', 0, new Nucleotide[]{dA, dG});
    static final DegenerateNucleotide dS = new DegenerateNucleotide('S', 0, new Nucleotide[]{dC, dG});
    static final DegenerateNucleotide dV = new DegenerateNucleotide('V', 0, new Nucleotide[]{dA, dC, dG});
    static final DegenerateNucleotide dW = new DegenerateNucleotide('W', 0, new Nucleotide[]{dA, dT});
    static final DegenerateNucleotide dY = new DegenerateNucleotide('Y', 0, new Nucleotide[]{dC, dT});
    static final Nucleotide Gap = new Nucleotide('-', 1);
    static final DegenerateNucleotide B = new DegenerateNucleotide('B', 1, new Nucleotide[]{dC, dG, dU});
    static final DegenerateNucleotide D = new DegenerateNucleotide('D', 1, new Nucleotide[]{dA, dG, dU});
    static final DegenerateNucleotide H = new DegenerateNucleotide('H', 1, new Nucleotide[]{dA, dC, dU});
    static final DegenerateNucleotide K = new DegenerateNucleotide('K', 1, new Nucleotide[]{dG, dU});
    static final DegenerateNucleotide M = new DegenerateNucleotide('M', 1, new Nucleotide[]{dA, dC});
    static final DegenerateNucleotide N = new DegenerateNucleotide('N', 1, new Nucleotide[]{dA, dC, dG, dU});
    static final DegenerateNucleotide R = new DegenerateNucleotide('R', 1, new Nucleotide[]{dA, dG});
    static final DegenerateNucleotide S = new DegenerateNucleotide('S', 1, new Nucleotide[]{dC, dG});
    static final DegenerateNucleotide V = new DegenerateNucleotide('V', 1, new Nucleotide[]{dA, dC, dG});
    static final DegenerateNucleotide W = new DegenerateNucleotide('W', 1, new Nucleotide[]{dA, dU});
    static final DegenerateNucleotide Y = new DegenerateNucleotide('Y', 1, new Nucleotide[]{dC, dU});
    static final Collection<Nucleotide> nucleotides1 = new HashSet<Nucleotide>(DefaultDNAAlphabet.nucleotides);
    static final Map<Nucleotide, Nucleotide>[][] complementTables1;
    public static final DegenerateNAAlphabet degenerateAlphabet;

    @Override
    public Symbol[] getSymbols() {
        return nucleotides1.toArray(new Symbol[nucleotides1.size()]);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Nucleotide) {
            return nucleotides1.contains(o);
        }
        throw new IllegalArgumentException("Wrong symbol type for NA alphabet");
    }

    @Override
    public Nucleotide getNucleotide(char symbol, byte type) {
        for (Nucleotide n : nucleotides1) {
            if (n.getChar() != Character.toUpperCase(symbol) || n.getType() != type) continue;
            return n;
        }
        return null;
    }

    @Override
    public DegenerateNucleotide getDegenerateNucleotide(char[] varsymbols, byte type) {
        Nucleotide[] vars = new Nucleotide[varsymbols.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = this.getNucleotide(varsymbols[i], type);
        }
        Iterator<Nucleotide> i = nucleotides1.iterator();
        while (i.hasNext()) {
            try {
                DegenerateNucleotide dn = (DegenerateNucleotide)i.next();
                if (!dn.hasPossible(vars)) continue;
                return dn;
            }
            catch (ClassCastException ccx) {
            }
        }
        return null;
    }

    DegenerateNAAlphabet() {
    }

    public static NAAlphabet getAlphabet() {
        return degenerateAlphabet;
    }

    @Override
    public Iterator<Nucleotide> iterator() {
        return nucleotides1.iterator();
    }

    @Override
    public boolean isSingleNucleotide(Nucleotide n) {
        if (n == null) {
            return false;
        }
        return nucleotides1.contains(n) && !(n instanceof DegenerateNucleotide);
    }

    @Override
    public boolean isDegenerateNucleotide(Nucleotide n) {
        if (n == null) {
            return false;
        }
        return nucleotides1.contains(n) && n instanceof DegenerateNucleotide;
    }

    @Override
    public String toString() {
        String str = "";
        Object[] nucs = nucleotides1.toArray();
        for (int i = 0; i < nucs.length; ++i) {
            Nucleotide n = (Nucleotide)nucs[i];
            str = str + n;
            if (this.isDegenerateNucleotide(n)) {
                Nucleotide[] poss = ((DegenerateNucleotide)n).getPossible();
                str = str + ": ";
                for (int j = 0; j < poss.length; ++j) {
                    str = str + poss[j] + " ";
                }
            }
            str = str + " (" + NucleotideSequenceHandler.getTypeString(n.getType()) + ")\n";
        }
        return str;
    }

    @Override
    public Nucleotide getComplementNucleotide(Nucleotide n, byte type) {
        byte type1 = n.getType();
        Nucleotide nt = complementTables1[type1][type].get(n);
        if (nt == null) {
            throw new UnsupportedOperationException("No complement found for " + n.getChar());
        }
        return nt;
    }

    static {
        nucleotides1.add(dU);
        nucleotides1.add(dGap);
        nucleotides1.add(dB);
        nucleotides1.add(dD);
        nucleotides1.add(dH);
        nucleotides1.add(dK);
        nucleotides1.add(dM);
        nucleotides1.add(dN);
        nucleotides1.add(dR);
        nucleotides1.add(dS);
        nucleotides1.add(dV);
        nucleotides1.add(dW);
        nucleotides1.add(dY);
        nucleotides1.add(A);
        nucleotides1.add(G);
        nucleotides1.add(C);
        nucleotides1.add(U);
        nucleotides1.add(Gap);
        nucleotides1.add(B);
        nucleotides1.add(D);
        nucleotides1.add(H);
        nucleotides1.add(K);
        nucleotides1.add(M);
        nucleotides1.add(N);
        nucleotides1.add(R);
        nucleotides1.add(S);
        nucleotides1.add(V);
        nucleotides1.add(W);
        nucleotides1.add(Y);
        complementTables1 = new Map[2][2];
        DegenerateNAAlphabet.complementTables1[0][0] = new HashMap<Nucleotide, Nucleotide>(DefaultDNAAlphabet.complementTables[0][0]);
        DegenerateNAAlphabet.complementTables1[0][1] = new HashMap<Nucleotide, Nucleotide>(DefaultDNAAlphabet.complementTables[0][1]);
        DegenerateNAAlphabet.complementTables1[1][0] = new HashMap<Nucleotide, Nucleotide>(DefaultDNAAlphabet.complementTables[1][0]);
        DegenerateNAAlphabet.complementTables1[1][1] = new HashMap<Nucleotide, Nucleotide>(DefaultDNAAlphabet.complementTables[1][1]);
        complementTables1[0][0].put(dU, dA);
        complementTables1[0][0].put(dB, dV);
        complementTables1[0][0].put(dD, dH);
        complementTables1[0][0].put(dH, dD);
        complementTables1[0][0].put(dK, dM);
        complementTables1[0][0].put(dM, dK);
        complementTables1[0][0].put(dN, dN);
        complementTables1[0][0].put(dR, dY);
        complementTables1[0][0].put(dS, dW);
        complementTables1[0][0].put(dU, dA);
        complementTables1[0][0].put(dV, dB);
        complementTables1[0][0].put(dW, dS);
        complementTables1[0][0].put(dY, dR);
        complementTables1[0][1].put(dU, A);
        complementTables1[0][1].put(dB, V);
        complementTables1[0][1].put(dD, H);
        complementTables1[0][1].put(dH, D);
        complementTables1[0][1].put(dK, M);
        complementTables1[0][1].put(dM, K);
        complementTables1[0][1].put(dN, N);
        complementTables1[0][1].put(dR, Y);
        complementTables1[0][1].put(dS, W);
        complementTables1[0][1].put(dU, A);
        complementTables1[0][1].put(dV, B);
        complementTables1[0][1].put(dW, S);
        complementTables1[0][1].put(dY, R);
        complementTables1[1][0].put(B, dV);
        complementTables1[1][0].put(D, dH);
        complementTables1[1][0].put(H, dD);
        complementTables1[1][0].put(K, dM);
        complementTables1[1][0].put(M, dK);
        complementTables1[1][0].put(N, dN);
        complementTables1[1][0].put(R, dY);
        complementTables1[1][0].put(S, dW);
        complementTables1[1][0].put(V, dB);
        complementTables1[1][0].put(W, dS);
        complementTables1[1][0].put(Y, dR);
        complementTables1[1][1].put(B, V);
        complementTables1[1][1].put(D, H);
        complementTables1[1][1].put(H, D);
        complementTables1[1][1].put(K, M);
        complementTables1[1][1].put(M, K);
        complementTables1[1][1].put(N, N);
        complementTables1[1][1].put(R, Y);
        complementTables1[1][1].put(S, W);
        complementTables1[1][1].put(V, B);
        complementTables1[1][1].put(W, S);
        complementTables1[1][1].put(Y, R);
        degenerateAlphabet = new DegenerateNAAlphabet();
    }
}

