/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.struct;

import org.moltools.lib.alignment.Alignment;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.utils.SequenceHandler;
import org.moltools.lib.struct.NAHybridStructure;

public class DefaultNAHybridStructure
implements NAHybridStructure {
    protected int firststart;
    protected int secondstart;
    protected int firstend;
    protected int secondend;
    protected String firstseq;
    protected String secondseq;

    protected DefaultNAHybridStructure() {
    }

    public DefaultNAHybridStructure(Alignment la, int seq2Length) {
        this.firststart = la.getFirstStart();
        this.firstend = la.getFirstEnd();
        this.firstseq = la.getFirstString();
        this.secondstart = seq2Length - la.getSecondEnd() + 1;
        this.secondend = seq2Length - la.getSecondStart() + 1;
        this.secondseq = SequenceHandler.getRev(la.getSecondString());
    }

    public DefaultNAHybridStructure(String first, int fstart, int fend, String second, int sstart, int send) {
        this.firststart = fstart;
        this.firstend = fend;
        this.firstseq = first;
        this.secondstart = sstart;
        this.secondend = send;
        this.secondseq = second;
    }

    public DefaultNAHybridStructure(Sequence fseq, int fstart, int fend, Sequence sseq, int sstart, int send) {
        this.firststart = fstart;
        this.firstend = fend;
        this.firstseq = fseq.subsequence(this.firststart, this.firstend);
        this.secondstart = sstart;
        this.secondend = send;
        this.secondseq = sseq.subsequence(this.secondstart, this.secondend);
        int length1 = this.firstend - this.firststart + 1;
        int length2 = this.secondend - this.secondstart + 1;
        if (length1 != length2) {
            throw new IllegalArgumentException("Sequences are of different lengths: " + length1 + "!=" + length2);
        }
    }

    public int getFirstStart() {
        return this.firststart;
    }

    public int getFirstEnd() {
        return this.firstend;
    }

    public String getFirstString() {
        return this.firstseq;
    }

    public int getSecondStart() {
        return this.secondstart;
    }

    public int getSecondEnd() {
        return this.secondend;
    }

    public String getSecondString() {
        return this.secondseq;
    }
}

