/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.apptools.utils.HTMLRenderer;
import net.sf.apptools.utils.HTMLWriter;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.moltools.apps.probemaker.CoreMessages;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageHolder;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.VariantTarget;
import org.moltools.design.data.Candidate;
import org.moltools.design.data.PropertyHolderNucleotideSequence;
import org.moltools.design.data.impl.TargetGroup;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.Identifiable;
import org.moltools.lib.Named;
import org.moltools.lib.seq.CompositeSequence;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.workbench.SequenceHTMLRenderer;

public class ProbeMakerHTMLRenderer
extends SequenceHTMLRenderer {
    public static String[] fontColorStrings = new String[]{"#000000", "#FFFF00", "#FF0000", "#FF0000"};
    private boolean showVariant = true;
    private boolean showGroupMembers = true;
    private boolean showQuality = true;
    private boolean showMessages = true;
    private boolean showHybTemps = true;

    public ProbeMakerHTMLRenderer() {
        this((HTMLRenderer)new SequenceHTMLRenderer(null));
    }

    public ProbeMakerHTMLRenderer(HTMLRenderer delegateRenderer) {
        super(delegateRenderer);
    }

    public boolean canRenderHTMLInternal(Object o) {
        if (o instanceof ProbeMakerTarget) {
            return true;
        }
        return o instanceof Probe;
    }

    protected String renderHTMLInternal(Object s) {
        Element root = new Element("sequence");
        Sequence seq = (Sequence)s;
        if (this.isShowID()) {
            this.addIDHeader(root, (Identifiable)seq);
        }
        if (this.isShowName() && seq instanceof Named) {
            this.addName(root, (Named)seq);
        }
        if (this.isShowSeq()) {
            this.addSequenceString(root, seq);
        }
        if (this.isShowLength() && seq instanceof NucleotideSequence) {
            this.addLengthData(root, (NucleotideSequence)seq);
        }
        if (this.isShowPolys() && seq instanceof NucleotideSequence) {
            this.addPolyData(root, (NucleotideSequence)seq);
        }
        if (this.showVariant && seq instanceof VariantTarget) {
            this.addVariantData(root, (VariantTarget)seq);
        }
        if (this.showGroupMembers && seq instanceof ProbeMakerTarget) {
            this.addTargetGroupData(root, (ProbeMakerTarget)seq);
        }
        if (this.showQuality && seq instanceof Candidate) {
            this.addQuality(root, (PropertyHolder)((Candidate)seq));
        }
        if (this.isShowBlocks() && seq instanceof CompositeSequence) {
            this.addBlocks(root, (Probe)seq);
        }
        if (this.showHybTemps && seq instanceof Probe) {
            this.addHybTemps(root, (Probe)seq);
        }
        if (this.showMessages && seq instanceof MessageHolder) {
            this.addMessages(root, (MessageHolder)seq);
        }
        if (this.isShowSymbolCount()) {
            this.addSymbolCount(root, seq);
        }
        String str = new XMLOutputter(Format.getPrettyFormat()).outputString(root);
        return str;
    }

    protected String getHTMLContainerTitleInternal(Object obj) {
        if (obj instanceof Identifiable) {
            return ((Identifiable)obj).getID();
        }
        return obj.getClass().getName();
    }

    protected void addHybTemps(Element root, Probe p) {
        Element h4 = new Element(HTMLWriter.H4.getTag());
        h4.addContent(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_TSS_TMS"));
        ArrayList<PropertyHolderNucleotideSequence> seqs = new ArrayList<PropertyHolderNucleotideSequence>(p.getTSSPair().getSequences());
        PropertyHolderNucleotideSequence[] tsss = seqs.toArray(new PropertyHolderNucleotideSequence[seqs.size()]);
        Element table = new Element(HTMLWriter.TABLE.getTag());
        table.setAttribute(HTMLWriter.BORDER.getTag(), "0");
        table.setAttribute(HTMLWriter.CELLSPACING.getTag(), "0");
        table.setAttribute(HTMLWriter.CELLPADDING.getTag(), "0");
        for (int i = 0; i < tsss.length; ++i) {
            PropertyHolderNucleotideSequence tss = tsss[i];
            Element tr = new Element(HTMLWriter.TR.getTag());
            tr.setAttribute(HTMLWriter.ALIGN.getTag(), HTMLWriter.LEFT.getTag());
            Element th = new Element(HTMLWriter.TH.getTag());
            th.addContent(tss.getID() + ": ");
            Element td = new Element(HTMLWriter.TD.getTag());
            Element tt = new Element(HTMLWriter.TT.getTag());
            tt.addContent(MessageFormat.format(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_TSS_TEMP"), new Double(ProbeMakerPropertyUtils.getHybridizationTemp((PropertyHolder)tss))));
            td.addContent((Content)tt);
            tr.addContent((Content)th);
            tr.addContent((Content)td);
            table.addContent((Content)tr);
        }
        root.addContent((Content)h4);
        root.addContent((Content)table);
    }

    protected void addMessages(Element root, PropertyHolder holder) {
        Element h4 = new Element("h4");
        h4.addContent(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_MESSAGES"));
        root.addContent((Content)h4);
        Collection<Message> messages = ProbeMakerPropertyUtils.getAllMessages(holder);
        if (messages.isEmpty()) {
            root.addContent(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_NO_MESSAGES"));
        } else {
            Element list = new Element(HTMLWriter.UL.getTag());
            for (Message m : messages) {
                Element li = new Element(HTMLWriter.LI.getTag());
                Element font = new Element(HTMLWriter.FONT.getTag());
                font.setAttribute(HTMLWriter.COLOR.getTag(), fontColorStrings[m.getSeverity()]);
                font.addContent(Message.messageSeverityDescriptions[m.getSeverity()]);
                li.addContent((Content)font);
                li.addContent(": " + m.getMessage());
                list.addContent((Content)li);
            }
            root.addContent((Content)list);
        }
    }

    protected void addQuality(Element root, PropertyHolder c) {
        Object[] args = new Object[]{ProbeMakerConstants.qualityStrings[ProbeMakerPropertyUtils.getRank(c)]};
        String str = MessageFormat.format(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_QUALITY"), args);
        this.addParagraphText(root, str);
    }

    protected void addTargetGroupData(Element root, ProbeMakerTarget t) {
        TargetGroup targetGroup = (TargetGroup)DesignUtils.getGroupWithType((PropertyHolder)t, (String)"moltools.targetGroup");
        if (targetGroup == null) {
            this.addParagraphText(root, CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_NO_GROUP"));
        } else {
            Element h4 = new Element(HTMLWriter.H4.getTag());
            h4.addContent(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_GROUPED_WITH"));
            Element list = new Element(HTMLWriter.UL.getTag());
            for (ProbeMakerTarget other : targetGroup.getMembers()) {
                if (t == other) continue;
                Element li = new Element(HTMLWriter.LI.getTag());
                li.addContent(other.getID());
                list.addContent((Content)li);
            }
            root.addContent((Content)h4);
            root.addContent((Content)list);
        }
    }

    protected void addVariantData(Element root, VariantTarget vt) {
        String str = vt.getVariant() == null ? "" : MessageFormat.format(CoreMessages.getString("ProbeMakerHTMLRenderer.TEXT_VARIANT"), vt.getVariant().toString());
        this.addParagraphText(root, str);
    }

    public boolean isShowGroupMembers() {
        return this.showGroupMembers;
    }

    public void setShowGroupMembers(boolean showGroupMembers) {
        this.showGroupMembers = showGroupMembers;
    }

    public boolean isShowHybTemps() {
        return this.showHybTemps;
    }

    public void setShowHybTemps(boolean showHybTemps) {
        this.showHybTemps = showHybTemps;
    }

    public boolean isShowMessages() {
        return this.showMessages;
    }

    public void setShowMessages(boolean showMessages) {
        this.showMessages = showMessages;
    }

    public boolean isShowQuality() {
        return this.showQuality;
    }

    public void setShowQuality(boolean showQuality) {
        this.showQuality = showQuality;
    }

    public boolean isShowVariant() {
        return this.showVariant;
    }

    public void setShowVariant(boolean showVariant) {
        this.showVariant = showVariant;
    }
}

