/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.apps.probemaker.seq.Variant;
import org.moltools.apps.probemaker.seq.VariantTarget;
import org.moltools.design.data.TargettedSequence;
import org.moltools.design.data.impl.AbstractPositionTarget;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.SequenceCluster;
import org.moltools.lib.seq.impl.MapCluster;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProbeMakerPositionTarget
extends AbstractPositionTarget
implements VariantTarget,
ProbeMakerTarget {
    public AbstractProbeMakerPositionTarget() {
        this("", "", 0, "");
    }

    public AbstractProbeMakerPositionTarget(String id, String seq, byte type, String desc) {
        super(id, seq, type, desc);
    }

    @Override
    public void setVariant(Variant variant) {
        if (variant instanceof IntegerVariant) {
            this.targetPos = ((IntegerVariant)variant).value;
        } else if (variant == null) {
            this.targetPos = 0;
        } else {
            throw new IllegalArgumentException("Invalid variant type");
        }
    }

    @Override
    public Variant getVariant() {
        if (this.targetPos >= 0) {
            return new IntegerVariant(this.targetPos);
        }
        return null;
    }

    @Override
    public Variant[] getVariants() {
        ArrayList<IntegerVariant> v = new ArrayList<IntegerVariant>();
        for (int pos = 0; pos < this.length(); ++pos) {
            v.add(new IntegerVariant(pos));
        }
        return v.toArray(new Variant[v.size()]);
    }

    public List<AbstractProbeMakerPositionTarget> expand() {
        return Collections.singletonList(this);
    }

    public SequenceCluster<NucleotideSequence> getTemplateCluster() {
        MapCluster sc = new MapCluster();
        try {
            sc.putSequence("FIVE_PRIME", (Sequence)this.getTemplateForFivePrime());
            sc.putSequence("THREE_PRIME", (Sequence)this.getTemplateForThreePrime());
        }
        catch (ClusterException clusterException) {
            // empty catch block
        }
        return sc;
    }

    protected abstract TargettedSequence getTemplateForFivePrime();

    protected abstract TargettedSequence getTemplateForThreePrime();

    public byte isValidTarget() {
        if (this.targetPos < 0) {
            return 2;
        }
        for (int i = 0; i < this.sequence.length(); ++i) {
            if (NucleotideSequenceHandler.isValidSymbol((char)this.sequence.charAt(i), (byte)this.getType())) continue;
            return 1;
        }
        return 0;
    }

    public class IntegerVariant
    implements Variant {
        public int value;

        public IntegerVariant(int i) {
            this.value = i;
        }

        public String getName() {
            return String.valueOf(this.value);
        }

        public String toString() {
            return this.getName();
        }

        public Variant[] getVariantGroup() {
            return new Variant[]{this};
        }
    }
}

