/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.disperse;

import edu.stanford.disperse.RunTarget;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.genefront.piecemaker.io.PieceMakerIOUtils;
import net.genefront.piecemaker.model.CutResults;
import net.genefront.piecemaker.model.FragmentSet;
import net.genefront.piecemaker.model.MutableFragmentSet;
import net.genefront.piecemaker.model.PieceMakerProject;
import net.genefront.piecemaker.model.SelectorTarget;
import net.genefront.piecemaker.model.TargetFragment;
import net.genefront.piecemaker.model.impl.PieceMakerDataFactory;
import net.genefront.piecemaker.ops.CoverageCalculator;
import net.genefront.piecemaker.ops.FragmentFilter;
import net.genefront.piecemaker.ops.FragmentSubSetSelector;
import net.genefront.piecemaker.ops.impl.AbstractCoverageCombinationSelector;
import net.genefront.piecemaker.ops.impl.DefaultCoverageCalculator;
import net.genefront.piecemaker.restriction.RestrictionReaction;
import net.genefront.piecemaker.tasks.DefaultFragmentSubSetSelectTask;
import net.genefront.piecemaker.tasks.ThreadPoolFragmentSelectionTask;
import net.genefront.piecemaker.utils.CoverageUtils;
import net.genefront.piecemaker.utils.PropertyUtils;
import net.genefront.piecemaker.utils.SettingsUtils;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.TransformedPredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.moltools.design.predicates.ExcludeIDsPredicate;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.transformers.PropertyTransformer;
import org.moltools.lib.seq.Region;
import org.moltools.lib.seq.db.SequenceDB;
import org.moltools.lib.seq.utils.RegionUtils;
import org.moltools.lib.utils.IDExtractor;

public class SelectFragmentSet
extends RunTarget {
    protected PrintWriter reportWriter;

    protected static Options createOptions() {
        Options options = new Options();
        options.addOption(targetOption);
        options.addOption(settingsOption);
        Option fragmentOption = new Option("f", true, "Fragment file");
        fragmentOption.setRequired(true);
        options.addOption(fragmentOption);
        options.addOption("o", true, "Output file");
        options.addOption(helpOption);
        return options;
    }

    public SelectFragmentSet() {
        super("selectfrags", SelectFragmentSet.createOptions());
    }

    public static void main(String[] args) {
        try {
            SelectFragmentSet runner = new SelectFragmentSet();
            if (runner.parseCommandLine(args)) {
                if (!runner.commandLine.hasOption("t")) {
                    SelectFragmentSet.error("No target file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                if (!runner.commandLine.hasOption("s")) {
                    SelectFragmentSet.error("No settings file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                if (!runner.commandLine.hasOption("f")) {
                    SelectFragmentSet.error("No fragment file specified");
                    runner.printHelp();
                    System.exit(1);
                }
                File outputfile = null;
                if (runner.commandLine.hasOption("o")) {
                    outputfile = new File(runner.commandLine.getOptionValue("o"));
                }
                File targetfile = new File(runner.commandLine.getOptionValue("t"));
                File settingsfile = new File(runner.commandLine.getOptionValue("s"));
                File fragmentfile = new File(runner.commandLine.getOptionValue("f"));
                if (!targetfile.canRead()) {
                    SelectFragmentSet.error("Target file does not exist: " + targetfile.getAbsolutePath());
                    System.exit(1);
                }
                if (!settingsfile.canRead()) {
                    SelectFragmentSet.error("Settings file does not exist: " + settingsfile.getAbsolutePath());
                    System.exit(1);
                }
                if (!fragmentfile.canRead()) {
                    SelectFragmentSet.error("Fragment file does not exist: " + fragmentfile.getAbsolutePath());
                    System.exit(1);
                }
                if (outputfile != null && !outputfile.getAbsoluteFile().getParentFile().canWrite()) {
                    SelectFragmentSet.error("Output file can not be written: " + outputfile.getAbsolutePath());
                    System.exit(1);
                }
                PrintWriter outputWriter = outputfile == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputfile));
                PieceMakerProject project = new PieceMakerProject();
                project.setTargets(runner.readTargets(targetfile));
                int targetcount = project.getTargetCount();
                Properties p = new Properties();
                p.load(new FileInputStream(settingsfile));
                Map vars = SettingsUtils.getVariables((Map)p);
                int iterations = 1;
                if (p.containsKey("piecemaker.selectionIterations")) {
                    iterations = Integer.parseInt(p.getProperty("piecemaker.selectionIterations"));
                }
                FragmentSubSetSelector fss = SettingsUtils.getFragmentSubSetSelector((Map)p, (Map)vars);
                System.out.println("Loading fragments from " + fragmentfile.getName());
                FileReader fragreader = new FileReader(fragmentfile);
                Collection fragments = PieceMakerIOUtils.getFragments((Reader)fragreader, (SequenceDB)project);
                int fragcount = fragments.size();
                HashSet<String> names = new HashSet<String>();
                Iterator i = fragments.iterator();
                while (i.hasNext()) {
                    String rname = PropertyUtils.getReactionName((PropertyHolder)((PropertyHolder)i.next()));
                    names.add(rname);
                }
                ArrayList nameList = new ArrayList(names);
                System.out.println("Sorting fragments");
                CutResults fragmentSets = new CutResults(names.size(), project.getTargetCount());
                for (int t = 0; t < fragmentSets.getTargetCount(); ++t) {
                    SelectorTarget target = project.getTarget(t);
                    for (int r = 0; r < nameList.size(); ++r) {
                        String reactionname = (String)nameList.get(r);
                        TransformedPredicate targetpred = new TransformedPredicate((Transformer)new PropertyTransformer("piecemaker.targetID"), (Predicate)new EqualPredicate((Object)target.getID()));
                        TransformedPredicate reactionpred = new TransformedPredicate((Transformer)new PropertyTransformer("piecemaker.reactionName"), (Predicate)new EqualPredicate((Object)reactionname));
                        Predicate predicate = AndPredicate.getInstance((Predicate)targetpred, (Predicate)reactionpred);
                        Collection pairfrags = CollectionUtils.select((Collection)fragments, (Predicate)predicate);
                        MutableFragmentSet set = PieceMakerDataFactory.createFragmentSetWithProperties((String)target.getID(), (String)reactionname, (String[])reactionname.split("/"), (Collection)pairfrags);
                        fragmentSets.setSet(r, t, set);
                    }
                }
                project.setReactions(new ArrayList(CollectionUtils.collect(nameList, (Transformer)new Transformer(){

                    public Object transform(Object input) {
                        return null;
                    }
                })));
                project.setAllResults(fragmentSets);
                FragmentFilter filter = new FragmentFilter(){

                    public Predicate getFragmentPredicate(SelectorTarget st) {
                        return TruePredicate.getInstance();
                    }
                };
                ThreadPoolFragmentSelectionTask selector = new ThreadPoolFragmentSelectionTask(project.getAllFragmentSets(), project.getAcceptedFragmentSets(), filter, (SequenceDB)project);
                selector.run();
                ArrayList<RestrictionReaction> combinationReactions = new ArrayList<RestrictionReaction>();
                for (int r = 0; r < project.getReactionCount(); ++r) {
                    project.addToCombination(r);
                    combinationReactions.add(project.getReaction(r));
                }
                int reactioncount = project.getCombinationReactionCount();
                int coverageLevel = iterations;
                CoverageCalculator projectCoverageCalculator = ((AbstractCoverageCombinationSelector)SettingsUtils.getCombinationSelector((Map)p, (Map)vars)).getCoverageCalculator();
                DefaultCoverageCalculator defaultCoverageCalculator = new DefaultCoverageCalculator();
                MutableFragmentSet[][] copySets = new MutableFragmentSet[targetcount][project.getCombinationReactionCount()];
                MutableFragmentSet[][] currentSets = project.getCombinationArray();
                Collection[] allFragments = new Collection[targetcount];
                for (int i2 = 0; i2 < allFragments.length; ++i2) {
                    allFragments[i2] = new HashSet();
                }
                int roisize = CoverageUtils.getTotalROISize((Collection)project.getTargetList());
                Map coveredRegionMap = CoverageUtils.createCoverageMapInTargetCoords((Collection)project.getTargetList(), (Collection)fragments, (int)1, (CoverageCalculator)defaultCoverageCalculator);
                int totCoverage = CoverageUtils.getTotalRegionSize((Map)coveredRegionMap);
                System.out.println("Loaded " + fragcount + " fragments covering " + totCoverage + " of " + roisize + " bases");
                ArrayList allselectedfragments = new ArrayList();
                for (int iteration = 0; iteration < iterations; ++iteration) {
                    ArrayList<MutableFragmentSet[]> combinationResults = new ArrayList<MutableFragmentSet[]>();
                    for (int i3 = 0; i3 < copySets.length; ++i3) {
                        for (int j = 0; j < copySets[i3].length; ++j) {
                            if (i3 == 0) {
                                combinationResults.add(new MutableFragmentSet[targetcount]);
                            }
                            copySets[i3][j] = PieceMakerDataFactory.copyFragmentSet((FragmentSet)currentSets[i3][j]);
                            ((FragmentSet[])combinationResults.get((int)j))[i3] = currentSets[i3][j];
                        }
                    }
                    Map targetRegionMap = CoverageUtils.createNonCoverageMapInTargetCoords((Collection)project.getTargetList(), allselectedfragments, (int)coverageLevel, (CoverageCalculator)projectCoverageCalculator);
                    System.out.println("Selecting fragment subset for " + targetcount + " targets and " + reactioncount + " reactions");
                    project.setCombination(combinationReactions, combinationResults);
                    DefaultFragmentSubSetSelectTask task = new DefaultFragmentSubSetSelectTask(project, targetRegionMap, fss);
                    task.run();
                    MutableFragmentSet[][] sets = project.getCombinationArray();
                    final ArrayList<TargetFragment> selectedfragments = new ArrayList<TargetFragment>();
                    for (int t = 0; t < sets.length; ++t) {
                        final SelectorTarget target = project.getTarget(t);
                        for (int enzyme = 0; enzyme < sets[t].length; ++enzyme) {
                            MutableFragmentSet set = sets[t][enzyme];
                            for (final TargetFragment tf : set) {
                                boolean add = true;
                                for (int ot = 0; ot < allFragments.length; ++ot) {
                                    Collection frags = allFragments[ot];
                                    final SelectorTarget othertarget = project.getTarget(ot);
                                    Predicate predicate = new Predicate(){

                                        public boolean evaluate(Object object) {
                                            String enz2;
                                            TargetFragment other = (TargetFragment)object;
                                            if (!othertarget.getParentID().equals(target.getParentID())) {
                                                return false;
                                            }
                                            if (other.getPolarity() != tf.getPolarity()) {
                                                return false;
                                            }
                                            if (PropertyUtils.getEndoPosition((PropertyHolder)other) != PropertyUtils.getEndoPosition((PropertyHolder)tf)) {
                                                return false;
                                            }
                                            String enz1 = tf.getID().split("|")[1];
                                            if (!enz1.equals(enz2 = other.getID().split("|")[1])) {
                                                return false;
                                            }
                                            Region tfregionOnParent = PropertyUtils.getRegionInParent((SelectorTarget)target, (TargetFragment)tf);
                                            Region otherregionOnParent = PropertyUtils.getRegionInParent((SelectorTarget)othertarget, (TargetFragment)other);
                                            if (tfregionOnParent.getStart() != otherregionOnParent.getStart()) {
                                                return false;
                                            }
                                            return tfregionOnParent.getEnd() == otherregionOnParent.getEnd();
                                        }
                                    };
                                    if (CollectionUtils.find((Collection)frags, (Predicate)predicate) == null) continue;
                                    add = false;
                                    break;
                                }
                                if (add) {
                                    selectedfragments.add(tf);
                                }
                                allFragments[t].add(tf);
                            }
                        }
                    }
                    allselectedfragments.addAll(selectedfragments);
                    Map coveredMap = CoverageUtils.createCoverageMapInTargetCoords((Collection)project.getTargetList(), allselectedfragments, (int)1, (CoverageCalculator)defaultCoverageCalculator);
                    int coveredBases = CoverageUtils.getTotalRegionSize((Map)coveredMap);
                    System.out.println("Done. Selected " + selectedfragments.size() + " fragments covering " + coveredBases + " of " + roisize + " bases");
                    if (coveredBases < totCoverage) {
                        System.out.println("Error in fragment selection. Coverage less than optimal: " + coveredBases + "<" + totCoverage);
                        for (String key : coveredRegionMap.keySet()) {
                            List selRegs;
                            List allRegs = (List)coveredRegionMap.get(key);
                            if (RegionUtils.equal((List)allRegs, (List)(selRegs = (List)coveredMap.get(key)))) continue;
                            System.out.println(key + "\t" + allRegs + "\t" + selRegs);
                            System.out.println("All fragments:");
                            for (Collection frags : allFragments) {
                                for (TargetFragment tf : frags) {
                                    if (!tf.getParentID().equals(key)) continue;
                                    System.out.println(tf);
                                }
                            }
                            System.out.println("Selected fragments:");
                            for (TargetFragment tf : allselectedfragments) {
                                if (!tf.getParentID().equals(key)) continue;
                                System.out.println(tf);
                            }
                        }
                        throw new RuntimeException("Error in fragment selection. Coverage less than optimal");
                    }
                    if (outputfile != null) {
                        System.out.println("Writing selected fragments to " + outputfile.getAbsolutePath());
                    }
                    outputWriter.println("#Fragment subset selection");
                    outputWriter.println("#" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date(System.currentTimeMillis())));
                    outputWriter.println("#Using " + fss.getClass());
                    PieceMakerIOUtils.putFragmentsWithSequence((Writer)outputWriter, selectedfragments, (List)project.getTargetList(), null);
                    Collection ids = CollectionUtils.collect(selectedfragments, (Transformer)IDExtractor.getInstance());
                    ExcludeIDsPredicate p1 = new ExcludeIDsPredicate(ids);
                    Predicate p2 = new Predicate(){

                        public boolean evaluate(Object object) {
                            TargetFragment tf = (TargetFragment)object;
                            if (PropertyUtils.getEndoPosition((PropertyHolder)tf) > 0) {
                                return true;
                            }
                            String id = tf.getID();
                            id = id.contains("|+|") ? id.replace("|+|", "|-|") : id.replace("|-|", "|+|");
                            TargetFragment opposite = (TargetFragment)CollectionUtils.find((Collection)selectedfragments, (Predicate)new TransformedPredicate((Transformer)IDExtractor.getInstance(), EqualPredicate.getInstance((Object)id)));
                            if (opposite == null) {
                                return true;
                            }
                            return PropertyUtils.getEndoPosition((PropertyHolder)opposite) >= 1;
                        }
                    };
                    AndPredicate predicate = new AndPredicate((Predicate)p1, p2);
                    for (int t = 0; t < sets.length; ++t) {
                        for (int enzyme = 0; enzyme < sets[t].length; ++enzyme) {
                            MutableFragmentSet set = copySets[t][enzyme];
                            HashSet tfs = new HashSet(set.getAllFragments());
                            set.clear();
                            set.addAll(CollectionUtils.select(tfs, (Predicate)predicate));
                            currentSets[t][enzyme].clear();
                            currentSets[t][enzyme].addAll((Collection)set.getAllFragments());
                        }
                    }
                }
                outputWriter.close();
                System.out.println("Completed.");
                for (int i4 = 1; i4 <= coverageLevel; ++i4) {
                    coveredRegionMap = CoverageUtils.createCoverageMapInTargetCoords((Collection)project.getTargetList(), allselectedfragments, (int)i4, (CoverageCalculator)defaultCoverageCalculator);
                    int allFragsCoverage = CoverageUtils.getTotalRegionSize((Map)coveredRegionMap);
                    System.out.println("Selected fragments cover " + allFragsCoverage + " of " + roisize + " bases at depth " + i4);
                }
            }
        }
        catch (Exception ex) {
            SelectFragmentSet.error(ex.getMessage(), ex);
            System.exit(1);
        }
    }
}

