/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.textio;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.apptools.textio.DataMapInput;
import net.sf.apptools.textio.InputMapping;
import net.sf.apptools.textio.ObjectBuilder;
import net.sf.apptools.textio.StringArrayInput;
import net.sf.apptools.textio.TextIOUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInputUtils {
    static Log log = LogFactory.getLog(TextInputUtils.class);

    public static <T> List<T> readObjects(Reader in, DataMapInput source, ObjectBuilder<T> builder) throws IOException {
        return TextInputUtils.readObjects(in, source, null, builder);
    }

    public static <T> List<T> readObjects(Reader in, DataMapInput source, Map<String, Transformer> transforms, ObjectBuilder<T> builder) throws IOException {
        ArrayList<T> l = new ArrayList<T>();
        source.setReader(in);
        Map<String, String> dataMap = null;
        while ((dataMap = source.getNextDataMap()) != null) {
            Map<String, String> transformed = TextIOUtils.transformDataMap(dataMap, transforms);
            T o = builder.buildObject(transformed);
            l.add(o);
        }
        return l;
    }

    public static <T> List<T> readObjects(Reader in, StringArrayInput source, InputMapping mapping, ObjectBuilder<T> builder) throws IOException {
        return TextInputUtils.readObjects(in, source, mapping, null, builder);
    }

    public static <T> List<T> readObjects(Reader in, StringArrayInput source, InputMapping mapping, Map<String, Transformer> transforms, ObjectBuilder<T> builder) throws IOException {
        ArrayList<T> l = new ArrayList<T>();
        source.setReader(in);
        String[] record = null;
        while ((record = source.getNextRecord()) != null) {
            Map<String, String> map = mapping.createMapForRecord(record);
            Map<String, String> transformed = TextIOUtils.transformDataMap(map, transforms);
            T o = builder.buildObject(transformed);
            l.add(o);
        }
        return l;
    }
}

