/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import net.sf.apptools.ActivePlugInListener;
import net.sf.apptools.DefaultPlatform;
import net.sf.apptools.Platform;
import net.sf.apptools.actions.AbstractUserAction;
import net.sf.apptools.actions.ActionSet;
import net.sf.apptools.actions.ActionSetListener;
import net.sf.apptools.actions.UserAction;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.log.ErrorHandler;
import net.sf.apptools.plugin.ActivePlugIn;
import net.sf.apptools.plugin.ParameterPlugIn;
import net.sf.apptools.plugin.PlugInException;
import net.sf.apptools.plugin.PlugInUtils;
import net.sf.apptools.task.AbstractTask;
import net.sf.apptools.task.Task;
import net.sf.apptools.task.TaskListener;
import net.sf.apptools.ui.UIActivePlugIn;
import net.sf.apptools.ui.UITexts;
import net.sf.apptools.ui.swing.SwingUserAction;
import net.sf.apptools.ui.swing.SwingWorkbenchUI;
import net.sf.apptools.ui.swing.WorkbenchUI_AboutBox;
import net.sf.apptools.ui.swing.data.DataEditorFactory;
import net.sf.apptools.ui.swing.data.DataHolderDialog;
import net.sf.apptools.ui.swing.data.DefaultDataEditorFactory;
import net.sf.apptools.ui.swing.plugin.PlugInRenderer;
import net.sf.apptools.ui.swing.task.SimpleProgressDialog;
import net.sf.apptools.ui.swing.task.SwingTaskRunner;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import net.sf.apptools.ui.swing.utils.ListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSwingWorkbenchUI
extends JFrame
implements ActivePlugInListener,
ActivePlugIn,
ActionSetListener,
PreferenceChangeListener,
TaskListener,
SwingWorkbenchUI {
    static final String VERSION = "1.4.0";
    public static final String MENU_PATH_SEPARATOR = "/";
    protected Platform platform;
    protected JToolBar toolBar;
    protected JMenuBar menuBar;
    protected JButton addFuncButton;
    protected Icon defaultFuncIcon = null;
    protected JPopupMenu funcMenu = new JPopupMenu();
    protected List<View> currentViews = new ArrayList<View>();
    protected View activeView = null;
    protected FunctionalityListener functionalityListener = new FunctionalityListener();
    protected ButtonGroup funcButtonGroup = new ButtonGroup();
    protected JFileChooser fileChooser;
    protected DataEditorFactory dataEditorFactory = new DefaultDataEditorFactory();
    protected JPanel mainPane;
    protected MenuManager menuManager;
    protected String baseTitle;
    protected UserAction[] helpActions;
    protected JDialog monitor = null;

    @Override
    public void addDataEditorFactory(DataEditorFactory def) {
        this.dataEditorFactory.addDelegate(def);
    }

    @Override
    public void removeDataEditorFactory(DataEditorFactory def) {
        this.dataEditorFactory.removeDelegate(def);
    }

    public AbstractSwingWorkbenchUI() {
        this.toolBar = new JToolBar(UITexts.getString((String)"CommonUI.NAME_MAIN_TOOLS"));
        this.toolBar.setRollover(true);
        this.menuBar = new JMenuBar();
        this.menuManager = new MenuManager(this.menuBar);
        this.setJMenuBar(this.menuBar);
        this.mainPane = new JPanel(new BorderLayout());
        this.mainPane.add((Component)this.toolBar, "North");
        this.setContentPane(this.mainPane);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        GraphicsDevice gd = gs[0];
        Rectangle r = gd.getDefaultConfiguration().getBounds();
        this.setSize(r.getSize());
    }

    @Override
    public void setWorkbenchTitle(String title) {
        this.baseTitle = title;
        this.setTitle(title);
    }

    private void setupActions() {
        String addFuncCaption = UITexts.getString((String)"CommonUI.CAPTION_ADD_FUNCTIONALITY");
        String addFuncTooltip = UITexts.getString((String)"CommonUI.TOOL_TIP_ADD_FUNCTIONALITY");
        AbstractUserAction addFuncAction = new AbstractUserAction(addFuncCaption, addFuncTooltip){

            public void execute() {
                AbstractSwingWorkbenchUI.this.showAddFuncMenu();
            }
        };
        String aboutCaption = UITexts.getString((String)"CommonUI.CAPTION_ABOUT");
        String aboutTooltip = UITexts.getString((String)"CommonUI.TOOL_TIP_ABOUT");
        AbstractUserAction about = new AbstractUserAction(aboutCaption, aboutTooltip){

            public void execute() {
                AbstractSwingWorkbenchUI.this.about();
            }
        };
        this.helpActions = new UserAction[]{about};
        this.addFuncButton = new JButton(new SwingUserAction((UserAction)addFuncAction));
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        try {
            if (e.getID() == 201) {
                this.platform.close();
            } else if (e.getID() == 200) {
                this.updateToolBar();
            }
        }
        catch (Exception ex) {
            this.platform.handleError(ex.toString(), (Throwable)ex);
        }
    }

    protected void about() {
        WorkbenchUI_AboutBox d = new WorkbenchUI_AboutBox(this);
        GUIUtils.checkSize(this);
        d.setLocation(GUIUtils.suggestLocation(d, this));
        d.setVisible(true);
    }

    protected void toolBarUpdateFunc() {
        this.toolBar.add(Box.createGlue());
        this.toolBar.add(this.addFuncButton);
        for (View v : this.currentViews) {
            this.toolBar.add(v.button);
        }
    }

    protected void updateToolBar() {
        this.toolBar.removeAll();
        this.toolBarUpdateActions();
        this.toolBarUpdateFunc();
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    protected abstract void toolBarUpdateActions();

    protected static void addActionsToMenu(JMenu menu, UserAction[] actionGroup) {
        if (menu.getMenuComponents().length > 0) {
            menu.addSeparator();
        }
        for (int i = 0; i < actionGroup.length; ++i) {
            menu.add(new SwingUserAction(actionGroup[i]));
        }
        if (menu.getMenuComponentCount() > 0) {
            menu.setEnabled(true);
        }
    }

    protected static void removeActionsFromMenu(JMenu menu, UserAction[] actionGroup) {
        List<UserAction> actions = Arrays.asList(actionGroup);
        Component[] comps = menu.getMenuComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            JMenuItem jmi;
            if (!(comps[i] instanceof JMenuItem) || !actions.contains((jmi = (JMenuItem)comps[i]).getAction())) continue;
            menu.remove(i);
        }
        AbstractSwingWorkbenchUI.cleanMenu(menu);
        if (menu.getMenuComponentCount() == 0) {
            menu.setEnabled(false);
        }
    }

    protected static void cleanMenu(JMenu menu) {
        boolean lastWasSep = true;
        Component[] comps = menu.getMenuComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            if (!(comps[i] instanceof JPopupMenu.Separator) || !lastWasSep) continue;
            menu.remove(comps[i]);
        }
        if (menu.getMenuComponentCount() > 0 && menu.getMenuComponent(0) instanceof JPopupMenu.Separator) {
            menu.remove(0);
        }
    }

    protected abstract void switchView(View var1);

    protected abstract void addView(View var1);

    protected abstract void removeView(View var1);

    protected View getViewForPlugIn(UIActivePlugIn pi) {
        for (View v : this.currentViews) {
            if (pi != v.plugin) continue;
            return v;
        }
        return null;
    }

    protected void showAddFuncMenu() {
        ArrayList funcs;
        this.funcMenu.removeAll();
        try {
            funcs = new ArrayList(this.platform.getPlugInManager().getPlugInList("ACTIVE_PLUGIN"));
        }
        catch (PlugInException e1) {
            this.platform.handleError("Adding functionality", (Throwable)e1);
            return;
        }
        for (int i = 0; i < funcs.size(); ++i) {
            final Class funcClass = (Class)funcs.get(i);
            if (this.functionalityClassInUse(funcClass) || !UIActivePlugIn.class.isAssignableFrom(funcClass)) continue;
            JMenuItem jmi = new JMenuItem(PlugInUtils.getBriefDescription((Class)funcClass));
            jmi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractSwingWorkbenchUI.this.platform.activatePlugIn(funcClass);
                }
            });
            this.funcMenu.add(jmi);
        }
        if (funcs.size() < 1) {
            this.funcMenu.add(new JMenuItem(UITexts.getString((String)"CommonUI.MESSAGE_NO_PLUG_INS_AVAILABLE")));
        } else if (this.funcMenu.getComponentCount() < 1) {
            this.funcMenu.add(new JMenuItem(UITexts.getString((String)"CommonUI.MESSAGE_ALL_PLUG_INS_LOADED")));
        }
        this.funcMenu.show(this.addFuncButton, 0, 0);
    }

    protected void addUIPlugIn(final UIActivePlugIn func) {
        final View view = new View();
        AbstractTask uitask = new AbstractTask(UITexts.getString((String)"CommonUI.TITLE_CREATING_PLUGIN_UI"), 0, -1, 0, (ErrorHandler)this.platform){

            public void run() {
                view.ui = func.createFunctionalityUI();
                this.setCompleted();
            }
        };
        this.platform.runTask((Task)uitask);
        if (view.ui == null || !uitask.completed()) {
            return;
        }
        view.plugin = func;
        view.name = PlugInUtils.getBriefDescription((Object)func);
        view.actionSets = this.platform.getQuickActionSets((ActivePlugIn)func);
        Icon icon = func.getIcon();
        if (icon == null) {
            icon = this.defaultFuncIcon;
        }
        view.button = new JToggleButton(view.name, icon);
        view.button.addActionListener(this.functionalityListener);
        view.button.addMouseListener(this.functionalityListener);
        view.button.setToolTipText(UITexts.getString((String)"CommonUI.TOOL_TIP_SWITCH_FUNCTIONALITY") + view.name);
        this.funcButtonGroup.add(view.button);
        view.button.setSelected(true);
        this.addView(view);
    }

    protected void removeUIPlugIn(UIActivePlugIn func) {
        View v = this.getViewForPlugIn(func);
        if (v == null) {
            throw new RuntimeException("No view to remove for " + func.getClass().getName());
        }
        this.currentViews.remove(func);
        this.removeView(v);
    }

    private boolean functionalityClassInUse(Class<? extends ActivePlugIn> c) {
        for (View v : this.currentViews) {
            if (!v.plugin.getClass().equals(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void displayComponent(Component comp, String title) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int sw = d.width;
        int sh = d.height;
        Component view = comp.getSize().height > sh * 9 / 10 || comp.getSize().width > sw * 9 / 10 ? new JScrollPane(comp) : comp;
        JOptionPane op = new JOptionPane(view, -1);
        JDialog dialog = op.createDialog(this, title);
        GUIUtils.checkSize(dialog);
        dialog.setLocation(GUIUtils.suggestLocation(dialog, this));
        dialog.setVisible(true);
    }

    public byte sendMessage(String message, String messageTitle, byte responseType) {
        byte result = 0;
        block0 : switch (responseType) {
            case 0: {
                JDialog d = new JOptionPane(message, -1).createDialog(this, messageTitle);
                GUIUtils.checkSize(d);
                d.setLocation(GUIUtils.suggestLocation(d, this));
                d.setVisible(true);
                break;
            }
            case 1: {
                int resultyn = JOptionPane.showConfirmDialog(this, message, messageTitle, 0, -1);
                result = resultyn == 0 ? (byte)1 : 0;
                break;
            }
            case 2: {
                int resultync = JOptionPane.showConfirmDialog(this, message, messageTitle, 1, -1);
                switch (resultync) {
                    case 0: {
                        result = 1;
                        break block0;
                    }
                    case 1: {
                        result = 0;
                        break block0;
                    }
                    case 2: {
                        result = -1;
                        break block0;
                    }
                }
                result = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal response type specified");
            }
        }
        return result;
    }

    public byte sendMessage(List<?> messages, String messageTitle, byte responseType) {
        byte result = 0;
        block0 : switch (responseType) {
            case 0: {
                JDialog d = new JOptionPane(new JScrollPane(new JList<Object>(messages.toArray())), -1).createDialog(this, messageTitle);
                GUIUtils.checkSize(d);
                d.setLocation(GUIUtils.suggestLocation(d, this));
                d.setResizable(true);
                d.setVisible(true);
                break;
            }
            case 1: {
                int resultyn = JOptionPane.showConfirmDialog(this, messages.toArray(), messageTitle, 0, -1);
                result = resultyn == 0 ? (byte)1 : 0;
                break;
            }
            case 2: {
                int resultync = JOptionPane.showConfirmDialog(this, messages.toArray(), messageTitle, 1, -1);
                switch (resultync) {
                    case 0: {
                        result = 1;
                        break block0;
                    }
                    case 1: {
                        result = 0;
                        break block0;
                    }
                    case 2: {
                        result = -1;
                        break block0;
                    }
                }
                result = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal response type specified");
            }
        }
        return result;
    }

    public JFileChooser getDefaultFileChooser() {
        return this.fileChooser;
    }

    public File getCurrentPath() {
        if (this.fileChooser != null) {
            return this.fileChooser.getCurrentDirectory();
        }
        return new File("");
    }

    public File selectFile(FileFilter filter, File defaultFile, String caption) {
        return GUIUtils.selectFile(this, this.fileChooser, filter, defaultFile, caption);
    }

    public File selectDir(File defaultDir, String caption) {
        return GUIUtils.selectDir(this, this.fileChooser, defaultDir, caption);
    }

    public File[] selectFiles(FileFilter filter, String caption) {
        return GUIUtils.selectFiles(this, this.fileChooser, filter, caption);
    }

    public File selectSaveFile(FileFilter filter, File defaultFile, String caption, String autoSuffix) {
        return GUIUtils.selectSaveFile(this, this.fileChooser, filter, defaultFile, caption, autoSuffix);
    }

    public Object selectPlugIn(String message, List<Class<?>> plugInClasses) {
        PlugInRenderer renderer = new PlugInRenderer("");
        this.requestFocus();
        ListSelectionDialog d = new ListSelectionDialog(this, UITexts.getString((String)"CommonUI.TITLE_SELECT_PLUG_IN"), message, "", plugInClasses, (ListCellRenderer)renderer);
        d.setVisible(true);
        int index = d.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        try {
            ParameterPlugIn pm;
            Class<?> c = plugInClasses.get(index);
            Object p = c.newInstance();
            if (p instanceof ParameterPlugIn && !this.inputData((DataHolder)(pm = (ParameterPlugIn)p), PlugInUtils.getBriefDescription((Object)pm))) {
                return null;
            }
            return p;
        }
        catch (InstantiationException e) {
            this.platform.handleError("Error instantiating PlugIn class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.platform.handleError("Error accessing PlugIn class", (Throwable)e);
        }
        catch (ClassCastException e) {
            this.platform.handleError("Not a PlugIn class", (Throwable)e);
        }
        return null;
    }

    public Object selectPlugIn(String message, String identifier) {
        ArrayList classList;
        try {
            classList = new ArrayList(this.platform.getPlugInManager().getPlugInList(identifier));
        }
        catch (PlugInException e1) {
            this.platform.handleError(identifier + " plug-in type not registered", (Throwable)e1);
            return null;
        }
        return this.selectPlugIn(message, classList);
    }

    public boolean inputData(DataHolder dh, String title) {
        DataHolderDialog d = new DataHolderDialog((Frame)this, dh, title, this.dataEditorFactory);
        GUIUtils.checkSize(d);
        d.setLocation(GUIUtils.suggestLocation(d, this));
        d.setVisible(true);
        return d.inputOK();
    }

    public void plugInActivated(Platform p, ActivePlugIn pi) {
        if (pi instanceof UIActivePlugIn) {
            this.addUIPlugIn((UIActivePlugIn)pi);
        }
    }

    public void plugInDeactiviating(Platform p, ActivePlugIn pi) {
        if (pi instanceof UIActivePlugIn) {
            this.removeUIPlugIn((UIActivePlugIn)pi);
        }
    }

    public Map<String, String> getPlugInRequirements() {
        return null;
    }

    public void setup(Platform platform) {
        this.platform = platform;
        this.fileChooser = new JFileChooser(platform.getHomeDirectory());
        platform.getUserPreferences().addPreferenceChangeListener(this);
        platform.addActivePlugInListener((ActivePlugInListener)this);
        platform.addTaskListener((TaskListener)this);
        platform.addActionGroupListener((ActionSetListener)this);
        this.setupActions();
        List actionLists = platform.getAllActionSets();
        for (ActionSet as : actionLists) {
            if (as.getGroupID() == null) continue;
            this.addActionGroupInternal(as);
        }
        platform.addActionSet(new ActionSet(this.helpActions, "Help", (ActivePlugIn)this, 1000));
        this.setVisible(true);
    }

    public void exit() {
        this.teardown();
    }

    public boolean teardown() {
        this.setVisible(false);
        this.platform.removeActionGroupListener((ActionSetListener)this);
        this.platform.removeActionSets((ActivePlugIn)this);
        this.platform.removeTaskListener((TaskListener)this);
        return true;
    }

    public String getVersion() {
        return VERSION;
    }

    protected abstract void addActionGroupInternal(ActionSet var1);

    protected abstract void removeActionGroupInternal(ActionSet var1);

    public void actionSetAdded(ActionSet as) {
        this.addActionGroupInternal(as);
    }

    public void actionSetRemoved(ActionSet as) {
        this.removeActionGroupInternal(as);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(DefaultPlatform.HOME_DIR.getKey())) {
            String value = evt.getNewValue();
            File f = value == null ? null : (value.equals("") ? new File("").getAbsoluteFile().getParentFile() : new File(value));
            this.fileChooser.setCurrentDirectory(f);
        }
    }

    protected void runTask(Task t) {
        SwingTaskRunner taskRunner = new SwingTaskRunner(t, (ErrorHandler)this.platform);
        this.monitor = null;
        this.monitor = new SimpleProgressDialog((Frame)this, taskRunner);
        taskRunner.start();
        this.monitor.setVisible(true);
    }

    public boolean taskStarting(Task t) {
        this.runTask(t);
        return true;
    }

    public void taskEnded(Task t) {
        if (this.monitor != null) {
            this.monitor.setVisible(false);
            this.monitor.dispose();
            this.monitor = null;
        }
    }

    @Override
    public Frame getFrame() {
        return this;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public List<View> getCurrentViews() {
        return Collections.unmodifiableList(this.currentViews);
    }

    private class FunctionalityListener
    extends MouseAdapter
    implements ActionListener {
        JPopupMenu menu = new JPopupMenu();
        Component clickSource = null;

        public FunctionalityListener() {
            this.menu.add(new AbstractAction(UITexts.getString((String)"CommonUI.CAPTION_REMOVE")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent e) {
                    for (View v : AbstractSwingWorkbenchUI.this.currentViews) {
                        if (v.button != FunctionalityListener.this.clickSource) continue;
                        FunctionalityListener.this.clickSource = null;
                        AbstractSwingWorkbenchUI.this.platform.deactivatePlugIn((ActivePlugIn)v.plugin);
                        break;
                    }
                }
            });
        }

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            this.maybeShowPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.maybeShowPopup(e);
        }

        void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.clickSource = e.getComponent();
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            for (View v : AbstractSwingWorkbenchUI.this.currentViews) {
                if (src != v.button) continue;
                AbstractSwingWorkbenchUI.this.switchView(v);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class View {
        String name;
        UIActivePlugIn plugin;
        List<ActionSet> actionSets;
        Component ui;
        AbstractButton button;

        public List<ActionSet> getActionSets() {
            return this.actionSets;
        }

        public void setActionSets(List<ActionSet> actionSets) {
            this.actionSets = actionSets;
        }

        public AbstractButton getButton() {
            return this.button;
        }

        public void setButton(AbstractButton button) {
            this.button = button;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UIActivePlugIn getPlugin() {
            return this.plugin;
        }

        public void setPlugin(UIActivePlugIn plugin) {
            this.plugin = plugin;
        }

        public Component getUi() {
            return this.ui;
        }

        public void setUi(Component ui) {
            this.ui = ui;
        }
    }

    public class MenuManager {
        Map<JMenu, Integer> menuOrderMap = new HashMap<JMenu, Integer>();
        private Map<String, JMenu> menuIDMap = new HashMap<String, JMenu>();
        private JMenuBar managedBar;

        public MenuManager(JMenuBar menuBar) {
            this.managedBar = menuBar;
        }

        public JMenu getMenu(String id) {
            return this.menuIDMap.get(id);
        }

        private JMenu createMenu(String id, int order) {
            String[] ids = id.split(AbstractSwingWorkbenchUI.MENU_PATH_SEPARATOR);
            if (ids.length == 1) {
                JMenu menu = new JMenu(ids[0]);
                menu.setName(ids[0]);
                this.menuIDMap.put(menu.getName(), menu);
                return menu;
            }
            JMenu m1 = this.getOrCreateMenu(ids[0], order);
            JMenu m2 = this.createMenu(ids[1], order);
            m2.setName(ids[0] + AbstractSwingWorkbenchUI.MENU_PATH_SEPARATOR + ids[1]);
            this.menuIDMap.put(m2.getName(), m2);
            m2.setText(ids[1]);
            m1.add(m2);
            return m2;
        }

        public JMenu getOrCreateMenu(String id, int order) {
            JMenu menu = this.getMenu(id);
            if (menu == null && (menu = this.createMenu(id, order)).getName().indexOf(AbstractSwingWorkbenchUI.MENU_PATH_SEPARATOR) < 0) {
                this.addMenu(menu, order);
            }
            return menu;
        }

        private void addMenu(JMenu menu, int order) {
            this.menuOrderMap.put(menu, new Integer(order));
            ArrayList<JMenu> menuList = new ArrayList<JMenu>(this.menuOrderMap.keySet());
            Collections.sort(menuList, new Comparator<JMenu>(){

                @Override
                public int compare(JMenu o1, JMenu o2) {
                    return MenuManager.this.menuOrderMap.get(o1).compareTo(MenuManager.this.menuOrderMap.get(o2));
                }
            });
            this.managedBar.add((Component)menu, menuList.indexOf(menu));
            this.managedBar.validate();
        }

        public void remove(JMenu menu) {
            String id = menu.getName();
            this.menuIDMap.remove(id);
            String[] split = id.split(AbstractSwingWorkbenchUI.MENU_PATH_SEPARATOR);
            if (split.length == 1) {
                this.managedBar.remove(menu);
            } else {
                JMenu m = this.getMenu(split[0]);
                if (m != null) {
                    m.remove(menu);
                    if (m.getComponentCount() == 0) {
                        this.remove(m);
                    }
                }
            }
            this.managedBar.validate();
        }
    }
}

