/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.ui.swing.data;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.apptools.PlatformTexts;
import net.sf.apptools.data.DataHolder;
import net.sf.apptools.ui.swing.data.DataEditPanel;
import net.sf.apptools.ui.swing.data.DataEditorFactory;
import net.sf.apptools.ui.swing.utils.GUIUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHolderDialog
extends JDialog {
    static Log log = LogFactory.getLog(DataHolderDialog.class);
    private static final long serialVersionUID = 1L;
    protected DataHolder dataHolder;
    protected JButton OKBtn;
    protected JButton cancelBtn;
    protected JPanel buttonPanel;
    boolean inputOK = false;

    public DataHolderDialog(Frame frame, DataHolder holder, String title, DataEditorFactory factory) {
        super(frame, title, true);
        this.dataHolder = holder;
        this.setup(this.dataHolder.getData(), factory);
        this.pack();
        this.setLocation(GUIUtils.suggestLocation(this, frame));
    }

    private void setup(Map<String, Object> valueMap, DataEditorFactory factory) {
        final DataEditPanel editPanel = new DataEditPanel(this.dataHolder, valueMap, factory);
        final DataHolderDialog dialog = this;
        AbstractAction cancelAction = new AbstractAction(PlatformTexts.getString((String)"Common.CAPTION_CANCEL")){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
        AbstractAction okAction = new AbstractAction(PlatformTexts.getString((String)"Common.CAPTION_OK")){

            public void actionPerformed(ActionEvent e) {
                try {
                    DataHolderDialog.this.inputOK = editPanel.validateInput();
                    if (DataHolderDialog.this.inputOK) {
                        editPanel.applyInput();
                        dialog.dispose();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(dialog, ex);
                    log.error((Object)ex.toString(), (Throwable)ex);
                }
            }
        };
        this.getContentPane().setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(new JButton(okAction));
        this.buttonPanel.add(new JButton(cancelAction));
        editPanel.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 10));
        this.getContentPane().add((Component)editPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        InputMap im = this.getLayeredPane().getInputMap(2);
        ActionMap am = this.getLayeredPane().getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "close");
        im.put(KeyStroke.getKeyStroke(10, 0), "ok");
        am.put("close", cancelAction);
        am.put("ok", okAction);
        this.pack();
    }

    public boolean inputOK() {
        return this.inputOK;
    }
}

