/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.plugin;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import net.sf.apptools.plugin.PlugIn;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlugInUtils {
    static Log log = LogFactory.getLog(PlugInUtils.class);
    static final String METHOD_BRIEF = "getBriefDescription";
    static final String METHOD_LONG = "getLongDescription";
    static String NO_PLUG_IN_MESSAGE = "{0} is not a valid plugin class";
    static String NO_DESCRIPTION_MESSAGE = "No description found for {0}";

    public static String getBriefDescription(Object pluginInstance) {
        Class<?> c = pluginInstance.getClass();
        if (PlugIn.class.isAssignableFrom(c)) {
            try {
                Method getBD = c.getMethod(METHOD_BRIEF, new Class[0]);
                boolean isStatic = Modifier.isStatic(getBD.getModifiers());
                Object o = getBD.invoke(isStatic ? null : pluginInstance, new Object[0]);
                if (o != null) {
                    return o.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return c.getName();
    }

    public static String getBriefDescription(Class<?> pluginClass) {
        if (PlugIn.class.isAssignableFrom(pluginClass)) {
            try {
                Method staticGetBD = pluginClass.getMethod(METHOD_BRIEF, new Class[0]);
                Object o = staticGetBD.invoke(null, new Object[0]);
                if (o != null) {
                    return o.toString();
                }
            }
            catch (Throwable e) {
                log.warn((Object)e.toString());
                return pluginClass.getName();
            }
        }
        return pluginClass.getName();
    }

    public static String getLongDescription(Class<?> pluginClass) {
        if (PlugIn.class.isAssignableFrom(pluginClass)) {
            try {
                Method staticGetLD = pluginClass.getMethod(METHOD_LONG, new Class[0]);
                Object o = staticGetLD.invoke(null, new Object[0]);
                if (o != null) {
                    return o.toString();
                }
            }
            catch (Throwable e) {
                return "<html>" + MessageFormat.format(NO_DESCRIPTION_MESSAGE, "<i>" + pluginClass.getName() + "</i>") + "</html>";
            }
        }
        return "<html>" + MessageFormat.format(NO_PLUG_IN_MESSAGE, "<i>" + pluginClass.getName() + "</i>") + "</html>";
    }

    public static String getLongDescription(Object pluginInstance) {
        Class<?> c = pluginInstance.getClass();
        if (PlugIn.class.isAssignableFrom(c)) {
            try {
                Method getLD = c.getMethod(METHOD_LONG, new Class[0]);
                boolean isStatic = Modifier.isStatic(getLD.getModifiers());
                Object o = getLD.invoke(isStatic ? null : pluginInstance, new Object[0]);
                if (o != null) {
                    return o.toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "<html>" + MessageFormat.format(NO_DESCRIPTION_MESSAGE, "<i>" + c.getName() + "</i>") + "</html>";
    }

    public static boolean isValidPlugInClass(Class<?> pic) {
        if (pic == null) {
            return false;
        }
        if (pic.isInterface()) {
            return false;
        }
        if (Modifier.isAbstract(pic.getModifiers())) {
            return false;
        }
        try {
            Constructor<?> c = pic.getConstructor(null);
            return c != null;
        }
        catch (NoSuchMethodException e1) {
            return false;
        }
        catch (SecurityException e1) {
            log.error((Object)("Security exception for " + pic), (Throwable)e1);
            return false;
        }
    }

    public static boolean isValidPlugIn(Object valueRepr) {
        try {
            Constructor<?> c = valueRepr.getClass().getConstructor(null);
            return c != null;
        }
        catch (NoSuchMethodException e1) {
            return false;
        }
        catch (SecurityException e1) {
            log.error((Object)("Security exception for " + valueRepr.getClass()), (Throwable)e1);
            return false;
        }
    }
}

