/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.design;

import org.moltools.apps.probemaker.design.DefaultTagLibrary;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.Sequence;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.seq.db.impl.ListSequenceDB;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;
import org.moltools.lib.seq.impl.SimpleNucleotideSequence;

public class SpacerLibrary
extends DefaultTagLibrary {
    private static final long serialVersionUID = 1L;
    private byte type;
    private int[] nextIndices;
    protected static char[] baseSymbols = new char[]{'A', 'C', 'G', 'T'};
    protected static int symbolCount = 4;

    public SpacerLibrary(int length, byte acidType) {
        super((DefiniteSequenceDB<? extends NucleotideSequence>)new ListSequenceDB(), "Spacers");
        this.mode = 0;
        this.nextIndices = new int[length];
        this.type = acidType;
        SimpleChangeableNucleotideSequence proto = new SimpleChangeableNucleotideSequence("Spacer", "", 0);
        this.addSequence((Sequence)proto);
    }

    public boolean isUsable(int tagno, Probe p) {
        return true;
    }

    public int size() {
        return 1;
    }

    public NucleotideSequence getSequenceAt(int tagno) {
        return new SimpleNucleotideSequence("Spacer tag placeholder", "", 0);
    }

    public NucleotideSequence getNext() {
        if (this.nextIndices == null) {
            return null;
        }
        String seq = "";
        for (int i = 0; i < this.nextIndices.length; ++i) {
            seq = seq + baseSymbols[this.nextIndices[i]];
        }
        this.updateIndices();
        return new SimpleNucleotideSequence("Spacer " + seq, seq, this.type);
    }

    protected void updateIndices() {
        if (this.nextIndices.length == 0) {
            this.nextIndices = null;
            return;
        }
        for (int i = this.nextIndices.length - 1; i >= 0; --i) {
            if (this.nextIndices[i] < symbolCount - 1) {
                int n = i;
                this.nextIndices[n] = this.nextIndices[n] + 1;
                break;
            }
            if (i <= 0) {
                this.nextIndices = null;
                break;
            }
            this.nextIndices[i] = 0;
        }
    }
}

