/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.seq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.moltools.apps.probemaker.ProbeMakerConstants;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.impl.TSSPair;
import org.moltools.design.data.Target;
import org.moltools.design.data.impl.DefaultPropertySet;
import org.moltools.design.data.impl.SimpleProperty;
import org.moltools.design.properties.MutablePropertySet;
import org.moltools.design.properties.Property;
import org.moltools.design.properties.PropertyHolder;
import org.moltools.design.properties.PropertySet;
import org.moltools.design.utils.DesignUtils;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SequenceEdit;
import org.moltools.lib.seq.SequenceView;
import org.moltools.lib.seq.impl.SimpleChangeableNucleotideSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProbe
extends SimpleChangeableNucleotideSequence
implements Probe,
ProbeMakerConstants,
SequenceView {
    protected int downstreamBlocks;
    protected List<NucleotideSequence> tags;
    protected boolean tagsAllocated = false;
    protected TSSPair tssPair;
    protected int upstreamBlocks;
    protected MutablePropertySet mps = new DefaultPropertySet();

    public AbstractProbe(TSSPair pair, byte type) {
        super("", type);
        this.tags = new ArrayList<NucleotideSequence>();
        this.setTSSPair(pair);
    }

    public void addTag(NucleotideSequence tag) {
        this.tags.add(tag);
        this.sequence.replace(0, this.sequence.length(), this.composeSequence());
    }

    @Override
    public void addTagAt(NucleotideSequence tag, int pos) {
        this.tags.add(pos, tag);
        this.sequence.replace(0, this.sequence.length(), this.composeSequence());
    }

    public PropertySet getPropertySet() {
        return this.getMutablePropertySet();
    }

    public MutablePropertySet getMutablePropertySet() {
        return this.mps;
    }

    public void edit(SequenceEdit edit) {
        throw new UnsupportedOperationException("Operation not supported for probes");
    }

    @Override
    public abstract int getBlockNoOfTag(int var1);

    @Override
    public int getDownstreamBlockCount() {
        return this.downstreamBlocks;
    }

    public int getEndOfSequence(int blockno) {
        if (blockno < 1 || blockno > this.getSequenceCount()) {
            throw new IllegalArgumentException("No such block (" + blockno + ")");
        }
        int currentpos = 0;
        for (int i = 1; i <= blockno; ++i) {
            currentpos += ((NucleotideSequence)this.getSequence(i)).length();
        }
        return currentpos;
    }

    public int getSequenceCount() {
        return this.getTags().size() + 2;
    }

    public int getSequenceNumberAt(int pos) {
        if (pos < 1 || pos > this.length()) {
            throw new IllegalArgumentException("Position out of bounds: " + pos + "/" + this.length());
        }
        int currentpos = 0;
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            if (pos > (currentpos += ((NucleotideSequence)this.getSequence(i)).length())) continue;
            return i;
        }
        throw new IllegalArgumentException("Position not found: " + pos + "/" + this.length());
    }

    public List<NucleotideSequence> getSequences() {
        NucleotideSequence[] seqs = new NucleotideSequence[2 + this.tags.size()];
        for (int i = 0; i < seqs.length; ++i) {
            seqs[i] = (NucleotideSequence)this.getSequence(i + 1);
        }
        return Arrays.asList(seqs);
    }

    public int getStartOfSequence(int blockno) {
        if (blockno < 1 || blockno > this.getSequenceCount()) {
            throw new IllegalArgumentException("No such block (" + blockno + ")");
        }
        int currentpos = 1;
        for (int i = 1; i < blockno; ++i) {
            currentpos += ((NucleotideSequence)this.getSequence(i)).length();
        }
        return currentpos;
    }

    @Override
    public NucleotideSequence getTagAt(int pos) {
        return this.tags.get(pos);
    }

    @Override
    public abstract int getTagNoOfBlock(int var1);

    @Override
    public List<NucleotideSequence> getTags() {
        return this.tags;
    }

    @Override
    public Target getTarget() {
        return this.tssPair.getTarget();
    }

    @Override
    public TSSPair getTSSPair() {
        return this.tssPair;
    }

    @Override
    public int getUpstreamBlockCount() {
        return this.upstreamBlocks;
    }

    public String getViewName() {
        return this.getName();
    }

    public String getViewSequence() {
        String view = "";
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            if (i > 1) {
                view = view + '|';
            }
            view = view + ((NucleotideSequence)this.getSequence(i)).seqString();
        }
        return view;
    }

    public int length() {
        int length = 0;
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            length += ((NucleotideSequence)this.getSequence(i)).length();
        }
        return length;
    }

    @Override
    public void removeAllTags() {
        this.tags.clear();
        this.sequence.replace(0, this.sequence.length(), this.composeSequence());
    }

    @Override
    public void removeTagAt(int pos) {
        this.tags.remove(pos);
        this.sequence.replace(0, this.sequence.length(), this.composeSequence());
    }

    @Override
    public void setTagsAllocated(boolean alloc) {
        this.tagsAllocated = alloc;
    }

    @Override
    public boolean tagsAllocated() {
        return this.tagsAllocated;
    }

    protected String composeSequence() {
        StringBuffer sequencestring = new StringBuffer();
        for (int i = 1; i <= this.getSequenceCount(); ++i) {
            NucleotideSequence si = (NucleotideSequence)this.getSequence(i);
            sequencestring.append(si == null ? "" : si.seqString());
        }
        return sequencestring.toString();
    }

    protected void setTSSPair(TSSPair pair) {
        this.tssPair = pair;
        String targetID = pair == null ? null : DesignUtils.getTargetID((PropertyHolder)pair);
        this.mps.setProperty((Property)new SimpleProperty("moltools.targetID", (Object)targetID, false));
        this.sequence.replace(0, this.sequence.length(), this.composeSequence());
    }
}

