/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.apps.probemaker.ext.mod;

import net.sf.apptools.data.DataDescriptor;
import org.moltools.apps.probemaker.calculators.SWStructureCalculator;
import org.moltools.apps.probemaker.design.TagAllocator;
import org.moltools.apps.probemaker.messages.Message;
import org.moltools.apps.probemaker.messages.MessageType;
import org.moltools.apps.probemaker.modules.AbstractProbeModule;
import org.moltools.apps.probemaker.modules.TestDescriptor;
import org.moltools.apps.probemaker.seq.Probe;
import org.moltools.apps.probemaker.seq.ProbeMakerPropertyUtils;
import org.moltools.apps.probemaker.seq.ProbeMakerTarget;
import org.moltools.design.calc.Aligner;
import org.moltools.design.calc.ComplementCalculator;
import org.moltools.design.calc.SecStructCalculator;
import org.moltools.design.data.PropertyAcceptorNucleotideSequence;
import org.moltools.design.data.TargettedSubSequence;
import org.moltools.design.data.impl.SimpleSubSequenceTemplate;
import org.moltools.design.data.impl.TemplateHandler;
import org.moltools.design.properties.PropertyAcceptor;
import org.moltools.lib.seq.ClusterException;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.SubSequenceDescriptor;
import org.moltools.lib.seq.db.DefiniteSequenceDB;
import org.moltools.lib.struct.NAHybridStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHybInterferenceModule
extends AbstractProbeModule {
    protected transient SecStructCalculator complementStructCalc = new SWStructureCalculator();
    public static final int length = 5;
    public static final MessageType FIVE_PRIME_HYBRIDIZATION_INTERFERENCE = new MessageType("FIVE_PRIME_HYBRIDIZATION_INTERFERENCE", "5' hybridization interference");
    public static final MessageType THREE_PRIME_HYBRIDIZATION_INTERFERENCE = new MessageType("THREE_PRIME_HYBRIDIZATION_INTERFERENCE", "3' hybridization interference");

    public static String getBriefDescription() {
        return "Hybridization interference";
    }

    public static String getLongDescription() {
        return "<html>Determines whether the sequence adjacent to the target-specific sequences will interfere with the intended hybridization by extending the hybrid by one or more bases.<br>This is done by comparing performing a Smith-Waterman alignment of the TSS + adjoining sequence and the corresponding part of the target.<br>If the strongest alignment found is longer than the TSS, a hybridization interference message is given.</html>";
    }

    public DefaultHybInterferenceModule() {
        super(new TestDescriptor[]{new TestDescriptor("5' hybridization interference"), new TestDescriptor("3' hybridization interference")}, new DataDescriptor[0]);
        ((SWStructureCalculator)this.complementStructCalc).setLAC((Aligner)new ComplementCalculator());
    }

    public void doAnalysis(Probe p, TagAllocator ta, DefiniteSequenceDB<? extends Probe> otherProbes) {
        this.checkHybridizationInterference(p, ta);
    }

    protected void checkHybridizationInterference(Probe p, TagAllocator ta) {
        String tseq;
        ProbeMakerTarget t = (ProbeMakerTarget)p.getTarget();
        if (this.tests[0].perform()) {
            if (t == null) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 5' hybridization: No target found", FIVE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
            } else {
                PropertyAcceptorNucleotideSequence pa5;
                try {
                    pa5 = (PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("FIVE_PRIME");
                }
                catch (ClusterException e) {
                    pa5 = null;
                }
                TargettedSubSequence fiveTemplate = null;
                try {
                    fiveTemplate = (TargettedSubSequence)t.getTemplateCluster().getSequence("FIVE_PRIME");
                }
                catch (ClusterException e) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 5' hybridization: No 5' TSS template found", FIVE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
                }
                catch (ClassCastException cx) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 5' hybridization: 5' TSS template is not a subsequence", FIVE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
                }
                if (pa5 == null) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 5' hybridization: No 5' TSS found", FIVE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
                } else if (fiveTemplate != null) {
                    int probeend;
                    int pe;
                    int block;
                    int probebegin;
                    int pb;
                    String plong;
                    int end;
                    int targetLength = t.length();
                    tseq = t.seqString();
                    int probeLength = p.length();
                    int[] positions = TemplateHandler.subTemplatePositions((SubSequenceDescriptor)fiveTemplate, (int)pa5.length(), (byte)t.getFivePrimeFixedEnd());
                    int begin = positions[0];
                    String sequencelong = tseq.substring(begin - 5 - 1 < 0 ? 0 : begin - 5 - 1, (end = positions[1]) + 5 > targetLength ? targetLength : end + 5);
                    NAHybridStructure s1 = this.complementStructCalc.calculateStructure(sequencelong, plong = p.subsequence(pb = (probebegin = p.getStartOfSequence(block = p.getBlockNoOf5())) - 5 < 1 ? 1 : probebegin - 5, pe = (probeend = p.getEndOfSequence(block)) + 5 > probeLength ? probeLength : probeend + 5), t.getType(), p.getType());
                    if (s1.getSecondString().length() > pa5.length()) {
                        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Hybridization temp. of 5' arm may be incorrect. Other part of probe may hybridize to the target.", FIVE_PRIME_HYBRIDIZATION_INTERFERENCE, 1));
                        if (p.getTags().size() > 0) {
                            ta.setCurrentTagBad(0);
                        }
                    }
                }
            }
        }
        if (this.tests[1].perform()) {
            if (t == null) {
                ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 3' hybridization: No target found", THREE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
            } else {
                PropertyAcceptorNucleotideSequence pa3;
                try {
                    pa3 = (PropertyAcceptorNucleotideSequence)p.getTSSPair().getSequence("THREE_PRIME");
                }
                catch (ClusterException e) {
                    pa3 = null;
                }
                SimpleSubSequenceTemplate threeTemplate = null;
                try {
                    threeTemplate = (SimpleSubSequenceTemplate)t.getTemplateCluster().getSequence("THREE_PRIME");
                }
                catch (ClusterException e) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 3' hybridization: No 3' TSS template found", THREE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
                }
                catch (ClassCastException cx) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 3' hybridization: 3' TSS template is not a subsequence", THREE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
                }
                if (pa3 == null) {
                    ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Could not check 3' hybridization: No 3' TSS found", THREE_PRIME_HYBRIDIZATION_INTERFERENCE, 0));
                } else if (threeTemplate != null) {
                    int probeend;
                    int block;
                    int probebegin;
                    String plong;
                    int end;
                    int[] positions;
                    int begin;
                    int targetLength = t.length();
                    tseq = t.seqString();
                    String sequencelong = tseq.substring((begin = (positions = TemplateHandler.subTemplatePositions((SubSequenceDescriptor)threeTemplate, (int)pa3.length(), (byte)t.getThreePrimeFixedEnd()))[0]) - 5 - 1 < 0 ? 0 : begin - 5 - 1, (end = positions[1]) + 5 > targetLength ? targetLength : end + 5);
                    NAHybridStructure s1 = this.complementStructCalc.calculateStructure(sequencelong, plong = p.subsequence((probebegin = p.getStartOfSequence(block = p.getBlockNoOf3())) - 5 < 1 ? 1 : probebegin - 5, (probeend = p.getEndOfSequence(block)) + 5 > p.length() ? p.length() : end + 5), t.getType(), p.getType());
                    if (s1.getSecondString().length() > pa3.length()) {
                        ProbeMakerPropertyUtils.addMessage((PropertyAcceptor)p, (Message)new Message("Hybridization temp. of 3' arm may be incorrect. Other part of probe may hybridize to the target.", THREE_PRIME_HYBRIDIZATION_INTERFERENCE, 1));
                        int pos = p.getTags().size() - 1;
                        if (pos >= 0) {
                            ta.setCurrentTagBad(pos);
                        }
                    }
                }
            }
        }
    }

    public boolean acceptTag(NucleotideSequence t, DefiniteSequenceDB<? extends Probe> otherProbes) {
        return true;
    }

    public void reset() {
    }

    public void doConfirmUpdate(Probe p, TagAllocator ta, DefiniteSequenceDB<? extends Probe> otherProbes) {
    }
}

