/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.alphabet;

import java.util.Arrays;
import java.util.List;
import org.moltools.lib.seq.alphabet.Nucleotide;

public class DegenerateNucleotide
extends Nucleotide {
    protected Nucleotide[] possible;

    public DegenerateNucleotide(char symb, byte typ, Nucleotide[] poss) {
        super(symb, typ);
        this.possible = (Nucleotide[])poss.clone();
    }

    public Nucleotide[] getPossible() {
        return (Nucleotide[])this.possible.clone();
    }

    public boolean hasPossible(Nucleotide[] poss) {
        if (poss.length != this.possible.length) {
            return false;
        }
        for (int i = 0; i < this.possible.length; ++i) {
            boolean found = false;
            for (int j = 0; j < poss.length; ++j) {
                if (this.possible[i] != poss[j]) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        for (Nucleotide n : this.possible) {
            hc += n.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DegenerateNucleotide) {
            boolean contains;
            DegenerateNucleotide dn = (DegenerateNucleotide)obj;
            if (dn.possible.length != this.possible.length) {
                return false;
            }
            List<Nucleotide> pn1 = Arrays.asList(dn.possible);
            List<Nucleotide> pn2 = Arrays.asList(dn.possible);
            for (Nucleotide n1 : pn1) {
                contains = false;
                for (Nucleotide n2 : pn2) {
                    if (!n1.equals(n2)) continue;
                    contains = true;
                }
                if (contains) continue;
                return false;
            }
            for (Nucleotide n2 : pn2) {
                contains = false;
                for (Nucleotide n1 : pn1) {
                    if (!n2.equals(n1)) continue;
                    contains = true;
                }
                if (contains) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }
}

