/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.impl;

import org.moltools.lib.AbstractIdentifiable;
import org.moltools.lib.seq.NucleotideSequence;
import org.moltools.lib.seq.alphabet.Nucleotide;
import org.moltools.lib.seq.utils.NucleotideSequenceHandler;

public class SimpleNucleotideSequence
extends AbstractIdentifiable
implements NucleotideSequence {
    protected String sequence;
    protected byte type;

    protected SimpleNucleotideSequence() {
        this("", "");
    }

    public SimpleNucleotideSequence(String id, String seq) {
        this(id, seq, 0);
    }

    public SimpleNucleotideSequence(String id, String seq, byte type) {
        super(id);
        this.type = type;
        this.sequence = seq;
    }

    public String seqString() {
        return this.sequence;
    }

    public byte getType() {
        return this.type;
    }

    public int length() {
        return this.sequence.length();
    }

    public String subsequence(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException("Start index out of bounds: " + start);
        }
        if (end > this.length()) {
            throw new IllegalArgumentException("End index out of bounds: " + end + " > " + this.length());
        }
        if (start > end) {
            throw new IllegalArgumentException("Start index greater than end index: " + start + " > " + end);
        }
        return this.sequence.substring(start - 1, end);
    }

    public Nucleotide getNucleotideAt(int pos) {
        if (pos < 1 || pos > this.length()) {
            throw new ArrayIndexOutOfBoundsException("Trying to get a nucleotide outside of the sequence (" + pos + ")");
        }
        return NucleotideSequenceHandler.getNucleotide(this.sequence.charAt(pos - 1), this.type);
    }
}

