/*
 * Decompiled with CFR 0.152.
 */
package org.moltools.lib.seq.io.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.moltools.lib.seq.io.SequenceDataReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenBankInputFormatter
implements SequenceDataReader {
    static final String ENTRY_END = "//";
    static final String SEQUENCE = "ORIGIN";
    static final String ACCESSION = "ACCESSION";
    static final String DEFINITION = "DEFINITION";
    static final String REGION = "REGION";

    @Override
    public Map<String, String> readNextFormattedSequence(BufferedReader r) throws IOException {
        String name = "";
        String id = "";
        StringBuffer sequence = new StringBuffer("");
        boolean done = false;
        String line = "";
        boolean seqstarted = false;
        while (!done) {
            line = r.readLine();
            if (line == null) {
                return null;
            }
            if (line.startsWith(ENTRY_END)) {
                done = true;
                continue;
            }
            if (line.startsWith(DEFINITION)) {
                name = line.substring(line.indexOf(32) + 1);
                continue;
            }
            if (line.startsWith(ACCESSION)) {
                int endIndex = line.indexOf(" ", 12);
                String string = id = endIndex > 0 ? line.substring(12, endIndex) : line.substring(13);
                int regIndex = line.indexOf(REGION);
                if (regIndex <= 0) continue;
                id = id + ":" + line.substring(regIndex + 8);
                continue;
            }
            if (line.startsWith(SEQUENCE)) {
                seqstarted = true;
                continue;
            }
            if (!seqstarted) continue;
            sequence.append(GenBankInputFormatter.eatSpace(line).toUpperCase());
        }
        name = name.substring(1);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("sequence.name", name);
        m.put("ID", id);
        m.put("sequence.seqstring", sequence.toString());
        return m;
    }

    public static String eatSpace(String str) {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c) || Character.isDigit(c)) continue;
            s.append(c);
        }
        return s.toString();
    }
}

