package Bio::Disperse::CcdsHandle;

use strict;

my $STRAND_FWD = '+';
my $STRAND_REV = '-';

my $strand_convert = { $STRAND_FWD=> 1, $STRAND_REV=> -1 };

sub new {
	my ($package, $ccds_file) = @_;
		
	my $this = {};
	open(CCDS_FILE, $ccds_file) || die "could not open $ccds_file: $!\n";
	while (<CCDS_FILE>) {
		chomp;
		if (/Public/ && $_ !~ /^#/) { 
			my ($chr, $g_accession, $gene_name, $gene_id, $ccds_id, $ccds_status, $cds_strand, $cds_from, $cds_to, $cds_locations) =
				split "\t", $_;
			if ( !defined($this->{$gene_name}) ) {
				$this->{$gene_name} = {};
			}
			
			$cds_locations =~ s/\[|\]//g;
			my @cds_locations = split(", ", $cds_locations);
			$this->{$gene_name}->{$ccds_id} = 	{ 	chr => $chr, 
													g_accession => $g_accession,
													gene_name => $gene_name,
													gene_id => $gene_id,
													ccds_id => $ccds_id,
													cds_strand => $strand_convert->{$cds_strand},
													cds_from => $cds_from,
													cds_to => $cds_to,
													cds_locations => \@cds_locations
												}
		}
	}
	bless $this, $package;
}

sub get_gene_exon_coords {
	my $this = shift;
	my $gene_name = shift || die "Missing argument (gene_name) for get_gene_exon_coord.\n";
	
	return $this->{$gene_name};
}

sub debug {
	my $this = shift;
	for (sort(keys(%$this))) {
		print "$_\n";
	}
}