package Bio::Disperse::FastaCmd;

use strict;

sub new {
	my ($package, $fastacmd_bin, $fastacmd_blastdb) = @_;
	my $this = {};
	$this->{'blastdb'} = $fastacmd_blastdb;
	$this->{'fastacmd'} = $fastacmd_bin;	
	
	bless $this, $package;
}

sub get_fasta
{
	my ($this, $id, $start_1based, $end_1based, $polarity) = @_;
	# change polarity to 1 & 2
	if ($polarity == -1) { $polarity = 2; }
	my $cmd = "$this->{'fastacmd'} -d $this->{'blastdb'} -s $id -L $start_1based,$end_1based -S $polarity";
	return `$cmd`;
}
1;