/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import net.sf.apptools.CoreEngine;
import net.sf.apptools.plugin.DefaultPlugInManager;
import net.sf.apptools.plugin.PlugInManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bootstrap {
    static final Log log = LogFactory.getLog(Bootstrap.class);

    public static void main(String[] args) {
        ResourceBundle rb = ResourceBundle.getBundle("apptools.runtargets");
        if (args.length < 1) {
            log.error((Object)"No run target specified.");
            System.err.println("No run target specified.");
            System.exit(1);
        } else {
            String target = args[0];
            String[] targetArgs = new String[args.length - 1];
            System.arraycopy(args, 1, targetArgs, 0, targetArgs.length);
            log.debug((Object)("Running target " + target + " with " + targetArgs.length + " arguments"));
            DefaultPlugInManager pim = new DefaultPlugInManager();
            CoreEngine engine = new CoreEngine((PlugInManager)pim, null);
            try {
                Class targetClass = engine.getClassLoader().loadClass(rb.getString(target));
                Method main = targetClass.getMethod("main", String[].class);
                main.invoke(null, new Object[]{targetArgs});
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"Could not create run target", (Throwable)e);
                System.exit(1);
            }
            catch (SecurityException e) {
                log.error((Object)("Could not access run method on target " + target), (Throwable)e);
                System.exit(1);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)("Could not create run method on target " + target), (Throwable)e);
                System.exit(1);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Error invoking run method on target " + target), (Throwable)e);
                System.exit(1);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Could not access run method on target " + target), (Throwable)e);
                System.exit(1);
            }
            catch (InvocationTargetException e) {
                log.error((Object)("Error invoking run method on target " + target), (Throwable)e);
                System.exit(1);
            }
            System.exit(0);
        }
    }
}

