/*
 * Decompiled with CFR 0.152.
 */
package net.sf.apptools.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.apptools.actions.EnabledStateChangeListener;
import net.sf.apptools.actions.UserAction;

public abstract class AbstractUserAction
implements UserAction {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected boolean enabled = true;
    protected List<EnabledStateChangeListener> listeners = new ArrayList<EnabledStateChangeListener>();

    public AbstractUserAction(String caption, String tooltip) {
        this.properties.put("net.sf.apptools.UserAction.caption", caption);
        this.properties.put("net.sf.apptools.UserAction.tooltip", tooltip);
    }

    public Object getValue(String key) {
        return this.properties.get(key);
    }

    public void putValue(String key, Object value) {
        this.properties.put(key, value);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.fireEnabledStateChange();
    }

    protected void fireEnabledStateChange() {
        for (EnabledStateChangeListener est : this.listeners) {
            est.enabledStateChanged(this);
        }
    }

    public void addEnabledStateChangeListener(EnabledStateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeEnabledStateChangeListener(EnabledStateChangeListener listener) {
        this.listeners.remove(listener);
    }
}

